/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Locale;
import java.util.Objects;

public class WarcDigest {
    private final String algorithm;
    private final String value;

    public WarcDigest(String digest) {
        int i = digest.indexOf(58);
        if (i == -1) {
            throw new IllegalArgumentException("Invalid WARC-Digest");
        }
        this.algorithm = digest.substring(0, i);
        this.value = WarcDigest.base32Encode(digest.substring(i + 1), this.algorithm);
    }

    public WarcDigest(String algorithm, String value) {
        this.algorithm = algorithm;
        this.value = WarcDigest.base32Encode(value, algorithm);
    }

    public WarcDigest(String algorithm, byte[] value) {
        this(algorithm, WarcDigest.base32Encode(value));
    }

    public WarcDigest(MessageDigest messageDigest) {
        this.algorithm = messageDigest.getAlgorithm().replace("-", "").toLowerCase(Locale.US);
        this.value = WarcDigest.base32Encode(messageDigest.digest());
    }

    public String algorithm() {
        return this.algorithm;
    }

    public String hex() {
        return WarcDigest.hexEncode(this.bytes());
    }

    public String base16() {
        return this.hex();
    }

    public String base32() {
        return this.value;
    }

    public String base64() {
        return WarcDigest.base64Encode(this.bytes());
    }

    public byte[] bytes() {
        return WarcDigest.base32Decode(this.value);
    }

    public String toString() {
        return this.prefixedBase32();
    }

    public String prefixedBase32() {
        return this.algorithm + ":" + this.value;
    }

    static String hexEncode(byte[] data) {
        StringBuilder out = new StringBuilder(data.length * 2);
        for (byte b : data) {
            out.append("0123456789abcdef".charAt((b & 0xF0) >>> 4));
            out.append("0123456789abcdef".charAt(b & 0xF));
        }
        return out.toString();
    }

    static byte[] hexDecode(String data) {
        if (data.length() % 2 == 1) {
            throw new IllegalArgumentException("Length of hex-encoded string (Base16) must be a multiple of 2, but is " + data.length());
        }
        byte[] out = new byte[data.length() / 2];
        for (int i = 0; i < out.length; ++i) {
            int v = Character.digit(data.charAt(i * 2), 16) << 4;
            out[i] = (byte)(v += Character.digit(data.charAt(i * 2 + 1), 16));
        }
        return out;
    }

    static String base32Encode(byte[] data) {
        int j;
        StringBuilder out = new StringBuilder(data.length / 5 * 8);
        int leftover = 0;
        long bits = 0L;
        int i = 0;
        while (i < data.length) {
            bits = 0L;
            for (j = 0; j < 5; ++j) {
                if (i >= data.length) {
                    bits = bits << 8 | 0L;
                    ++leftover;
                    continue;
                }
                bits = bits << 8 | (long)(data[i++] & 0xFF);
            }
            if (leftover > 0) break;
            for (j = 0; j < 8; ++j) {
                out.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567".charAt((int)(bits >> 5 * (7 - j)) & 0x1F));
            }
        }
        if (leftover > 0) {
            int trailing = 7 - (5 - leftover) * 8 / 5;
            for (j = 0; j < 8 - trailing; ++j) {
                out.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567".charAt((int)(bits >> 5 * (7 - j)) & 0x1F));
            }
            for (j = 0; j < trailing; ++j) {
                out.append('=');
            }
        }
        return out.toString();
    }

    static byte[] base32Decode(String data) {
        int padding = 0;
        int outLength = data.length() / 8 * 5;
        if (data.length() % 8 > 0) {
            outLength += 5;
        }
        byte[] out = new byte[outLength];
        int i = 0;
        int k = 0;
        while (k < out.length) {
            int j;
            long bits = 0L;
            for (j = 0; j < 8; ++j) {
                int value;
                int c = 61;
                if (i < data.length()) {
                    c = data.charAt(i++) | 0x20;
                }
                if (c >= 97 && c <= 122) {
                    value = c - 97;
                } else if (c >= 50 && c <= 55) {
                    value = c - 50 + 26;
                } else if (c == 61) {
                    value = 0;
                    ++padding;
                } else {
                    throw new IllegalArgumentException("Invalid base32 character: " + c + " '" + (char)c + "'");
                }
                bits = bits << 5 | (long)value;
            }
            for (j = 0; j < 5; ++j) {
                out[k++] = (byte)(bits >> 8 * (4 - j) & 0xFFL);
            }
        }
        if (padding > 0) {
            int trim = 5 - (43 - 5 * padding) / 8;
            out = Arrays.copyOfRange(out, 0, out.length - trim);
        }
        return out;
    }

    static String base32Encode(String value, String algorithm) {
        try {
            int length = WarcDigest.getDigester(algorithm).getDigestLength();
            if (length * 2 == value.length()) {
                return WarcDigest.base32Encode(WarcDigest.hexDecode(value));
            }
            if (length * 8 / 5 > value.length() && length * 8 / 6 <= value.length()) {
                return WarcDigest.base32Encode(Base64.getDecoder().decode(value));
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return value;
    }

    static String base64Encode(byte[] data) {
        return Base64.getEncoder().encodeToString(data);
    }

    static byte[] base64Decode(String data) {
        return Base64.getDecoder().decode(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WarcDigest digest = (WarcDigest)o;
        return Objects.equals(this.algorithm, digest.algorithm) && Objects.equals(this.value, digest.value);
    }

    public int hashCode() {
        return Objects.hash(this.algorithm, this.value);
    }

    public static MessageDigest getDigester(String algorithm) throws NoSuchAlgorithmException {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            if (algorithm.toLowerCase(Locale.ROOT).startsWith("sha")) {
                algorithm = "SHA-" + algorithm.substring(3);
            }
            return MessageDigest.getInstance(algorithm);
        }
    }

    public MessageDigest getDigester() throws NoSuchAlgorithmException {
        return WarcDigest.getDigester(this.algorithm);
    }
}

