/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.subscription.service;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.transaction.Transactional;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagementEngine;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagementEngineProvider;
import org.silverpeas.core.contribution.contentcontainer.content.ContentPeas;
import org.silverpeas.core.contribution.contentcontainer.content.SilverContentInterface;
import org.silverpeas.core.contribution.contentcontainer.content.SilverContentVisibility;
import org.silverpeas.core.contribution.contentcontainer.content.SilverpeasContentManager;
import org.silverpeas.core.notification.user.builder.UserNotificationBuilder;
import org.silverpeas.core.notification.user.builder.helper.UserNotificationHelper;
import org.silverpeas.core.pdc.classification.Criteria;
import org.silverpeas.core.pdc.classification.Value;
import org.silverpeas.core.pdc.subscription.model.PdcSubscription;
import org.silverpeas.core.pdc.subscription.model.PdcSubscriptionRuntimeException;
import org.silverpeas.core.pdc.subscription.service.PdcResourceClassificationUserNotification;
import org.silverpeas.core.pdc.subscription.service.PdcSubscriptionDAO;
import org.silverpeas.core.pdc.subscription.service.PdcSubscriptionDeletionUserNotification;
import org.silverpeas.core.pdc.subscription.service.PdcSubscriptionService;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
@Transactional
public class DefaultPdcSubscriptionService
implements PdcSubscriptionService {
    @Override
    public List<PdcSubscription> getPDCSubscriptionByUserId(int userId) {
        List<PdcSubscription> list;
        block8: {
            Connection conn = DBUtil.openConnection();
            try {
                list = PdcSubscriptionDAO.getPDCSubscriptionByUserId(conn, userId);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException re) {
                    throw new PdcSubscriptionRuntimeException("PdcSubscriptionBmEJB.getPDCSubscriptionByUserId", 4, "PdcSubscription.CANNOT_FIND_SUBSCRIPTION_BYUSID", String.valueOf(userId), re);
                }
            }
            conn.close();
        }
        return list;
    }

    @Override
    public PdcSubscription getPDCSubsriptionById(int id) {
        PdcSubscription result = null;
        try (Connection conn = DBUtil.openConnection();){
            result = PdcSubscriptionDAO.getPDCSubsriptionById(conn, id);
        }
        catch (SQLException re) {
            throw new PdcSubscriptionRuntimeException("PdcSubscriptionBmEJB.getPDCSubsriptionById", 4, "PdcSubscription.CANNOT_FIND_SUBSCRIPTION_BYUSID", String.valueOf(id), re);
        }
        if (result == null) {
            throw new PdcSubscriptionRuntimeException("PdcSubscriptionBmEJB.getPDCSubsriptionById", 4, "PdcSubscription.NO_SUBSCRIPTION_WITH_ID", String.valueOf(id));
        }
        return result;
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public int createPDCSubscription(PdcSubscription subscription) {
        int n;
        block8: {
            Connection conn = DBUtil.openConnection();
            try {
                n = PdcSubscriptionDAO.createPDCSubscription(conn, subscription);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception re) {
                    throw new PdcSubscriptionRuntimeException("PdcSubscriptionBmEJB.createPDCSubscription", 4, "PdcSubscription.CANNOT_CREATE_SUBSCRIPTION", subscription, re);
                }
            }
            conn.close();
        }
        return n;
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void updatePDCSubscription(PdcSubscription subscription) {
        try (Connection conn = DBUtil.openConnection();){
            PdcSubscriptionDAO.updatePDCSubscription(conn, subscription);
        }
        catch (SQLException re) {
            throw new PdcSubscriptionRuntimeException("PdcSubscriptionBmEJB.updatePDCSubscription", 4, "PdcSubscription.CANNOT_UPDATE_SUBSCRIPTION", subscription, re);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void removePDCSubscriptionById(int id) {
        try (Connection conn = DBUtil.openConnection();){
            PdcSubscriptionDAO.removePDCSubscriptionById(conn, id);
        }
        catch (SQLException re) {
            throw new PdcSubscriptionRuntimeException("PdcSubscriptionBmEJB.removePDCSubscriptionById", 4, "PdcSubscription.CANNOT_DELETE_SUBSCRIPTION", String.valueOf(id), re);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void removePDCSubscriptionById(int[] ids) {
        try (Connection conn = DBUtil.openConnection();){
            PdcSubscriptionDAO.removePDCSubscriptionById(conn, ids);
        }
        catch (SQLException re) {
            throw new PdcSubscriptionRuntimeException("PdcSubscriptionBmEJB.removePDCSubscriptionById", 4, "PdcSubscription.CANNOT_DELETE_SUBSCRIPTION", Arrays.toString(ids), re);
        }
    }

    @Override
    public void checkAxisOnDelete(int axisId, String axisName) {
        try (Connection conn = DBUtil.openConnection();){
            List<PdcSubscription> subscriptions = PdcSubscriptionDAO.getPDCSubscriptionByUsedAxis(conn, axisId);
            if (subscriptions == null || subscriptions.isEmpty()) {
                return;
            }
            int[] pdcIds = new int[subscriptions.size()];
            for (int i = 0; i < subscriptions.size(); ++i) {
                PdcSubscription subscription = subscriptions.get(i);
                pdcIds[i] = subscription.getId();
                UserNotificationHelper.buildAndSend((UserNotificationBuilder)new PdcSubscriptionDeletionUserNotification(subscription, axisName, false));
            }
            PdcSubscriptionDAO.removePDCSubscriptionById(conn, pdcIds);
        }
        catch (SQLException e) {
            throw new PdcSubscriptionRuntimeException("PdcSubscriptionBmEJB.checkAxisOnDelete", 4, "PdcSubscription.EX_CHECK_AXIS_FALIED", e);
        }
    }

    @Override
    public void checkValueOnDelete(int axisId, String axisName, List<String> oldPath, List<String> newPath, List<org.silverpeas.core.pdc.pdc.model.Value> pathInfo) {
        try (Connection conn = DBUtil.openConnection();){
            List<PdcSubscription> subscriptions = PdcSubscriptionDAO.getPDCSubscriptionByUsedAxis(conn, axisId);
            if (subscriptions == null || subscriptions.isEmpty()) {
                return;
            }
            int[] removeIds = new int[subscriptions.size()];
            int removeLength = 0;
            for (PdcSubscription subscription : subscriptions) {
                if (!this.checkSubscriptionRemove(subscription, axisId, oldPath, newPath)) continue;
                UserNotificationHelper.buildAndSend((UserNotificationBuilder)new PdcSubscriptionDeletionUserNotification(subscription, axisName, true));
                removeIds[removeLength] = subscription.getId();
                ++removeLength;
            }
            int[] ids = new int[removeLength];
            System.arraycopy(removeIds, 0, ids, 0, removeLength);
            PdcSubscriptionDAO.removePDCSubscriptionById(conn, ids);
        }
        catch (SQLException e) {
            throw new PdcSubscriptionRuntimeException("PdcSubscriptionBmEJB.checkValueOnDelete", 4, "PdcSubscription.EX_CHECK_AXIS_FALIED", e);
        }
    }

    @Override
    public void checkSubscriptions(List<? extends Value> classifyValues, String componentId, int silverObjectid) {
        OrganizationController organizationController = OrganizationControllerProvider.getOrganisationController();
        try (Connection conn = DBUtil.openConnection();){
            boolean contentObjectIsVisible;
            ContentManagementEngine contentMgtEngine = ContentManagementEngineProvider.getContentManagementEngine();
            SilverContentVisibility scv = contentMgtEngine.getSilverContentVisibility(silverObjectid);
            boolean bl = contentObjectIsVisible = scv.isVisible() == 1;
            if (contentObjectIsVisible) {
                List<PdcSubscription> subscriptions = PdcSubscriptionDAO.getAllPDCSubscriptions(conn);
                for (PdcSubscription subscription : subscriptions) {
                    String userId;
                    if (!this.isCorrespondingSubscription(subscription, classifyValues) || !organizationController.isComponentAvailableToUser(componentId, userId = String.valueOf(subscription.getOwnerId()))) continue;
                    SilverContentInterface silverContent = this.getSilverContent(componentId, silverObjectid, userId);
                    if (silverContent != null) {
                        UserNotificationHelper.buildAndSend((UserNotificationBuilder)new PdcResourceClassificationUserNotification(subscription, silverContent));
                        continue;
                    }
                    SilverLogger.getLogger((Object)this).warn("User {0} now alloawed to see the content {1}", new Object[]{userId, silverObjectid});
                }
            }
        }
        catch (Exception e) {
            throw new PdcSubscriptionRuntimeException("PdcSubscriptionBmEJB.checkSubscriptions", 4, "PdcSubscription.EX_CHECK_SUBSCR_FALIED", classifyValues, e);
        }
    }

    private SilverContentInterface getSilverContent(String componentId, int silverObjectId, String userId) {
        List silverContents;
        try {
            ContentManagementEngine contentMgtEngine = ContentManagementEngineProvider.getContentManagementEngine();
            ContentPeas contentPeas = contentMgtEngine.getContentPeas(componentId);
            SilverpeasContentManager silverpeasContentManager = contentPeas.getContentManager();
            List<Integer> silverContentIds = Collections.singletonList(silverObjectId);
            List resourceReferences = contentMgtEngine.getResourceReferencesByContentIds(silverContentIds);
            silverContents = silverpeasContentManager.getSilverContentByReference(resourceReferences, userId);
        }
        catch (Exception e) {
            throw new PdcSubscriptionRuntimeException("PdcSubscriptionBmEJB.sendSubscriptionNotif", 4, "PdcSubscription.EX_CHECK_SUBSCR_FALIED", e);
        }
        if (CollectionUtil.isNotEmpty((Collection)silverContents)) {
            return (SilverContentInterface)silverContents.get(0);
        }
        return null;
    }

    protected boolean checkSubscriptionRemove(PdcSubscription subscription, int axisId, List<String> oldPath, List<String> newPath) {
        List<? extends Criteria> subscriptionCtx = subscription.getPdcContext();
        for (Criteria criteria : subscriptionCtx) {
            if (criteria.getAxisId() != axisId || !this.checkValuesRemove(criteria.getValue(), oldPath, newPath)) continue;
            return true;
        }
        return false;
    }

    protected boolean checkValuesRemove(String originalPath, List<String> oldPath, List<String> newPath) {
        if (!((String)originalPath).endsWith("/")) {
            originalPath = (String)originalPath + "/";
        }
        int idx = ((String)originalPath).lastIndexOf("/", ((String)originalPath).length() - 2);
        String value = ((String)originalPath).substring(idx, ((String)originalPath).length());
        boolean result = false;
        if (this.checkValueInPath(value, oldPath) && !this.checkValueInPath(value, newPath)) {
            result = true;
        }
        return result;
    }

    protected boolean checkValueInPath(String value, List<String> pathList) {
        for (String path : pathList) {
            String currentPath = path;
            if (currentPath == null) {
                currentPath = "/0/";
            }
            if (!currentPath.contains(value)) continue;
            return true;
        }
        return false;
    }

    protected boolean isCorrespondingSubscription(PdcSubscription subscription, List<? extends Value> classifyValues) {
        List<? extends Criteria> searchCriterias = subscription.getPdcContext();
        if (searchCriterias == null || classifyValues == null || searchCriterias.isEmpty() || classifyValues.isEmpty() || searchCriterias.size() > classifyValues.size()) {
            return false;
        }
        for (Criteria criteria : searchCriterias) {
            if (criteria == null) continue;
            boolean result = false;
            for (Value value : classifyValues) {
                if (!this.checkValues(criteria, value)) continue;
                result = true;
                break;
            }
            if (result) continue;
            return false;
        }
        return true;
    }

    protected boolean checkValues(Criteria criteria, Value searchValue) {
        return searchValue.getAxisId() == criteria.getAxisId() && searchValue.getValue().startsWith(criteria.getValue(), 0);
    }
}

