/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.pdc.service;

import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagementEngine;
import org.silverpeas.core.contribution.contentcontainer.content.ContentPeas;
import org.silverpeas.core.contribution.contentcontainer.content.GlobalSilverContent;
import org.silverpeas.core.contribution.contentcontainer.content.GlobalSilverContentProcessor;
import org.silverpeas.core.contribution.contentcontainer.content.SilverpeasContentManager;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.index.indexing.model.IndexEngineProxy;
import org.silverpeas.core.pdc.classification.ClassifyEngine;
import org.silverpeas.core.pdc.classification.ObjectValuePair;
import org.silverpeas.core.pdc.classification.PertinentAxis;
import org.silverpeas.core.pdc.classification.Position;
import org.silverpeas.core.pdc.pdc.model.Axis;
import org.silverpeas.core.pdc.pdc.model.AxisHeader;
import org.silverpeas.core.pdc.pdc.model.AxisHeaderI18N;
import org.silverpeas.core.pdc.pdc.model.AxisHeaderPersistence;
import org.silverpeas.core.pdc.pdc.model.AxisPK;
import org.silverpeas.core.pdc.pdc.model.ClassifyPosition;
import org.silverpeas.core.pdc.pdc.model.ClassifyValue;
import org.silverpeas.core.pdc.pdc.model.PdcAxisValue;
import org.silverpeas.core.pdc.pdc.model.PdcException;
import org.silverpeas.core.pdc.pdc.model.PdcRuntimeException;
import org.silverpeas.core.pdc.pdc.model.SearchAxis;
import org.silverpeas.core.pdc.pdc.model.SearchContext;
import org.silverpeas.core.pdc.pdc.model.SearchCriteria;
import org.silverpeas.core.pdc.pdc.model.UsedAxis;
import org.silverpeas.core.pdc.pdc.model.Value;
import org.silverpeas.core.pdc.pdc.service.AxisHeaderI18NDAO;
import org.silverpeas.core.pdc.pdc.service.PdcClassificationService;
import org.silverpeas.core.pdc.pdc.service.PdcClassifyManager;
import org.silverpeas.core.pdc.pdc.service.PdcManager;
import org.silverpeas.core.pdc.pdc.service.PdcRightsDAO;
import org.silverpeas.core.pdc.pdc.service.PdcSettings;
import org.silverpeas.core.pdc.pdc.service.PdcUtilizationService;
import org.silverpeas.core.pdc.subscription.service.PdcSubscriptionManager;
import org.silverpeas.core.pdc.tree.model.TreeManagerException;
import org.silverpeas.core.pdc.tree.model.TreeNode;
import org.silverpeas.core.pdc.tree.model.TreeNodePK;
import org.silverpeas.core.pdc.tree.service.TreeService;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.bean.BeanCriteria;
import org.silverpeas.core.persistence.jdbc.bean.PersistenceException;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBeanDAO;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBeanDAOFactory;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasEntityBean;
import org.silverpeas.core.security.authorization.AccessControlContext;
import org.silverpeas.core.security.authorization.AccessControlOperation;
import org.silverpeas.core.security.authorization.PublicationAccessControl;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
public class GlobalPdcManager
implements PdcManager {
    private static final String UNKNOWN = "unknown";
    private static final String KMELIA_COMPONENT_NAME = "kmelia";
    private static final String AXIS_TYPE = "AxisType";
    private static final String AXIS_ORDER = "AxisOrder";
    private SilverpeasBeanDAO<AxisHeaderPersistence> dao = null;
    @Inject
    private AxisHeaderI18NDAO axisHeaderI18NDAO;
    @Inject
    private PdcUtilizationService pdcUtilizationService;
    @Inject
    private PdcClassifyManager pdcClassifyManager;
    @Inject
    private ContentManagementEngine contentMgtEngine;
    @Inject
    private PdcClassificationService pdcClassificationService;
    @Inject
    private PdcSubscriptionManager pdcSubscriptionManager;
    @Inject
    private TreeService treeService;
    private static final Map<String, AxisHeader> axisHeaders = Collections.synchronizedMap(new HashMap());

    protected GlobalPdcManager() {
        try {
            this.dao = SilverpeasBeanDAOFactory.getDAO(AxisHeaderPersistence.class);
        }
        catch (PersistenceException exceDAO) {
            SilverLogger.getLogger((Object)this).error("Cannot get DAO for AxisHeader", (Throwable)exceDAO);
        }
    }

    @Override
    public List<GlobalSilverContent> findGlobalSilverContents(SearchContext containerPosition, List<String> componentIds, boolean recursiveSearch, boolean visibilitySensitive) {
        ArrayList<Integer> silverContentIds;
        try {
            silverContentIds = new ArrayList<Integer>(this.findSilverContentIdByPosition(containerPosition, componentIds, recursiveSearch, visibilitySensitive));
        }
        catch (PdcException c) {
            throw new PdcRuntimeException((Throwable)((Object)c));
        }
        return this.getSilverContentsByIds(silverContentIds, containerPosition.getUserId());
    }

    @Override
    public List<AxisHeader> getAxisByType(String type) throws PdcException {
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)AXIS_TYPE, (Object)type);
            criteria.setAscOrderBy(new String[]{AXIS_ORDER});
            Collection axis = this.dao.findBy(criteria);
            return this.persistence2AxisHeaders(axis);
        }
        catch (PersistenceException exSelect) {
            throw new PdcException(exSelect);
        }
    }

    private List<AxisHeader> persistence2AxisHeaders(Collection<AxisHeaderPersistence> silverpeasBeans) {
        ArrayList<AxisHeader> resultingAxisHeaders = new ArrayList<AxisHeader>();
        if (silverpeasBeans != null) {
            for (AxisHeaderPersistence silverpeasBean : silverpeasBeans) {
                AxisHeader axisHeader = new AxisHeader(silverpeasBean);
                this.setTranslations(axisHeader);
                resultingAxisHeaders.add(axisHeader);
            }
        }
        return resultingAxisHeaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTranslations(AxisHeader axisHeader) {
        String axisId = axisHeader.getPK().getId();
        AxisHeaderI18N translation = new AxisHeaderI18N(axisId, axisHeader.getLanguage(), axisHeader.getName(), axisHeader.getDescription());
        axisHeader.addTranslation(translation);
        Connection con = null;
        try {
            con = this.openConnection();
            List<AxisHeaderI18N> translations = this.axisHeaderI18NDAO.getTranslations(con, axisId);
            for (AxisHeaderI18N tr : translations) {
                axisHeader.addTranslation(tr);
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("Error to set translations for axis {0}", (Object[])new String[]{axisHeader.getName()}, (Throwable)e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public List<AxisHeader> getAxis() throws PdcException {
        try {
            BeanCriteria criteria = BeanCriteria.emptyCriteria();
            criteria.setAscOrderBy(new String[]{AXIS_TYPE, AXIS_ORDER});
            Collection axis = this.dao.findBy(criteria);
            return this.persistence2AxisHeaders(axis);
        }
        catch (PersistenceException exSelect) {
            throw new PdcException(exSelect);
        }
    }

    @Override
    public int getNbAxis() throws PdcException {
        return this.getAxis().size();
    }

    @Override
    public int getNbMaxAxis() {
        return ClassifyEngine.getMaxAxis();
    }

    @Override
    public int createAxis(AxisHeader axisHeader) throws PdcException {
        int status = 0;
        List<AxisHeader> axis = this.getAxis();
        if (axis.size() > this.getNbMaxAxis()) {
            status = 1;
        } else if (this.isAxisNameExist(axis, axisHeader)) {
            status = 2;
        } else {
            Connection con = null;
            try {
                con = this.openTransaction();
                int order = axisHeader.getAxisOrder();
                String type = axisHeader.getAxisType();
                BeanCriteria criteria = BeanCriteria.addCriterion((String)AXIS_TYPE, (Object)type).and(AXIS_ORDER, BeanCriteria.OPERATOR.GREATER_OR_EQUAL, (Object)order);
                criteria.setAscOrderBy(new String[]{AXIS_ORDER});
                Collection axisToUpdate = this.dao.findBy(criteria);
                for (AxisHeaderPersistence axisToMove : axisToUpdate) {
                    axisToMove.setAxisOrder(++order);
                    this.dao.update(con, (SilverpeasEntityBean)axisToMove);
                }
                Value value = new Value(UNKNOWN, Integer.toString(axisHeader.getRootId()));
                value.setName(axisHeader.getName());
                value.setDescription(axisHeader.getDescription());
                value.setCreationDate(axisHeader.getCreationDate());
                value.setCreatorId(axisHeader.getCreatorId());
                value.setPath(UNKNOWN);
                value.setOrderNumber(-1);
                value.setLevelNumber(-1);
                value.setFatherId(UNKNOWN);
                value.setLanguage(axisHeader.getLanguage());
                value.setRemoveTranslation(axisHeader.isRemoveTranslation());
                value.setTranslationId(axisHeader.getTranslationId());
                String treeId = this.treeService.createRoot(con, value);
                axisHeader.setRootId(Integer.parseInt(treeId));
                AxisHeaderPersistence ahp = new AxisHeaderPersistence(axisHeader);
                AxisPK axisPK = (AxisPK)this.dao.add(con, (SilverpeasEntityBean)ahp);
                this.pdcClassifyManager.registerAxis(con, Integer.parseInt(axisPK.getId()));
                this.commitTransaction(con);
            }
            catch (Exception exCreate) {
                this.rollbackTransaction(con);
                throw new PdcException(exCreate);
            }
            finally {
                DBUtil.close((Connection)con);
            }
        }
        return status;
    }

    @Override
    public int updateAxis(AxisHeader axisHeader) throws PdcException {
        int status = 0;
        List<AxisHeader> axis = this.getAxis();
        if (this.isAxisNameExist(axis, axisHeader)) {
            status = 2;
        } else {
            Connection con = null;
            try {
                con = this.openTransaction();
                int order = axisHeader.getAxisOrder();
                if (order != -1) {
                    order = this.processOrdering(axisHeader, order, con);
                }
                AxisHeader oldAxisHeader = this.getAxisHeader(con, axisHeader.getPK().getId());
                this.updateNameAndDescription(axisHeader, oldAxisHeader, con);
                axisHeader.setRootId(oldAxisHeader.getRootId());
                axisHeader.setCreationDate(oldAxisHeader.getCreationDate());
                axisHeader.setCreatorId(oldAxisHeader.getCreatorId());
                if (order == -1) {
                    axisHeader.setAxisOrder(oldAxisHeader.getAxisOrder());
                }
                this.manageTranslations(axisHeader, oldAxisHeader, con);
                axisHeaders.remove(axisHeader.getPK().getId());
                this.commitTransaction(con);
            }
            catch (Exception exUpdate) {
                this.rollbackTransaction(con);
                throw new PdcException(exUpdate);
            }
            finally {
                DBUtil.close((Connection)con);
            }
        }
        return status;
    }

    private void manageTranslations(AxisHeader axisHeader, AxisHeader oldAxisHeader, Connection con) throws SQLException, PersistenceException {
        if (axisHeader.isRemoveTranslation()) {
            this.deleteTranslations(axisHeader, oldAxisHeader, con);
        } else {
            this.updateTranslations(axisHeader, oldAxisHeader, con);
            AxisHeaderPersistence axisHP = new AxisHeaderPersistence(axisHeader);
            this.dao.update(con, (SilverpeasEntityBean)axisHP);
        }
    }

    private void updateTranslations(AxisHeader axisHeader, AxisHeader oldAxisHeader, Connection con) throws SQLException {
        if (axisHeader.getLanguage() != null) {
            if (oldAxisHeader.getLanguage() == null) {
                oldAxisHeader.setLanguage(I18NHelper.DEFAULT_LANGUAGE);
            }
            if (!axisHeader.getLanguage().equalsIgnoreCase(oldAxisHeader.getLanguage())) {
                AxisHeaderI18N newAxis = new AxisHeaderI18N(axisHeader.getPK().getId(), axisHeader.getLanguage(), axisHeader.getName(), axisHeader.getDescription());
                String translationId = axisHeader.getTranslationId();
                if (translationId != null && !translationId.equals("-1")) {
                    newAxis.setId(axisHeader.getTranslationId());
                    this.axisHeaderI18NDAO.updateTranslation(con, newAxis);
                } else {
                    this.axisHeaderI18NDAO.createTranslation(con, newAxis);
                }
                axisHeader.setLanguage(oldAxisHeader.getLanguage());
                axisHeader.setName(oldAxisHeader.getName());
                axisHeader.setDescription(oldAxisHeader.getDescription());
            }
        }
    }

    private void deleteTranslations(AxisHeader axisHeader, AxisHeader oldAxisHeader, Connection con) throws SQLException, PersistenceException {
        if (oldAxisHeader.getLanguage() == null) {
            oldAxisHeader.setLanguage(I18NHelper.DEFAULT_LANGUAGE);
        }
        if (oldAxisHeader.getLanguage().equalsIgnoreCase(axisHeader.getLanguage())) {
            List<AxisHeaderI18N> translations = this.axisHeaderI18NDAO.getTranslations(con, axisHeader.getPK().getId());
            if (translations != null && !translations.isEmpty()) {
                AxisHeaderI18N translation = translations.get(0);
                axisHeader.setLanguage(translation.getLanguage());
                axisHeader.setName(translation.getName());
                axisHeader.setDescription(translation.getDescription());
                AxisHeaderPersistence axisHP = new AxisHeaderPersistence(axisHeader);
                this.dao.update(con, (SilverpeasEntityBean)axisHP);
                this.axisHeaderI18NDAO.deleteTranslation(con, translation.getId());
            }
        } else {
            this.axisHeaderI18NDAO.deleteTranslation(con, axisHeader.getTranslationId());
        }
    }

    private void updateNameAndDescription(AxisHeader axisHeader, AxisHeader oldAxisHeader, Connection con) throws TreeManagerException {
        boolean axisNameHasChanged = false;
        boolean axisDescHasChanged = false;
        if (oldAxisHeader.getName() != null && !oldAxisHeader.getName().equalsIgnoreCase(axisHeader.getName())) {
            axisNameHasChanged = true;
        }
        if (oldAxisHeader.getDescription() != null && !oldAxisHeader.getDescription().equalsIgnoreCase(axisHeader.getDescription()) || oldAxisHeader.getDescription() == null && axisHeader.getDescription() != null) {
            axisDescHasChanged = true;
        }
        if (axisNameHasChanged || axisDescHasChanged) {
            String treeId = Integer.toString(oldAxisHeader.getRootId());
            TreeNode root = this.treeService.getRoot(con, treeId);
            TreeNode node = GlobalPdcManager.createTreeNode(axisHeader, root);
            this.treeService.updateRoot(con, node);
        }
    }

    private int processOrdering(AxisHeader axisHeader, int order, Connection con) throws PersistenceException {
        AxisHeaderPersistence firstAxis;
        String type = axisHeader.getAxisType();
        String axisId = axisHeader.getPK().getId();
        BeanCriteria criteria = BeanCriteria.addCriterion((String)AXIS_TYPE, (Object)type).and(AXIS_ORDER, BeanCriteria.OPERATOR.GREATER_OR_EQUAL, (Object)order);
        criteria.setAscOrderBy(new String[]{AXIS_ORDER});
        Collection axisToUpdate = this.dao.findBy(con, criteria);
        boolean axisHasMoved = true;
        Iterator it = axisToUpdate.iterator();
        if (it.hasNext() && (firstAxis = (AxisHeaderPersistence)it.next()).getPK().getId().equals(axisId)) {
            axisHasMoved = false;
        }
        if (axisHasMoved) {
            for (AxisHeaderPersistence axisToMove : axisToUpdate) {
                axisToMove.setAxisOrder(++order);
                this.dao.update(con, (SilverpeasEntityBean)axisToMove);
                axisHeaders.remove(axisHeader.getPK().getId());
            }
        }
        return order;
    }

    private static TreeNode createTreeNode(AxisHeader axisHeader, TreeNode root) {
        TreeNode node = new TreeNode(root.getPK().getId(), root.getTreeId());
        node.setName(axisHeader.getName());
        node.setDescription(axisHeader.getDescription());
        node.setCreationDate(root.getCreationDate());
        node.setCreatorId(root.getCreatorId());
        node.setPath(root.getPath());
        node.setLevelNumber(root.getLevelNumber());
        node.setOrderNumber(root.getOrderNumber());
        node.setFatherId(root.getFatherId());
        node.setLanguage(axisHeader.getLanguage());
        node.setRemoveTranslation(axisHeader.isRemoveTranslation());
        node.setTranslationId(axisHeader.getTranslationId());
        node.setTranslationsFrom(axisHeader.getTranslations());
        return node;
    }

    @Override
    public void deleteAxis(Connection con, String axisId) throws PdcException {
        try {
            AxisHeader axisHeader = this.getAxisHeader(con, axisId);
            PdcRightsDAO.deleteAxisRights(con, axisId);
            this.pdcClassificationService.axisDeleted(axisId);
            this.treeService.deleteTree(con, Integer.toString(axisHeader.getRootId()));
            this.pdcUtilizationService.deleteUsedAxisByAxisId(con, axisId);
            this.dao.remove(con, (WAPrimaryKey)new AxisPK(axisId));
            this.pdcClassifyManager.unregisterAxis(con, Integer.parseInt(axisId));
            this.pdcSubscriptionManager.checkAxisOnDelete(Integer.parseInt(axisId), axisHeader.getName());
            axisHeaders.remove(axisId);
            this.axisHeaderI18NDAO.deleteTranslations(con, axisId);
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
    }

    @Override
    public Axis getAxisDetail(String axisId) throws PdcException {
        Axis axis = null;
        AxisHeader axisHeader = this.getAxisHeader(axisId);
        if (axisHeader != null) {
            int treeId = axisHeader.getRootId();
            axis = new Axis(axisHeader, this.getAxisValues(treeId));
        }
        return axis;
    }

    @Override
    public String getTreeId(String axisId) throws PdcException {
        AxisHeaderPersistence axisHeader = this.getAxisHeaderPersistence(axisId);
        int treeId = -1;
        if (axisHeader != null) {
            treeId = axisHeader.getRootId();
        }
        return Integer.toString(treeId);
    }

    @Override
    public Value getValue(String axisId, String valueId) throws PdcException {
        Value value;
        block8: {
            Connection con = this.openConnection();
            try {
                TreeNode node = this.treeService.getNode(con, new TreeNodePK(valueId), this.getTreeId(axisId));
                value = this.createValue(node);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new PdcException(e);
                }
            }
            con.close();
        }
        return value;
    }

    @Override
    public Value getAxisValue(String valueId, String treeId) throws PdcException {
        Connection con = null;
        try {
            con = this.openConnection();
            Value value = this.createValue(this.treeService.getNode(con, new TreeNodePK(valueId), treeId));
            return value;
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public List<Value> getAxisValuesByName(String valueName) throws PdcException {
        List<Value> list;
        block8: {
            Connection con = this.openConnection();
            try {
                List<TreeNode> listTreeNodes = this.treeService.getNodesByName(con, valueName);
                list = this.createValuesList(listTreeNodes);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new PdcException(e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    public List<String> getDaughterValues(String axisId, String valueId) throws PdcException {
        ArrayList<String> listValuesString = new ArrayList<String>();
        Connection con = this.openConnection();
        try {
            List<Value> listValues = this.getDaughters(con, valueId, axisId);
            for (Value value : listValues) {
                listValuesString.add(value.getPK().getId());
            }
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
        return listValuesString;
    }

    @Override
    public Value getRoot(String axisId) throws PdcException {
        Connection con = this.openConnection();
        try {
            AxisHeader axisHeader = this.getAxisHeader(axisId, false);
            int treeId = axisHeader.getRootId();
            TreeNode treeNode = this.treeService.getRoot(con, Integer.toString(treeId));
            Value value = this.createValue(treeNode);
            return value;
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public List<Value> getAxisValues(int treeId) throws PdcException {
        Connection con = this.openConnection();
        try {
            List<Value> list = this.createValuesList(this.treeService.getTree(con, Integer.toString(treeId)));
            return list;
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public int insertMotherValue(Value valueToInsert, String refValue, String axisId) throws PdcException {
        int status;
        AxisHeader axisHeader = this.getAxisHeader(axisId, false);
        String treeId = Integer.toString(axisHeader.getRootId());
        Value refNode = this.getAxisValue(refValue, treeId);
        Connection con = null;
        try {
            con = this.openTransaction();
            ArrayList<String> oldPath = this.getPathes(con, refValue, treeId);
            if (refNode.getLevelNumber() != 0) {
                status = this.insertMotherValueToValue(con, valueToInsert, refValue, treeId);
            } else {
                this.insertMotherValueToRootValue(con, valueToInsert, refValue, treeId);
                status = 0;
            }
            if (status == 0 && !oldPath.isEmpty()) {
                ArrayList<String> newPath = this.getPathes(con, refValue, treeId);
                this.pdcClassifyManager.createValuesAndReplace(con, axisId, oldPath, newPath);
            }
            this.commitTransaction(con);
        }
        catch (Exception e) {
            this.rollbackTransaction(con);
            throw new PdcException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
        return status;
    }

    @Override
    public int moveValueToNewFatherId(Axis axis, Value valueToMove, String newFatherId, int orderNumber) throws PdcException {
        int status = 0;
        String treeId = Integer.toString(axis.getAxisHeader().getRootId());
        String valueToMoveId = valueToMove.getPK().getId();
        Connection con = null;
        try {
            con = this.openTransaction();
            ArrayList<String> oldPath = this.getPathes(con, valueToMoveId, treeId);
            List<Value> daughters = this.getDaughters(con, newFatherId, treeId);
            if (this.isValueNameExist(daughters, valueToMove)) {
                status = 1;
            } else {
                this.moveSubTree(con, treeId, valueToMoveId, newFatherId, orderNumber);
            }
            if (status == 0 && !oldPath.isEmpty()) {
                ArrayList<String> newPath = this.getPathes(con, valueToMoveId, treeId);
                this.pdcClassifyManager.createValuesAndReplace(con, Integer.toString(axis.getAxisHeader().getRootId()), oldPath, newPath);
            }
            this.commitTransaction(con);
        }
        catch (Exception e) {
            this.rollbackTransaction(con);
            throw new PdcException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
        return status;
    }

    private void moveSubTree(Connection con, String treeId, String valueToMoveId, String newFatherId, int orderNumber) throws PdcException {
        try {
            this.treeService.moveSubTreeToNewFather(con, new TreeNodePK(valueToMoveId), new TreeNodePK(newFatherId), treeId, orderNumber);
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
    }

    @Override
    public List<List<String>> getInheritedManagers(Value value) throws PdcException {
        String axisId = value.getAxisId();
        String path = value.getPath();
        String[] splitPath = path.split("/");
        ArrayList<List<String>> usersAndGroups = new ArrayList<List<String>>();
        HashSet<String> usersInherited = new HashSet<String>();
        HashSet<String> groupsInherited = new HashSet<String>();
        for (int i = 1; i < splitPath.length; ++i) {
            List<List<String>> managers = this.getManagers(axisId, splitPath[i]);
            List<String> usersId = managers.get(0);
            List<String> groupsId = managers.get(1);
            usersInherited.addAll(usersId);
            groupsInherited.addAll(groupsId);
        }
        usersAndGroups.add(new ArrayList(usersInherited));
        usersAndGroups.add(new ArrayList(groupsInherited));
        return usersAndGroups;
    }

    @Override
    public List<List<String>> getManagers(String axisId, String valueId) throws PdcException {
        List<String> groupsId;
        List<String> usersId;
        Connection con = this.openConnection();
        try {
            usersId = PdcRightsDAO.getUserIds(con, axisId, valueId);
            groupsId = PdcRightsDAO.getGroupIds(con, axisId, valueId);
        }
        catch (SQLException e) {
            throw new PdcException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
        ArrayList<List<String>> usersAndGroups = new ArrayList<List<String>>();
        usersAndGroups.add(usersId);
        usersAndGroups.add(groupsId);
        return usersAndGroups;
    }

    @Override
    public boolean isUserManager(String userId) throws PdcException {
        if (PdcSettings.isDelegationNotEnabled()) {
            return false;
        }
        Connection con = this.openConnection();
        try {
            boolean isManager = PdcRightsDAO.isUserManager(con, userId);
            if (!isManager) {
                String[] groupIds = OrganizationControllerProvider.getOrganisationController().getAllGroupIdsOfUser(userId);
                isManager = this.isGroupManager(groupIds);
            }
            boolean bl = isManager;
            return bl;
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    private boolean isGroupManager(String[] groupIds) throws PdcException {
        Connection con = this.openConnection();
        try {
            boolean bl = PdcRightsDAO.isGroupManager(con, groupIds);
            return bl;
        }
        catch (SQLException e) {
            throw new PdcException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public void setManagers(List<String> userIds, List<String> groupIds, String axisId, String valueId) throws PdcException {
        Connection con = null;
        try {
            con = this.openTransaction();
            PdcRightsDAO.deleteRights(con, axisId, valueId);
            for (String userId : userIds) {
                PdcRightsDAO.insertUserId(con, axisId, valueId, userId);
            }
            for (String groupId : groupIds) {
                PdcRightsDAO.insertGroupId(con, axisId, valueId, groupId);
            }
            this.commitTransaction(con);
        }
        catch (SQLException e) {
            this.rollbackTransaction(con);
            throw new PdcException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public void razManagers(String axisId, String valueId) throws PdcException {
        Connection con = this.openConnection();
        try {
            PdcRightsDAO.deleteRights(con, axisId, valueId);
        }
        catch (SQLException e) {
            throw new PdcException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public void deleteManager(String userId) throws PdcException {
        Connection con = this.openConnection();
        try {
            PdcRightsDAO.deleteManager(con, userId);
        }
        catch (SQLException e) {
            throw new PdcException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public void deleteGroupManager(String groupId) throws PdcException {
        Connection con = this.openConnection();
        try {
            PdcRightsDAO.deleteGroupManager(con, groupId);
        }
        catch (SQLException e) {
            throw new PdcException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    private ArrayList<String> getPathes(Connection con, String refValue, String treeId) {
        ArrayList<String> pathList = new ArrayList<String>();
        TreeNodePK refNodePK = new TreeNodePK(refValue);
        try {
            List<TreeNode> treeList = this.treeService.getSubTree(con, refNodePK, treeId);
            for (TreeNode nodeTree : treeList) {
                pathList.add(nodeTree.getPath() + nodeTree.getPK().getId() + "/");
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).warn((Throwable)e);
        }
        return pathList;
    }

    private void insertMotherValueToRootValue(Connection con, Value valueToInsert, String refValue, String treeId) throws PdcException {
        try {
            this.treeService.insertFatherToNode(con, valueToInsert, new TreeNodePK(refValue), treeId);
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
    }

    private int insertMotherValueToValue(Connection con, Value valueToInsert, String refValue, String treeId) throws PdcException {
        int status = 0;
        Value refNode = this.getAxisValue(refValue, treeId);
        List<Value> daughters = this.getDaughters(con, refNode.getFatherId(), treeId);
        if (this.isValueNameExist(daughters, valueToInsert)) {
            status = 1;
        } else {
            try {
                this.treeService.insertFatherToNode(con, valueToInsert, new TreeNodePK(refValue), treeId);
            }
            catch (Exception e) {
                throw new PdcException(e);
            }
        }
        return status;
    }

    @Override
    public int createDaughterValue(Value valueToInsert, String refValue, String treeId) throws PdcException {
        Connection con = this.openConnection();
        int status = 0;
        List<Value> daughters = this.getDaughters(con, refValue, treeId);
        if (this.isValueNameExist(daughters, valueToInsert)) {
            status = 1;
            DBUtil.close((Connection)con);
        } else {
            try {
                this.treeService.createSonToNode(con, valueToInsert, new TreeNodePK(refValue), treeId);
            }
            catch (Exception e) {
                throw new PdcException(e);
            }
            finally {
                DBUtil.close((Connection)con);
            }
        }
        return status;
    }

    @Override
    public String createDaughterValueWithId(Value valueToInsert, String refValue, String treeId) throws PdcException {
        String daughterId;
        Connection con = this.openConnection();
        List<Value> daughters = this.getDaughters(con, refValue, treeId);
        if (this.isValueNameExist(daughters, valueToInsert)) {
            daughterId = "-1";
            DBUtil.close((Connection)con);
        } else {
            try {
                daughterId = this.treeService.createSonToNode(con, valueToInsert, new TreeNodePK(refValue), treeId);
            }
            catch (Exception e) {
                throw new PdcException(e);
            }
            finally {
                DBUtil.close((Connection)con);
            }
        }
        return daughterId;
    }

    @Override
    public int updateValue(Value value, String treeId) throws PdcException {
        Connection con = this.openConnection();
        int status = 0;
        try {
            Value oldValue = this.getAxisValue(value.getPK().getId(), treeId);
            List<Value> daughters = this.getDaughters(con, oldValue.getMotherId(), treeId);
            if (this.isValueNameExist(daughters, value)) {
                status = 1;
            } else {
                TreeNode node = GlobalPdcManager.buildTreeNode(treeId, value, oldValue);
                this.treeService.updateNode(con, node);
            }
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
        return status;
    }

    private static TreeNode buildTreeNode(String treeId, Value value, Value oldValue) {
        TreeNode node = new TreeNode(value.getPK().getId(), treeId);
        node.setName(value.getName());
        node.setDescription(value.getDescription());
        node.setCreationDate(oldValue.getCreationDate());
        node.setCreatorId(oldValue.getCreatorId());
        node.setPath(oldValue.getPath());
        node.setLevelNumber(oldValue.getLevelNumber());
        node.setOrderNumber(value.getOrderNumber());
        node.setFatherId(oldValue.getFatherId());
        node.setLanguage(value.getLanguage());
        node.setRemoveTranslation(value.isRemoveTranslation());
        node.setTranslationId(value.getTranslationId());
        return node;
    }

    @Override
    public void deleteValueAndSubtree(Connection con, String valueId, String axisId, String treeId) throws PdcException {
        try {
            ArrayList<PdcAxisValue> valuesToDelete = new ArrayList<PdcAxisValue>();
            PdcAxisValue aValueToDelete = PdcAxisValue.aPdcAxisValue(valueId, axisId);
            valuesToDelete.add(aValueToDelete);
            valuesToDelete.addAll(this.findRecursivelyAllChildrenOf(aValueToDelete));
            this.pdcClassificationService.axisValuesDeleted(valuesToDelete);
            List<Value> pathInfo = this.getFullPath(valueId, treeId);
            this.updateBaseValuesInInstances(con, valueId, axisId, treeId);
            ArrayList<String> oldPath = this.getPathes(con, valueId, treeId);
            TreeNodePK treeNodePK = new TreeNodePK(valueId);
            String motherId = this.treeService.getNode(con, treeNodePK, treeId).getFatherId();
            TreeNodePK motherPK = new TreeNodePK(motherId);
            TreeNode mother = this.treeService.getNode(con, motherPK, treeId);
            String motherPath = mother.getPath() + motherId + "/";
            AxisHeader axisHeader = this.getAxisHeader(con, axisId);
            String axisName = axisHeader.getName();
            List<TreeNode> subtree = this.treeService.getSubTree(con, treeNodePK, treeId);
            this.treeService.deleteSubTree(con, treeNodePK, treeId);
            for (TreeNode node : subtree) {
                Value value = this.createValue(node);
                if (value == null) continue;
                PdcRightsDAO.deleteRights(con, axisId, value.getPK().getId());
            }
            if (!oldPath.isEmpty()) {
                ArrayList<String> newPath = new ArrayList<String>();
                for (int i = 0; i < oldPath.size(); ++i) {
                    newPath.add(motherPath);
                }
                this.pdcSubscriptionManager.checkValueOnDelete(Integer.parseInt(axisId), axisName, oldPath, newPath, pathInfo);
                this.pdcClassifyManager.createValuesAndReplace(con, axisId, oldPath, newPath);
            }
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String deleteValue(Connection con, String valueId, String axisId, String treeId) throws PdcException {
        String possibleDaughterName;
        try {
            ArrayList<PdcAxisValue> valuesToDelete = new ArrayList<PdcAxisValue>();
            valuesToDelete.add(PdcAxisValue.aPdcAxisValue(valueId, axisId));
            this.pdcClassificationService.axisValuesDeleted(valuesToDelete);
            Value valueToDelete = this.getAxisValue(valueId, treeId);
            List<Value> daughtersOfMother = this.getDaughters(con, valueToDelete.getMotherId(), treeId);
            List<Value> daughtersOfValueToDelete = this.getDaughters(con, valueId, treeId);
            possibleDaughterName = this.isValueNameExist(daughtersOfMother, daughtersOfValueToDelete);
            if (possibleDaughterName == null) {
                this.updateBaseValueInInstances(con, valueId, axisId, treeId);
                ArrayList<String> oldPath = this.getPathes(con, valueId, treeId);
                AxisHeader axisHeader = this.getAxisHeader(con, axisId);
                String axisName = axisHeader.getName();
                List<Value> pathInfo = this.getFullPath(valueId, treeId);
                this.treeService.deleteNode(con, new TreeNodePK(valueId), treeId);
                PdcRightsDAO.deleteRights(con, axisId, valueId);
                if (!oldPath.isEmpty()) {
                    ArrayList<String> newPath = this.getPathes(con, valueId, treeId);
                    String pattern = "/" + valueId;
                    int lenOfPattern = pattern.length();
                    for (String string : oldPath) {
                        void var19_20;
                        int patternIdx;
                        String string2 = string.substring(0, patternIdx = string.indexOf(pattern)) + string.substring(patternIdx + lenOfPattern);
                        if (string2.split("/").length <= 2) {
                            Object var19_23 = null;
                        }
                        newPath.add((String)var19_20);
                    }
                    this.pdcSubscriptionManager.checkValueOnDelete(Integer.parseInt(axisId), axisName, oldPath, newPath, pathInfo);
                    this.pdcClassifyManager.createValuesAndReplace(con, axisId, oldPath, newPath);
                }
            }
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
        return possibleDaughterName;
    }

    @Override
    public List<Value> getFullPath(String valueId, String treeId) throws PdcException {
        Connection con = this.openConnection();
        try {
            List<TreeNode> listTreeNode = this.treeService.getFullPath(con, new TreeNodePK(valueId), treeId);
            List<Value> list = this.createValuesList(listTreeNode);
            return list;
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    private boolean isAxisNameExist(List<AxisHeader> axis, AxisHeader axisToCheck) {
        String axisIdToCheck = axisToCheck.getPK().getId();
        String axisNameToCheck = axisToCheck.getName();
        boolean isExist = false;
        for (AxisHeader axisHeader : axis) {
            if (!axisHeader.getName().equalsIgnoreCase(axisNameToCheck) || axisHeader.getPK().getId().equals(axisIdToCheck)) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    private boolean isValueNameExist(List<Value> values, Value valueToCheck) {
        String valueIdToCheck = valueToCheck.getPK().getId();
        String valueNameToCheck = valueToCheck.getName();
        boolean isExist = false;
        for (Value value : values) {
            if (!value.getName().equalsIgnoreCase(valueNameToCheck) || value.getPK().getId().equals(valueIdToCheck)) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    private String isValueNameExist(List<Value> values, List<Value> valuesToCheck) {
        Iterator<Value> it = valuesToCheck.iterator();
        String valueName = null;
        while (it.hasNext()) {
            Value valueToCheck = it.next();
            if (!this.isValueNameExist(values, valueToCheck)) continue;
            valueName = valueToCheck.getName();
            break;
        }
        return valueName;
    }

    @Override
    public AxisHeader getAxisHeader(String axisId) {
        return this.getAxisHeader(axisId, true);
    }

    public AxisHeader getAxisHeader(String axisId, boolean setTranslations) {
        AxisHeader axisHeader = axisHeaders.get(axisId);
        if (axisHeader == null) {
            try {
                AxisHeaderPersistence axisHeaderPersistence = (AxisHeaderPersistence)this.dao.findByPrimaryKey((WAPrimaryKey)new AxisPK(axisId));
                axisHeader = new AxisHeader(axisHeaderPersistence);
                axisHeaders.put(axisHeader.getPK().getId(), axisHeader);
            }
            catch (PersistenceException e) {
                SilverLogger.getLogger((Object)this).silent((Throwable)e);
            }
        }
        if (setTranslations && axisHeader != null) {
            this.setTranslations(axisHeader);
        }
        return axisHeader;
    }

    private AxisHeaderPersistence getAxisHeaderPersistence(String axisId) {
        try {
            return (AxisHeaderPersistence)this.dao.findByPrimaryKey((WAPrimaryKey)new AxisPK(axisId));
        }
        catch (PersistenceException exSelect) {
            SilverLogger.getLogger((Object)this).error("Failed to get headers for axis {0}", (Object[])new String[]{axisId}, (Throwable)exSelect);
            return null;
        }
    }

    private AxisHeader getAxisHeader(Connection connection, String axisId) {
        try {
            AxisHeaderPersistence axisHeaderPersistence = (AxisHeaderPersistence)this.dao.findByPrimaryKey(connection, (WAPrimaryKey)new AxisPK(axisId));
            return new AxisHeader(axisHeaderPersistence);
        }
        catch (PersistenceException exSelect) {
            throw new PdcRuntimeException(exSelect);
        }
    }

    private List<Value> getDaughters(Connection con, String refValue, String treeId) {
        List<Value> daughters = new ArrayList<Value>();
        try {
            daughters = this.createValuesList(this.treeService.getSonsToNode(con, new TreeNodePK(refValue), treeId));
        }
        catch (Exception exList) {
            SilverLogger.getLogger((Object)this).warn(exList.getMessage(), new Object[0]);
        }
        return daughters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Value> getDaughters(String axisId, String valueId) {
        ArrayList<Value> daughters = new ArrayList<Value>();
        Connection con = null;
        try {
            con = this.openConnection();
            AxisHeader axisHeader = this.getAxisHeader(axisId, false);
            int tId = axisHeader.getRootId();
            List<Value> list = this.getAxisValues(tId);
            return list;
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).warn(e.getMessage(), new Object[0]);
        }
        finally {
            DBUtil.close((Connection)con);
        }
        return daughters;
    }

    private List<Value> createValuesList(List<TreeNode> treeNodes) {
        ArrayList<Value> values = new ArrayList<Value>();
        for (TreeNode node : treeNodes) {
            values.add(this.createValue(node));
        }
        return values;
    }

    private Value createValue(TreeNode treeNode) {
        if (treeNode != null) {
            Value value = new Value(treeNode);
            value.setTranslations(treeNode.getTranslations());
            return value;
        }
        return null;
    }

    @Override
    public UsedAxis getUsedAxis(String usedAxisId) throws PdcException {
        return this.pdcUtilizationService.getUsedAxis(usedAxisId);
    }

    @Override
    public List<UsedAxis> getUsedAxisByInstanceId(String instanceId) throws PdcException {
        return this.pdcUtilizationService.getUsedAxisByInstanceId(instanceId);
    }

    @Override
    public int addUsedAxis(UsedAxis usedAxis) throws PdcException {
        AxisHeader axisHeader = this.getAxisHeader(Integer.toString(usedAxis.getAxisId()), false);
        String treeId = Integer.toString(axisHeader.getRootId());
        return this.pdcUtilizationService.addUsedAxis(usedAxis, treeId);
    }

    @Override
    public int updateUsedAxis(UsedAxis usedAxis) throws PdcException {
        AxisHeader axisHeader = this.getAxisHeader(Integer.toString(usedAxis.getAxisId()), false);
        String treeId = Integer.toString(axisHeader.getRootId());
        String id = usedAxis.getPK().getId();
        UsedAxis currentUsedAxis = this.pdcUtilizationService.getUsedAxis(id);
        List<Integer> objectIdList = this.pdcClassifyManager.getObjectsByInstance(usedAxis.getInstanceId());
        if (!objectIdList.isEmpty() && !this.isAscendanteBaseValue(objectIdList, usedAxis)) {
            if (this.pdcClassifyManager.hasAlreadyPositions(objectIdList, currentUsedAxis)) {
                return 2;
            }
            return this.pdcUtilizationService.updateUsedAxis(usedAxis, treeId);
        }
        return this.pdcUtilizationService.updateUsedAxis(usedAxis, treeId);
    }

    private boolean isAscendanteBaseValue(List<Integer> objectIdList, UsedAxis usedAxis) throws PdcException {
        return this.pdcClassifyManager.hasAlreadyPositions(objectIdList, usedAxis);
    }

    private void updateBaseValueInInstances(Connection con, String baseValueToUpdate, String axisId, String treeId) throws PdcException {
        Value value = this.getAxisValue(baseValueToUpdate, treeId);
        int newBaseValue = Integer.parseInt(value.getMotherId());
        this.pdcUtilizationService.updateOrDeleteBaseValue(con, Integer.parseInt(baseValueToUpdate), newBaseValue, Integer.parseInt(axisId), treeId);
    }

    private void updateBaseValuesInInstances(Connection con, String baseValueToUpdate, String axisId, String treeId) throws PdcException {
        List<TreeNode> descendants;
        try {
            descendants = this.treeService.getSubTree(con, new TreeNodePK(baseValueToUpdate), treeId);
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
        Value value = this.getAxisValue(baseValueToUpdate, treeId);
        int newBaseValue = Integer.parseInt(value.getMotherId());
        for (TreeNode descendant : descendants) {
            String descendantId = descendant.getPK().getId();
            this.pdcUtilizationService.updateOrDeleteBaseValue(con, Integer.parseInt(descendantId), newBaseValue, Integer.parseInt(axisId), treeId);
        }
    }

    @Override
    public void deleteUsedAxis(String usedAxisId) throws PdcException {
        this.pdcUtilizationService.deleteUsedAxis(usedAxisId);
    }

    @Override
    public List<UsedAxis> getUsedAxisToClassify(String instanceId, int silverObjectId) throws PdcException {
        List<UsedAxis> usedAxis = this.getUsedAxisByInstanceId(instanceId);
        if (usedAxis.isEmpty()) {
            this.fillUsedAxis(instanceId, usedAxis);
        } else {
            this.initUsedAxis(instanceId, silverObjectId, usedAxis);
        }
        return usedAxis;
    }

    private void initUsedAxis(String instanceId, int silverObjectId, List<UsedAxis> usedAxis) throws PdcException {
        for (UsedAxis axis : usedAxis) {
            List<ClassifyPosition> positions;
            if (I18NHelper.isI18nContentActivated) {
                AxisHeader header = this.getAxisHeader(Integer.toString(axis.getAxisId()));
                axis._setAxisHeader(header);
            }
            int axisRootId = axis._getAxisRootId();
            axis._setAxisValues(this.getAxisValues(axisRootId));
            if (axis.getVariant() != 0 || silverObjectId < 0 || (positions = this.getPositions(silverObjectId, instanceId)).isEmpty()) continue;
            for (ClassifyPosition position : positions) {
                String invariantValue = position.getValueOnAxis(axis.getAxisId());
                axis._setInvariantValue(invariantValue);
            }
        }
    }

    private void fillUsedAxis(String instanceId, List<UsedAxis> usedAxis) throws PdcException {
        List<AxisHeader> headers = this.getAxis();
        for (AxisHeader axisHeader : headers) {
            UsedAxis axis = new UsedAxis(axisHeader.getPK().getId(), instanceId, axisHeader.getRootId(), 0, 0, 1);
            axis._setAxisHeader(axisHeader);
            axis._setAxisName(axisHeader.getName());
            axis._setAxisType(axisHeader.getAxisType());
            axis._setBaseValueName(axisHeader.getName());
            axis._setAxisRootId(axisHeader.getRootId());
            axis._setAxisValues(this.getAxisValues(axisHeader.getRootId()));
            usedAxis.add(axis);
        }
    }

    @Override
    public void addPositions(List<ClassifyPosition> positions, int objectId, String instanceId) throws PdcException {
        List<UsedAxis> usedAxis = this.getUsedAxisByInstanceId(instanceId);
        for (ClassifyPosition position : positions) {
            ClassifyPosition newPosition = this.checkClassifyPosition(position, usedAxis);
            if (newPosition == null) continue;
            this.addPosition(objectId, newPosition, instanceId);
        }
    }

    @Override
    public void copyPositions(int fromObjectId, String fromInstanceId, int toObjectId, String toInstanceId) throws PdcException {
        List<ClassifyPosition> positions = this.getPositions(fromObjectId, fromInstanceId);
        List<ClassifyPosition> existingPositions = this.getPositions(toObjectId, toInstanceId);
        List<UsedAxis> usedAxis = this.getUsedAxisByInstanceId(toInstanceId);
        for (ClassifyPosition position : positions) {
            ClassifyPosition newPosition;
            if (this.isYetSet(existingPositions, position) || (newPosition = this.checkClassifyPosition(position, usedAxis)) == null) continue;
            this.addPosition(toObjectId, newPosition, toInstanceId);
        }
    }

    private boolean isYetSet(List<ClassifyPosition> positions, ClassifyPosition position) {
        return positions.stream().anyMatch(p -> p.equals(position));
    }

    private ClassifyPosition checkClassifyPosition(ClassifyPosition position, List<UsedAxis> usedAxis) {
        ClassifyPosition newPosition = new ClassifyPosition();
        List<ClassifyValue> values = position.getListClassifyValue();
        for (ClassifyValue value : values) {
            if ((value = this.checkClassifyValue(value, usedAxis)) == null) continue;
            newPosition.addValue(value);
        }
        if (newPosition.getValues() == null) {
            return null;
        }
        return newPosition;
    }

    private ClassifyValue checkClassifyValue(ClassifyValue value, List<UsedAxis> usedAxis) {
        UsedAxis uAxis = this.getUsedAxis(usedAxis, value.getAxisId());
        if (uAxis == null) {
            return null;
        }
        String baseValuePath = uAxis._getBaseValuePath();
        if (!("/" + value.getValue() + "/").contains(baseValuePath)) {
            return null;
        }
        return value;
    }

    private UsedAxis getUsedAxis(List<UsedAxis> usedAxis, int axisId) {
        for (UsedAxis uAxis : usedAxis) {
            if (uAxis.getAxisId() != axisId) continue;
            return uAxis;
        }
        return null;
    }

    @Override
    public int addPosition(int silverObjectId, ClassifyPosition position, String sComponentId) throws PdcException {
        return this.addPosition(silverObjectId, position, sComponentId, true);
    }

    @Override
    public int addPosition(int silverObjectId, ClassifyPosition position, String sComponentId, boolean alertSubscribers) throws PdcException {
        int positionId = this.pdcClassifyManager.isPositionAlreadyExists(silverObjectId, position);
        if (positionId == -1) {
            positionId = this.pdcClassifyManager.addPosition(silverObjectId, position, sComponentId);
            if (alertSubscribers) {
                this.pdcSubscriptionManager.checkSubscriptions(position.getValues(), sComponentId, silverObjectId);
            }
        }
        return positionId;
    }

    @Override
    public int updatePosition(ClassifyPosition position, String instanceId, int silverObjectId) throws PdcException {
        return this.updatePosition(position, instanceId, silverObjectId, true);
    }

    @Override
    public int updatePosition(ClassifyPosition position, String instanceId, int silverObjectId, boolean alertSubscribers) throws PdcException {
        List<UsedAxis> usedAxisList = this.getUsedAxisToClassify(instanceId, silverObjectId);
        HashSet<Integer> invariantUsedAxis = new HashSet<Integer>(usedAxisList.size());
        for (UsedAxis ua : usedAxisList) {
            if (ua.getVariant() != 0) continue;
            invariantUsedAxis.add(ua.getAxisId());
        }
        List classifyValueList = position.getValues();
        ArrayList<org.silverpeas.core.pdc.classification.Value> classifyValues = new ArrayList<org.silverpeas.core.pdc.classification.Value>();
        for (ClassifyValue cv : classifyValueList) {
            if (!invariantUsedAxis.contains(cv.getAxisId())) continue;
            classifyValues.add(cv);
        }
        this.pdcClassifyManager.updatePosition(position);
        if (!classifyValues.isEmpty()) {
            this.pdcClassifyManager.updatePositions(classifyValues, silverObjectId);
        }
        if (alertSubscribers) {
            this.pdcSubscriptionManager.checkSubscriptions(position.getValues(), instanceId, silverObjectId);
        }
        return 0;
    }

    @Override
    public void deletePosition(int positionId, String sComponentId) throws PdcException {
        this.pdcClassifyManager.deletePosition(positionId, sComponentId);
    }

    @Override
    public List<ClassifyPosition> getPositions(int silverObjectId, String sComponentId) throws PdcException {
        List<Position<org.silverpeas.core.pdc.classification.Value>> positions = this.pdcClassifyManager.getPositions(silverObjectId, sComponentId);
        ArrayList<ClassifyPosition> classifyPositions = new ArrayList<ClassifyPosition>();
        for (Position<org.silverpeas.core.pdc.classification.Value> position : positions) {
            List<org.silverpeas.core.pdc.classification.Value> values = position.getValues();
            ArrayList<ClassifyValue> classifyValues = new ArrayList<ClassifyValue>();
            for (org.silverpeas.core.pdc.classification.Value value : values) {
                ClassifyValue classifyValue = new ClassifyValue(value.getAxisId(), value.getValue());
                if (value.getAxisId() == -1) continue;
                int treeId = Integer.parseInt(this.getTreeId(Integer.toString(value.getAxisId())));
                String valuePath = value.getValue();
                if (valuePath == null) continue;
                valuePath = valuePath.substring(0, valuePath.length() - 1);
                String valueId = valuePath.substring(valuePath.lastIndexOf(47) + 1);
                classifyValue.setFullPath(this.getFullPath(valueId, String.valueOf(treeId)));
                classifyValues.add(classifyValue);
            }
            ClassifyPosition classifyPosition = new ClassifyPosition((List<ClassifyValue>)classifyValues);
            classifyPosition.setPositionId(position.getPositionId());
            classifyPositions.add(classifyPosition);
        }
        return classifyPositions;
    }

    @Override
    public List<SearchAxis> getPertinentAxisByInstanceId(SearchContext searchContext, String axisType, String instanceId) throws PdcException {
        ArrayList<String> instanceIds = new ArrayList<String>();
        instanceIds.add(instanceId);
        return this.getPertinentAxisByInstanceIds(searchContext, axisType, instanceIds);
    }

    @Override
    public List<SearchAxis> getPertinentAxisByInstanceIds(SearchContext searchContext, String axisType, List<String> instanceIds) throws PdcException {
        List<AxisHeader> axis = this.pdcUtilizationService.getAxisHeaderUsedByInstanceIds(instanceIds);
        ArrayList<Integer> axisIds = new ArrayList<Integer>();
        for (AxisHeader axisHeader : axis) {
            if (!axisHeader.getAxisType().equals(axisType)) continue;
            String axisId = axisHeader.getPK().getId();
            axisIds.add(Integer.parseInt(axisId));
        }
        List<PertinentAxis> pertinentAxis = this.pdcClassifyManager.getPertinentAxis(searchContext, axisIds, instanceIds);
        return this.transformPertinentAxisIntoSearchAxis(pertinentAxis, axis);
    }

    private List<SearchAxis> transformPertinentAxisIntoSearchAxis(List<PertinentAxis> pertinentAxisList, List<AxisHeader> axis) throws PdcException {
        ArrayList<SearchAxis> searchAxisList = new ArrayList<SearchAxis>();
        for (PertinentAxis pertinentAxis : pertinentAxisList) {
            String axisId = Integer.toString(pertinentAxis.getAxisId());
            SearchAxis searchAxis = new SearchAxis(pertinentAxis.getAxisId(), pertinentAxis.getNbObjects());
            for (AxisHeader axisHeader : axis) {
                if (!axisHeader.getPK().getId().equals(axisId)) continue;
                this.setTranslations(axisHeader);
                searchAxis.setAxis(axisHeader);
                searchAxis.setAxisRootId(Integer.parseInt(this.getRootId(axisHeader.getPK().getId())));
                searchAxisList.add(searchAxis);
            }
        }
        return searchAxisList;
    }

    @Override
    public List<Value> getPertinentDaughterValuesByInstanceId(SearchContext searchContext, String axisId, String valueId, String instanceId) throws PdcException {
        ArrayList<String> instanceIds = new ArrayList<String>();
        instanceIds.add(instanceId);
        return this.getPertinentDaughterValuesByInstanceIds(searchContext, axisId, valueId, instanceIds);
    }

    @Override
    public List<Value> getPertinentDaughterValuesByInstanceIds(SearchContext searchContext, String axisId, String valueId, List<String> instanceIds) throws PdcException {
        return this.filterValues(searchContext, axisId, instanceIds);
    }

    @Override
    public List<Value> getFirstLevelAxisValuesByInstanceId(SearchContext searchContext, String axisId, String instanceId) throws PdcException {
        ArrayList<String> instanceIds = new ArrayList<String>();
        instanceIds.add(instanceId);
        return this.getFirstLevelAxisValuesByInstanceIds(searchContext, axisId, instanceIds);
    }

    @Override
    public List<Value> getFirstLevelAxisValuesByInstanceIds(SearchContext searchContext, String axisId, List<String> instanceIds) throws PdcException {
        this.getRootId(axisId);
        return this.filterValues(searchContext, axisId, instanceIds);
    }

    private String getRootId(String axisId) throws PdcException {
        String rootId;
        try (Connection con = this.openConnection();){
            AxisHeader axisHeader = this.getAxisHeader(axisId, false);
            int treeId = axisHeader.getRootId();
            TreeNode root = this.treeService.getRoot(con, Integer.toString(treeId));
            rootId = root.getPK().getId();
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
        return rootId;
    }

    private List<Value> filterValues(SearchContext searchContext, String axisId, List<String> instanceIds) throws PdcException {
        ArrayList<String> emptyValues = new ArrayList<String>();
        AxisHeader axisHeader = this.getAxisHeader(axisId, false);
        int treeId = axisHeader.getRootId();
        List<ObjectValuePair> allObjectValuePairs = this.pdcClassifyManager.getObjectValuePairs(searchContext, Integer.parseInt(axisId), instanceIds);
        List<ObjectValuePair> objectValuePairs = this.filterAvailableContents(allObjectValuePairs, searchContext.getUserId());
        List<Value> descendants = this.getAxisValues(treeId);
        int nI = -1;
        while (++nI < descendants.size()) {
            Value descendant = descendants.get(nI);
            String descendantPath = descendant.getFullPath();
            if (GlobalPdcManager.isLeaf(nI, descendants, descendant)) {
                int nbContents = this.getNumberOfContents(objectValuePairs, descendantPath, false);
                if (nbContents > 0) {
                    descendant.setNbObjects(nbContents);
                    continue;
                }
                emptyValues.add(descendantPath);
                descendants.remove(nI--);
                continue;
            }
            nI = this.processEmptyValues(emptyValues, descendantPath, descendants, nI, objectValuePairs, descendant);
        }
        return descendants;
    }

    private int processEmptyValues(ArrayList<String> emptyValues, String descendantPath, List<Value> descendants, int nI, List<ObjectValuePair> objectValuePairs, Value descendant) {
        boolean isEmpty = false;
        for (int nJ = 0; nJ < emptyValues.size() && !isEmpty; ++nJ) {
            String emptyPath = emptyValues.get(nJ);
            if (!descendantPath.startsWith(emptyPath)) continue;
            isEmpty = true;
        }
        if (isEmpty) {
            descendants.remove(nI--);
        } else {
            int nbObjects = this.getNumberOfContents(objectValuePairs, descendantPath, true);
            if (nbObjects > 0) {
                descendant.setNbObjects(nbObjects);
            } else {
                emptyValues.add(descendantPath);
                descendants.remove(nI--);
            }
        }
        return nI;
    }

    private static boolean isLeaf(int nI, List<Value> descendants, Value descendant) {
        Value nextDescendant;
        boolean isLeaf = nI + 1 < descendants.size() ? ((nextDescendant = descendants.get(nI + 1)) != null ? nextDescendant.getLevelNumber() <= descendant.getLevelNumber() : false) : true;
        return isLeaf;
    }

    private List<ObjectValuePair> filterAvailableContents(List<ObjectValuePair> ovps, String userId) {
        List pks = ovps.stream().filter(o -> o.getInstanceId().startsWith(KMELIA_COMPONENT_NAME)).map(o -> new PublicationPK(o.getObjectId(), o.getInstanceId())).collect(Collectors.toList());
        AccessControlContext context = AccessControlContext.init().onOperationsOf(new AccessControlOperation[]{AccessControlOperation.SEARCH});
        Set accessiblePks = PublicationAccessControl.get().filterAuthorizedByUser(pks, userId, context).map(p -> p.getInstanceId() + "@" + p.getId()).collect(Collectors.toSet());
        return ovps.stream().filter(o -> !o.getInstanceId().startsWith(KMELIA_COMPONENT_NAME) || accessiblePks.contains(o.getInstanceId() + "@" + o.getObjectId())).collect(Collectors.toList());
    }

    private int getNumberOfContents(List<ObjectValuePair> ovps, String valuePath, boolean deeply) {
        int nb = 0;
        HashSet<CallSite> countedObjects = new HashSet<CallSite>(ovps.size());
        for (ObjectValuePair ovp : ovps) {
            String key = ovp.getInstanceId() + "-" + ovp.getObjectId();
            if (!(deeply ? ovp.getValuePath().startsWith(valuePath) : ovp.getValuePath().equals(valuePath)) || countedObjects.contains(key)) continue;
            ++nb;
            countedObjects.add((CallSite)((Object)key));
        }
        return nb;
    }

    @Override
    public boolean isClassifyingMandatory(String componentId) throws PdcException {
        List<UsedAxis> axisUsed = this.getUsedAxisByInstanceId(componentId);
        if (axisUsed != null) {
            for (UsedAxis axis : axisUsed) {
                if (axis.getMandatory() != 1) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void indexAllAxis() throws PdcException {
        IndexEngineProxy.removeScopedIndexEntries((String)"pdc");
        Connection con = this.openConnection();
        try {
            for (AxisHeader a : this.getAxis()) {
                this.treeService.indexTree(con, a.getRootId());
            }
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    private Connection openConnection() throws PdcException {
        Connection con;
        try {
            con = DBUtil.openConnection();
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
        return con;
    }

    private Connection openTransaction() throws PdcException {
        Connection con = null;
        try {
            con = DBUtil.openConnection();
            con.setAutoCommit(false);
        }
        catch (Exception e) {
            DBUtil.close((Connection)con);
            throw new PdcException(e);
        }
        return con;
    }

    private void rollbackTransaction(Connection con) {
        if (con != null) {
            try {
                con.rollback();
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void commitTransaction(Connection con) {
        if (con != null) {
            try {
                con.commit();
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public SearchContext getSilverContentIdSearchContext(int nSilverContentId, String sComponentId) throws PdcException {
        try {
            List<Position<org.silverpeas.core.pdc.classification.Value>> alPositions = this.pdcClassifyManager.getPositions(nSilverContentId, sComponentId);
            SearchContext searchContext = new SearchContext(null);
            if (alPositions != null && !alPositions.isEmpty()) {
                Position<org.silverpeas.core.pdc.classification.Value> pos = alPositions.get(0);
                List<org.silverpeas.core.pdc.classification.Value> alValues = pos.getValues();
                for (int nI = 0; alValues != null && nI < alValues.size(); ++nI) {
                    org.silverpeas.core.pdc.classification.Value value = alValues.get(nI);
                    if (value.getAxisId() == -1 || value.getValue() == null) continue;
                    searchContext.addCriteria(new SearchCriteria(value.getAxisId(), value.getValue()));
                }
            }
            return searchContext;
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
    }

    @Override
    public List<Integer> findSilverContentIdByPosition(SearchContext containerPosition, List<String> alComponentId, String authorId, LocalDate afterDate, LocalDate beforeDate) throws PdcException {
        return this.findSilverContentIdByPosition(containerPosition, alComponentId, authorId, afterDate, beforeDate, true, true);
    }

    private List<Integer> findSilverContentIdByPosition(SearchContext containerPosition, List<String> alComponentId, String authorId, LocalDate afterDate, LocalDate beforeDate, boolean recursiveSearch, boolean visibilitySensitive) throws PdcException {
        try {
            return this.pdcClassifyManager.findSilverContentIdByPosition(containerPosition, alComponentId, authorId, DateUtil.formatDate((LocalDate)afterDate), DateUtil.formatDate((LocalDate)beforeDate), recursiveSearch, visibilitySensitive);
        }
        catch (Exception e) {
            throw new PdcException(e);
        }
    }

    @Override
    public List<Integer> findSilverContentIdByPosition(SearchContext containerPosition, List<String> alComponentId) throws PdcException {
        return this.findSilverContentIdByPosition(containerPosition, alComponentId, true, true);
    }

    private List<Integer> findSilverContentIdByPosition(SearchContext containerPosition, List<String> alComponentId, boolean recursiveSearch, boolean visibilitySensitive) throws PdcException {
        return this.findSilverContentIdByPosition(containerPosition, alComponentId, null, null, null, recursiveSearch, visibilitySensitive);
    }

    private List<PdcAxisValue> findRecursivelyAllChildrenOf(PdcAxisValue axisValue) {
        Set<PdcAxisValue> directChildrenOfValue = axisValue.getChildValues();
        ArrayList<PdcAxisValue> allChildren = new ArrayList<PdcAxisValue>(directChildrenOfValue);
        for (PdcAxisValue aChild : directChildrenOfValue) {
            allChildren.addAll(this.findRecursivelyAllChildrenOf(aChild));
        }
        return allChildren;
    }

    @Override
    public List<GlobalSilverContent> getSilverContentsByIds(List<Integer> silverContentIds, String userId) {
        if (CollectionUtil.isEmpty(silverContentIds)) {
            return Collections.emptyList();
        }
        try {
            Map<String, GlobalSilverContentProcessor> processors = ServiceProvider.getAllServices(GlobalSilverContentProcessor.class, (Annotation[])new Annotation[0]).stream().collect(Collectors.toMap(GlobalSilverContentProcessor::relatedToComponent, p -> p));
            return this.contentMgtEngine.getResourceReferencesByContentIds(silverContentIds).stream().collect(Collectors.groupingBy(r -> SilverpeasComponentInstance.getComponentName((String)r.getComponentInstanceId()), Collectors.mapping(r -> r, Collectors.toList()))).entrySet().stream().flatMap(e -> {
                String componentName = (String)e.getKey();
                List references = (List)e.getValue();
                try {
                    SilverpeasContentManager contentManager;
                    List localSilverContents;
                    ContentPeas contentP = this.contentMgtEngine.getContentPeasByComponentName(componentName);
                    if (contentP != null && (localSilverContents = (contentManager = contentP.getContentManager()).getSilverContentByReference(references, userId)) != null) {
                        GlobalSilverContentProcessor processor = this.getGlobalSilverContentProcessor(processors, componentName);
                        return processor.asGlobalSilverContent(localSilverContents);
                    }
                }
                catch (Exception ex) {
                    SilverLogger.getLogger((Object)this).error("Can't retrieve content from taxonomy for component {0}", (Object[])new String[]{componentName}, (Throwable)ex);
                }
                return Stream.empty();
            }).collect(Collectors.toList());
        }
        catch (Exception e2) {
            throw new PdcRuntimeException(e2);
        }
    }

    private GlobalSilverContentProcessor getGlobalSilverContentProcessor(Map<String, GlobalSilverContentProcessor> processors, String c) {
        GlobalSilverContentProcessor processor = processors.get(c);
        if (processor == null) {
            processor = processors.get("default");
        }
        return processor;
    }
}

