/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.silverstatistics.volume.service;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.silverpeas.core.silverstatistics.volume.model.DirectoryStats;
import org.silverpeas.core.silverstatistics.volume.service.AbstractComputer;
import org.silverpeas.core.silverstatistics.volume.service.ComponentStatisticsProvider;

public class FileNumberComputer
extends AbstractComputer {
    private long count = 0L;

    FileNumberComputer(File directory, boolean onlyComponentData) {
        super(directory, onlyComponentData);
    }

    @Override
    protected void handleTransverseFile(Path file, BasicFileAttributes attrs) {
        ++this.count;
    }

    @Override
    protected void setTransverseResult(DirectoryStats result) {
        result.addFileNumber(this.count);
    }

    @Override
    protected void setSpecificResult(DirectoryStats result, ComponentStatisticsProvider componentStatistics) {
        result.addFileNumber(componentStatistics.countSpecificFiles(result.getDirectoryName()));
    }
}

