/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.silverstatistics.volume.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import org.silverpeas.core.silverstatistics.volume.model.SilverStatisticsConfigException;
import org.silverpeas.core.silverstatistics.volume.model.SilverStatisticsTypeStatisticsException;
import org.silverpeas.core.silverstatistics.volume.model.StatDataType;
import org.silverpeas.core.silverstatistics.volume.model.StatType;
import org.silverpeas.core.silverstatistics.volume.model.StatisticMode;
import org.silverpeas.core.silverstatistics.volume.model.TypeStatistics;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;

public class StatisticsConfig {
    private static final String STATS_KEYS_NAME = "StatsKeysName";
    private static final String STATS_KEYS_TYPE = "StatsKeysType";
    private static final String STATS_FAMILY = "StatsFamily";
    private static final String STATS_SEPARATOR = "StatsSeparator";
    private static final String STATS_KEYS_CUMUL = "StatsKeysCumul";
    private static final String STATS_TABLE_NAME = "StatsTableName";
    private static final String STATS_RUN = "StatsRun";
    private static final String STATS_ASYNCHRON = "StatsAsynchron";
    private static final String STATS_PURGE_IN_MONTH = "StatsPurgeInMonth";
    private static final String STATS_MODE_CUMUL = "StatsModeCumul";
    private final Map<StatType, TypeStatistics> allStatisticsConfig = new EnumMap<StatType, TypeStatistics>(StatType.class);
    private boolean initGood;

    public void initialize(SettingBundle settings) throws SilverStatisticsConfigException {
        String configTypeName = "";
        try {
            this.initGood = true;
            String tokenSeparator = settings.getString(STATS_SEPARATOR);
            StringTokenizer stTypeStats = new StringTokenizer(settings.getString(STATS_FAMILY), tokenSeparator);
            while (stTypeStats.hasMoreTokens()) {
                TypeStatistics currentType = new TypeStatistics();
                currentType.setName(stTypeStats.nextToken());
                configTypeName = currentType.getName();
                StatisticsConfig.initTypeStatistics(settings, currentType);
                StringTokenizer stKeyName = new StringTokenizer(settings.getString(STATS_KEYS_NAME + currentType.getName()), tokenSeparator);
                StringTokenizer stKeyType = new StringTokenizer(settings.getString(STATS_KEYS_TYPE + currentType.getName()), tokenSeparator);
                StringTokenizer stKeyCumul = new StringTokenizer(settings.getString(STATS_KEYS_CUMUL + currentType.getName()), tokenSeparator);
                while (stKeyName.hasMoreTokens()) {
                    currentType.addKey(stKeyName.nextToken(), StatDataType.valueOf(stKeyType.nextToken()));
                }
                while (stKeyCumul.hasMoreTokens()) {
                    currentType.addCumulKey(stKeyCumul.nextToken());
                }
                this.allStatisticsConfig.put(StatType.valueOf(currentType.getName()), currentType);
            }
        }
        catch (SilverStatisticsTypeStatisticsException e) {
            this.initGood = false;
            throw new SilverStatisticsConfigException("Error with config file", configTypeName, (Exception)((Object)e));
        }
        catch (MissingResourceException e) {
            this.initGood = false;
            throw new SilverStatisticsConfigException("setting missing in config file", configTypeName, e);
        }
    }

    private static void initTypeStatistics(SettingBundle settings, TypeStatistics currentType) throws SilverStatisticsTypeStatisticsException {
        currentType.setTableName(settings.getString(STATS_TABLE_NAME + currentType.getName()));
        try {
            currentType.setIsRun(settings.getBoolean(STATS_RUN + currentType.getName()));
            currentType.setPurge(settings.getInteger(STATS_PURGE_IN_MONTH + currentType.getName()));
            currentType.setIsAsynchron(settings.getBoolean(STATS_ASYNCHRON + currentType.getName()));
            currentType.setModeCumul(StatisticMode.valueOf(settings.getString(STATS_MODE_CUMUL + currentType.getName())));
        }
        catch (MissingResourceException | SilverStatisticsTypeStatisticsException object) {
            // empty catch block
        }
    }

    public void init() throws SilverStatisticsConfigException {
        SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.silverstatistics.SilverStatistics");
        this.initialize(settings);
    }

    public List<String> getAllKeys(StatType typeOfStats) {
        if (this.allStatisticsConfig.containsKey((Object)typeOfStats)) {
            return this.allStatisticsConfig.get((Object)typeOfStats).getAllKeys();
        }
        return new ArrayList<String>();
    }

    public String getKeyType(StatType typeOfStats, String keyName) {
        if (this.allStatisticsConfig.containsKey((Object)typeOfStats)) {
            return this.allStatisticsConfig.get((Object)typeOfStats).getKeyType(keyName).name();
        }
        return null;
    }

    public String getTableName(StatType typeOfStats) {
        if (this.allStatisticsConfig.containsKey((Object)typeOfStats)) {
            return this.allStatisticsConfig.get((Object)typeOfStats).getTableName();
        }
        return null;
    }

    public StatisticMode getModeCumul(StatType typeOfStats) {
        if (this.allStatisticsConfig.containsKey((Object)typeOfStats)) {
            return this.allStatisticsConfig.get((Object)typeOfStats).getModeCumul();
        }
        return null;
    }

    public boolean isRun(StatType typeOfStats) {
        return this.allStatisticsConfig.containsKey((Object)typeOfStats) && this.allStatisticsConfig.get((Object)typeOfStats).isRun();
    }

    public boolean isAsynchron(StatType typeOfStats) {
        return this.allStatisticsConfig.containsKey((Object)typeOfStats) && this.allStatisticsConfig.get((Object)typeOfStats).isAsynchron();
    }

    public int getNumberOfStatsType() {
        return this.allStatisticsConfig.size();
    }

    public boolean isExist(StatType idFamilyStats) {
        return this.allStatisticsConfig.containsKey((Object)idFamilyStats);
    }

    public int getNumberOfKeys(StatType idFamilyStats) {
        if (this.allStatisticsConfig.containsKey((Object)idFamilyStats)) {
            return this.allStatisticsConfig.get((Object)idFamilyStats).numberOfKeys();
        }
        return 0;
    }

    public boolean isCumulKey(StatType typeOfStats, String keyName) {
        if (this.allStatisticsConfig.containsKey((Object)typeOfStats)) {
            return this.allStatisticsConfig.get((Object)typeOfStats).isCumulKey(keyName);
        }
        return false;
    }

    public int indexOfKey(StatType typeOfStats, String keyName) {
        if (this.allStatisticsConfig.containsKey((Object)typeOfStats)) {
            return this.allStatisticsConfig.get((Object)typeOfStats).indexOfKey(keyName);
        }
        return -1;
    }

    public Collection<StatType> getAllTypes() {
        return this.allStatisticsConfig.keySet();
    }

    public int getPurge(StatType typeOfStats) {
        if (this.allStatisticsConfig.containsKey((Object)typeOfStats)) {
            return this.allStatisticsConfig.get((Object)typeOfStats).getPurge();
        }
        return 0;
    }

    public boolean isValidConfigFile() {
        boolean valueReturn = true;
        for (Map.Entry<StatType, TypeStatistics> currentType : this.allStatisticsConfig.entrySet()) {
            if (!this.initGood) {
                valueReturn = false;
            }
            if (!this.isExist(currentType.getKey())) {
                valueReturn = false;
            }
            if (!currentType.getValue().hasGoodCumulKey()) {
                valueReturn = false;
            }
            if (currentType.getValue().isDateStatKeyExist()) continue;
            valueReturn = false;
        }
        return valueReturn;
    }

    public boolean areGoodData(StatType typeOfStats, List<String> data) {
        return this.initGood && this.isExist(typeOfStats) && this.allStatisticsConfig.get((Object)typeOfStats).hasGoodCumulKey() && this.allStatisticsConfig.get((Object)typeOfStats).isDateStatKeyExist() && data.size() == this.getNumberOfKeys(typeOfStats);
    }
}

