/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.silverstatistics.volume.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.silverpeas.core.silverstatistics.volume.dao.AbstractSilverStatisticsDAO;
import org.silverpeas.core.silverstatistics.volume.model.StatType;
import org.silverpeas.core.silverstatistics.volume.model.StatisticsConfig;
import org.silverpeas.kernel.util.StringUtil;

public class SilverStatisticsDAO
extends AbstractSilverStatisticsDAO {
    private static final String DECIMAL = "DECIMAL";
    private static final String INTEGER = "INTEGER";

    private SilverStatisticsDAO() {
    }

    static void insertDataStats(Connection con, StatType type, List<String> valueKeys, StatisticsConfig conf) throws SQLException {
        SilverStatisticsDAO.insertData(con, conf.getTableName(type), type, valueKeys, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void putDataStats(Connection con, StatType type, List<String> valueKeys, StatisticsConfig conf) throws SQLException {
        String tableName = conf.getTableName(type);
        AbstractSilverStatisticsDAO.Statements statements = SilverStatisticsDAO.computeStatements(tableName, type, valueKeys, conf);
        if (statements.isStopStatOp()) {
            return;
        }
        String selectStatement = statements.getSelectStatement();
        String updateStatement = statements.getUpdateStatement();
        List<String> theKeys = statements.getKeys();
        boolean rowExist = false;
        try (Statement stmt = con.createStatement();
             ResultSet rs = stmt.executeQuery(selectStatement);){
            while (rs.next()) {
                PreparedStatement pstmt = con.prepareStatement(updateStatement);
                try {
                    rowExist = true;
                    SilverStatisticsDAO.initUpdateStatement(pstmt, theKeys, valueKeys, type, conf);
                    pstmt.executeUpdate();
                }
                finally {
                    if (pstmt == null) continue;
                    pstmt.close();
                }
            }
            return;
        }
        finally {
            if (!rowExist) {
                SilverStatisticsDAO.insertDataStats(con, type, valueKeys, conf);
            }
        }
    }

    private static void initUpdateStatement(PreparedStatement pstmt, List<String> theKeys, List<String> valueKeys, StatType type, StatisticsConfig conf) throws SQLException {
        int countCumulKey = 0;
        for (String keyNameCurrent : theKeys) {
            if (!conf.isCumulKey(type, keyNameCurrent)) continue;
            ++countCumulKey;
            String currentType = conf.getKeyType(type, keyNameCurrent);
            String currentValue = valueKeys.get(conf.indexOfKey(type, keyNameCurrent));
            if (currentType.equals(INTEGER)) {
                int intToAdd = StringUtil.isInteger((String)currentValue) ? Integer.parseInt(currentValue) : 0;
                pstmt.setInt(countCumulKey, intToAdd);
            }
            if (!currentType.equals(DECIMAL)) continue;
            long longToAdd = StringUtil.isLong((String)currentValue) ? Long.parseLong(currentValue) : 0L;
            pstmt.setLong(countCumulKey, longToAdd);
        }
    }
}

