/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import java.util.List;
import org.springframework.social.facebook.api.Achievement;
import org.springframework.social.facebook.api.AchievementOperations;
import org.springframework.social.facebook.api.AchievementType;
import org.springframework.social.facebook.api.GraphApi;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AchievementTemplate
implements AchievementOperations {
    private GraphApi graphApi;

    public AchievementTemplate(GraphApi graphApi) {
        this.graphApi = graphApi;
    }

    @Override
    public Achievement getAchievement(String achievementId) {
        return this.graphApi.fetchObject(achievementId, Achievement.class);
    }

    @Override
    public List<Achievement> getAchievements() {
        return this.graphApi.fetchConnections("me", "achievements", Achievement.class, new String[0]);
    }

    @Override
    public String postAchievement(String achievementUrl) {
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        data.set((Object)"achievement", (Object)achievementUrl);
        return this.graphApi.publish("me", "achievements", (MultiValueMap<String, Object>)data);
    }

    @Override
    public void removeAchievement(String achievementUrl) {
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        data.set((Object)"achievement", (Object)achievementUrl);
        this.graphApi.delete("me", "achievements", (MultiValueMap<String, String>)data);
    }

    @Override
    public List<AchievementType> getAchievementTypes() {
        return this.graphApi.fetchConnections("app", "achievements", AchievementType.class, new String[0]);
    }

    @Override
    public AchievementType getAchievementType(String achievementTypeId) {
        return this.graphApi.fetchObject(achievementTypeId, AchievementType.class);
    }

    @Override
    public void createAchievementType(String achievementTypeUrl, int displayOrder) {
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        data.set((Object)"achievement", (Object)achievementTypeUrl);
        data.set((Object)"display_order", (Object)String.valueOf(displayOrder));
        this.graphApi.post("app", "achievements", (MultiValueMap<String, Object>)data);
    }

    @Override
    public void removeAchievementType(String achievementTypeUrl) {
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        data.set((Object)"achievement", (Object)achievementTypeUrl);
        this.graphApi.delete("app", "achievements", (MultiValueMap<String, String>)data);
    }
}

