/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.portlet.impl;

import com.sun.portal.container.ChannelURLFactory;
import com.sun.portal.container.ContainerLogger;
import com.sun.portal.portletcontainer.common.PortletContainerRequest;
import com.sun.portal.portletcontainer.common.PortletContainerResponse;
import com.sun.portal.portletcontainer.common.descriptor.PortletAppDescriptor;
import com.sun.portal.portletcontainer.common.descriptor.PortletDescriptor;
import com.sun.portal.portletcontainer.portlet.impl.PortletURLImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.BaseURL;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.PortletURLGenerationListener;
import javax.portlet.ResourceURL;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class PortletResponseImpl
implements PortletResponse {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private PortletContainerRequest pcRequest;
    private PortletContainerResponse pcResponse;
    private PortletRequest portletRequest;
    private PortletAppDescriptor portletAppDescriptor;
    private PortletDescriptor portletDescriptor;
    private Document document;
    private String namespace;
    private static Logger logger = ContainerLogger.getLogger(PortletResponseImpl.class, (String)"PAELogMessages");

    protected void init(HttpServletRequest request, HttpServletResponse response, PortletContainerRequest pcRequest, PortletContainerResponse pcResponse, PortletRequest portletRequest, PortletAppDescriptor portletAppDescriptor, PortletDescriptor portletDescriptor) {
        this.request = request;
        this.response = response;
        this.pcRequest = pcRequest;
        this.pcResponse = pcResponse;
        this.portletRequest = portletRequest;
        this.portletAppDescriptor = portletAppDescriptor;
        this.portletDescriptor = portletDescriptor;
        this.namespace = this.pcRequest.getNamespace();
    }

    protected void clear() {
        this.request = null;
        this.response = null;
        this.pcRequest = null;
        this.pcResponse = null;
        this.portletRequest = null;
        this.portletAppDescriptor = null;
        this.portletDescriptor = null;
    }

    protected HttpServletRequest getHttpServletRequest() {
        return this.request;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.response;
    }

    protected PortletContainerRequest getPortletContainerRequest() {
        return this.pcRequest;
    }

    protected PortletContainerResponse getPortletContainerResponse() {
        return this.pcResponse;
    }

    protected PortletAppDescriptor getPortletAppDescriptor() {
        return this.portletAppDescriptor;
    }

    protected PortletDescriptor getPortletDescriptor() {
        return this.portletDescriptor;
    }

    public void addProperty(String key, String value) {
        this.checkNullProperty(key);
        Map<String, List<String>> properties = this.pcResponse.getStringProperties();
        List<String> values = null;
        if (properties == null) {
            properties = new HashMap<String, List<String>>();
        } else {
            values = properties.get(key);
        }
        if (values == null) {
            values = new ArrayList<String>();
        }
        values.add(value);
        properties.put(key, values);
        this.pcResponse.setStringProperties(properties);
    }

    public void addProperty(Cookie cookie) {
        this.checkNullCookie(cookie);
        List<Cookie> properties = this.pcResponse.getCookieProperties();
        if (properties == null) {
            properties = new ArrayList<Cookie>();
        }
        properties.add(cookie);
        this.pcResponse.setCookieProperties(properties);
    }

    public void addProperty(String key, Element element) {
        this.checkNullProperty(key);
        Map<String, List<Element>> properties = this.pcResponse.getElementProperties();
        if (properties == null) {
            if (element != null) {
                properties = new HashMap<String, List<Element>>();
                ArrayList<Element> values = new ArrayList<Element>();
                values.add(element);
                properties.put(key, values);
            }
        } else {
            List<Element> values = properties.get(key);
            if (element == null) {
                properties.remove(key);
            } else {
                if (values == null) {
                    values = new ArrayList<Element>();
                }
                values.add(element);
                properties.put(key, values);
            }
        }
        this.pcResponse.setElementProperties(properties);
    }

    public Element createElement(String tagName) {
        if (this.document == null) {
            try {
                DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
                this.document = dbfactory.newDocumentBuilder().newDocument();
            }
            catch (ParserConfigurationException e) {
                throw new IllegalStateException("Cannot create the document builder factory", e);
            }
        }
        return this.document.createElement(tagName);
    }

    public void setProperty(String key, String value) {
        this.checkNullProperty(key);
        Map<String, List<String>> properties = this.pcResponse.getStringProperties();
        if (properties == null) {
            properties = new HashMap<String, List<String>>();
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        properties.put(key, values);
        this.pcResponse.setStringProperties(properties);
    }

    public String encodeURL(String path) {
        ChannelURLFactory portletWindowURLFactory = this.getPortletContainerRequest().getPortletWindowURLFactory();
        if (path.startsWith("/") || path.indexOf(":") != -1) {
            return portletWindowURLFactory.encodeURL(this.getHttpServletRequest(), this.getHttpServletResponse(), path);
        }
        logger.log(Level.WARNING, "PSPL_PAECSPPI0022", path);
        throw new IllegalArgumentException("Path:" + path + " must be a valid absolute URL or a full path URI");
    }

    public String getNamespace() {
        return this.namespace;
    }

    public PortletURL createRenderURL() throws IllegalStateException {
        PortletURLImpl url = new PortletURLImpl(this.portletRequest, this.pcRequest, this.getPortletAppDescriptor(), this.getPortletDescriptor(), "RENDER");
        this.callURLGenerationListeners("RENDER", url);
        return url;
    }

    public PortletURL createActionURL() throws IllegalStateException {
        PortletURLImpl url = new PortletURLImpl(this.portletRequest, this.pcRequest, this.getPortletAppDescriptor(), this.getPortletDescriptor(), "ACTION");
        this.callURLGenerationListeners("ACTION", url);
        return url;
    }

    protected void callURLGenerationListeners(String action, BaseURL portletURL) {
        List<PortletURLGenerationListener> urlGenerationListeners = this.getPortletAppDescriptor().getURLGenerationListeners();
        if (urlGenerationListeners != null) {
            for (PortletURLGenerationListener listener : urlGenerationListeners) {
                if ("ACTION".equals(action)) {
                    listener.filterActionURL((PortletURL)portletURL);
                    continue;
                }
                if ("RENDER".equals(action)) {
                    listener.filterRenderURL((PortletURL)portletURL);
                    continue;
                }
                if (!"RESOURCE".equals(action)) continue;
                listener.filterResourceURL((ResourceURL)portletURL);
            }
        }
    }

    protected void checkNullProperty(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Property name should not be null.");
        }
    }

    protected void checkNullCookie(Cookie cookie) {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie should not be null.");
        }
    }
}

