/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.appengine;

import com.sun.portal.container.ContainerLogger;
import com.sun.portal.container.service.ServiceFinder;
import com.sun.portal.portletcontainer.appengine.PortletAppEngineInterceptor;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortletAppEngineFilter
implements Filter {
    private ServletContext context;
    private PortletAppEngineInterceptor portletAppEngineInterceptor;
    private static Logger logger = ContainerLogger.getLogger(PortletAppEngineFilter.class, (String)"PAELogMessages");

    public void init(FilterConfig config) throws ServletException {
        this.context = config.getServletContext();
        try {
            Object implObject = ServiceFinder.getServiceImplementationInstance((String)PortletAppEngineInterceptor.class.getName());
            if (implObject != null) {
                this.portletAppEngineInterceptor = (PortletAppEngineInterceptor)implObject;
                this.portletAppEngineInterceptor.init(this.context);
                logger.log(Level.FINE, "PSPL_PAECSPPA0017");
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "PSPL_PAECSPPA0016", e);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        if (this.portletAppEngineInterceptor != null) {
            this.portletAppEngineInterceptor.beforeInvoke(httpServletRequest, httpServletResponse);
        }
        chain.doFilter(request, response);
        if (this.portletAppEngineInterceptor != null) {
            this.portletAppEngineInterceptor.afterInvoke(httpServletRequest, httpServletResponse);
        }
    }

    public void destroy() {
        if (this.portletAppEngineInterceptor != null) {
            this.portletAppEngineInterceptor.destroy();
        }
    }
}

