/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jcetaglib.test;

import java.security.Key;
import java.security.KeyPair;
import java.security.PublicKey;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.sourceforge.jcetaglib.lib.Crypt;
import net.sourceforge.jcetaglib.lib.DHKeyAgreement;
import net.sourceforge.jcetaglib.test.RunTest;

public class DHKeyAgreementTest
extends TestCase {
    private StringBuffer ciphertext = null;
    private StringBuffer plaintext = null;

    public void testAgreement() throws Exception {
        KeyPair alicekeypair = DHKeyAgreement.generateDHKeyPair();
        KeyPair bobkeypair = DHKeyAgreement.generateDHKeyPair();
        byte[] bytealicekey = DHKeyAgreement.publicKeyToBytes(alicekeypair.getPublic());
        byte[] bytebobkey = DHKeyAgreement.publicKeyToBytes(bobkeypair.getPublic());
        PublicKey alicepub = DHKeyAgreement.bytesToPublicKey(bytealicekey);
        PublicKey bobpub = DHKeyAgreement.bytesToPublicKey(bytebobkey);
        Key alicekey = DHKeyAgreement.generateSessionKey(bobpub, alicekeypair.getPrivate(), "AES", 256);
        Key bobkey = DHKeyAgreement.generateSessionKey(alicepub, bobkeypair.getPrivate(), "AES", 256);
        Assert.assertEquals((Object)alicekey, (Object)bobkey);
        for (int i = 0; i < RunTest.text.length; ++i) {
            this.ciphertext = Crypt.encrypt(RunTest.text[i], alicekey, "AES", "CBC", "PKCS7Padding", null);
            this.plaintext = Crypt.decrypt(this.ciphertext, bobkey, "AES", "CBC", "PKCS7Padding");
            Assert.assertEquals((String)this.plaintext.toString(), (String)RunTest.text[i].toString());
        }
    }
}

