/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jcetaglib.lib;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import net.sourceforge.jcetaglib.exceptions.CryptoException;
import net.sourceforge.jcetaglib.lib.Keystore;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public class Digesters {
    private static int BUFFERSIZE_TEXT = 64;
    private static int BUFFERSIZE_FILE = 8192;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StringBuffer hash(StringBuffer text, String algorithm) throws CryptoException {
        StringBuffer stringBuffer;
        ByteArrayOutputStream bao = null;
        DataOutputStream dao = null;
        try {
            try {
                bao = new ByteArrayOutputStream();
                dao = new DataOutputStream(bao);
                Digesters.hash(new ByteArrayInputStream(text.toString().getBytes()), dao, algorithm, BUFFERSIZE_TEXT);
                stringBuffer = new StringBuffer(new String(Base64.encode((byte[])bao.toByteArray())));
                Object var6_6 = null;
                if (dao == null) return stringBuffer;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new CryptoException(ioe.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (dao == null) throw throwable;
            try {
                dao.close();
                throw throwable;
            }
            catch (IOException e) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return stringBuffer;
        }
        dao.close();
        return stringBuffer;
    }

    /*
     * Loose catch block
     */
    public static StringBuffer hashFile(String file, String algorithm) throws CryptoException {
        IOException e22;
        StringBuffer stringBuffer;
        FilterOutputStream dao;
        FileInputStream fis;
        block12: {
            fis = null;
            ByteArrayOutputStream bao = null;
            dao = null;
            fis = new FileInputStream(file);
            bao = new ByteArrayOutputStream();
            dao = new DataOutputStream(bao);
            Digesters.hash(fis, (DataOutputStream)dao, algorithm, BUFFERSIZE_FILE);
            stringBuffer = new StringBuffer(new String(Base64.encode((byte[])bao.toByteArray())));
            Object var7_7 = null;
            if (dao == null) break block12;
            try {
                dao.close();
            }
            catch (IOException e22) {
                // empty catch block
            }
        }
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException e22) {
                // empty catch block
            }
        }
        return stringBuffer;
        catch (IOException ioe) {
            try {
                ioe.printStackTrace();
                throw new CryptoException(ioe.getMessage());
            }
            catch (Throwable throwable) {
                block14: {
                    IOException e22;
                    Object var7_8 = null;
                    if (dao != null) {
                        try {
                            dao.close();
                        }
                        catch (IOException e22) {
                            // empty catch block
                        }
                    }
                    if (fis == null) break block14;
                    try {
                        fis.close();
                    }
                    catch (IOException e22) {}
                }
                throw throwable;
            }
        }
    }

    public static void hash(InputStream is, DataOutputStream daos, String algorithm, int bufferlength) throws CryptoException, IOException {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            MessageDigest digest = MessageDigest.getInstance(algorithm, "BC");
            byte[] buffer = new byte[bufferlength];
            int length = 0;
            while ((length = is.read(buffer)) != -1) {
                digest.update(buffer, 0, length);
            }
            byte[] result = digest.digest();
            daos.write(result);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new IOException(ioe.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CryptoException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StringBuffer formDigest(StringBuffer text, String digest, String keyfile, StringBuffer passphrase, String algorithm) throws CryptoException, IOException {
        StringBuffer stringBuffer;
        Key key = null;
        ByteArrayOutputStream outStr = null;
        FilterOutputStream dataStr = null;
        try {
            try {
                Security.addProvider((Provider)new BouncyCastleProvider());
                key = Keystore.loadKey(algorithm, keyfile, passphrase);
                outStr = new ByteArrayOutputStream();
                dataStr = new DataOutputStream(outStr);
                dataStr.write(key.getEncoded());
                ((DataOutputStream)dataStr).writeBytes(text.toString());
                stringBuffer = Digesters.hash(new StringBuffer(outStr.toString()), digest);
                Object var10_11 = null;
                if (dataStr == null) return stringBuffer;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new IOException(ioe.getMessage());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new CryptoException(ex.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (dataStr == null) throw throwable;
            try {
                dataStr.close();
                throw throwable;
            }
            catch (IOException e) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return stringBuffer;
        }
        dataStr.close();
        return stringBuffer;
    }
}

