/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jcetaglib.lib;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import net.sourceforge.jcetaglib.exceptions.CryptoException;
import net.sourceforge.jcetaglib.exceptions.KeystoreException;
import net.sourceforge.jcetaglib.lib.Keystore;
import net.sourceforge.jcetaglib.lib.Seed;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public class Crypt {
    private static int BUFFERSIZE_TEXT = 64;
    private static int BUFFERSIZE_FILE = 8192;

    public static StringBuffer encrypt(StringBuffer text, String keyfile, StringBuffer passphrase, String algorithm, String mode, String padding, byte[] seed) throws CryptoException, KeystoreException {
        Key secretKey = Keystore.loadKey(algorithm, keyfile, passphrase);
        return Crypt.encrypt(text, secretKey, algorithm, mode, padding, seed);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StringBuffer encrypt(StringBuffer text, Key secretKey, String algorithm, String mode, String padding, byte[] seed) throws CryptoException {
        StringBuffer stringBuffer;
        ByteArrayOutputStream bao = null;
        DataOutputStream dao = null;
        try {
            try {
                bao = new ByteArrayOutputStream();
                dao = new DataOutputStream(bao);
                Crypt.encrypt(new ByteArrayInputStream(text.toString().getBytes()), dao, secretKey, algorithm, mode, padding, seed, BUFFERSIZE_TEXT);
                stringBuffer = new StringBuffer(new String(Base64.encode((byte[])bao.toByteArray())));
                Object var10_10 = null;
                if (dao == null) return stringBuffer;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new CryptoException(ioe.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (dao == null) throw throwable;
            try {
                dao.close();
                throw throwable;
            }
            catch (IOException e) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return stringBuffer;
        }
        dao.close();
        return stringBuffer;
    }

    /*
     * Loose catch block
     */
    public static void encryptFile(String file, String newfile, String keyfile, StringBuffer passphrase, String algorithm, String mode, String padding, byte[] seed) throws CryptoException, IOException, KeystoreException {
        block14: {
            IOException e22;
            FilterOutputStream dao;
            FileInputStream fis;
            block13: {
                fis = null;
                FileOutputStream fos = null;
                dao = null;
                fis = new FileInputStream(file);
                fos = new FileOutputStream(newfile);
                dao = new DataOutputStream(fos);
                Key secretKey = Keystore.loadKey(algorithm, keyfile, passphrase);
                Crypt.encrypt(fis, (DataOutputStream)dao, secretKey, algorithm, mode, padding, seed, BUFFERSIZE_FILE);
                Object var13_13 = null;
                if (dao == null) break block13;
                try {
                    dao.close();
                }
                catch (IOException e22) {
                    // empty catch block
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e22) {}
            }
            break block14;
            {
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    throw new IOException(ioe.getMessage());
                }
            }
            catch (Throwable throwable) {
                IOException e22;
                Object var13_14 = null;
                if (dao != null) {
                    try {
                        dao.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void encrypt(InputStream is, DataOutputStream daos, Key secretKey, String algorithm, String mode, String padding, byte[] seed, int bufferlength) throws CryptoException, IOException {
        IvParameterSpec spec = null;
        byte[] iv = null;
        Cipher cipher = null;
        CipherOutputStream cStr = null;
        try {
            try {
                cipher = algorithm.equalsIgnoreCase("RC4") ? Cipher.getInstance("RC4") : Cipher.getInstance(algorithm + "/" + mode + "/" + padding, "BC");
                if (mode.equalsIgnoreCase("ECB") || algorithm.equalsIgnoreCase("RC4")) {
                    cipher.init(1, secretKey);
                } else {
                    SecureRandom sr = Seed.getSecureRandom(seed);
                    iv = new byte[cipher.getBlockSize()];
                    sr.nextBytes(iv);
                    spec = new IvParameterSpec(iv);
                    cipher.init(1, secretKey, spec);
                }
                cStr = new CipherOutputStream(daos, cipher);
                if (iv != null) {
                    daos.write(iv);
                }
                byte[] buffer = new byte[bufferlength];
                int length = 0;
                while ((length = is.read(buffer)) != -1) {
                    cStr.write(buffer, 0, length);
                }
                Object var15_16 = null;
                if (cStr == null) return;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new IOException(ioe.getMessage());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new CryptoException(ex.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            if (cStr == null) throw throwable;
            try {
                cStr.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        cStr.close();
        return;
    }

    public static StringBuffer decrypt(StringBuffer text, String keyfile, StringBuffer passphrase, String algorithm, String mode, String padding) throws CryptoException, KeystoreException {
        Key secretKey = Keystore.loadKey(algorithm, keyfile, passphrase);
        return Crypt.decrypt(text, secretKey, algorithm, mode, padding);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StringBuffer decrypt(StringBuffer text, Key secretKey, String algorithm, String mode, String padding) throws CryptoException {
        StringBuffer stringBuffer;
        ByteArrayOutputStream bao = null;
        DataOutputStream dao = null;
        try {
            try {
                bao = new ByteArrayOutputStream();
                dao = new DataOutputStream(bao);
                Crypt.decrypt(new ByteArrayInputStream(Base64.decode((String)text.toString())), dao, secretKey, algorithm, mode, padding, BUFFERSIZE_TEXT);
                stringBuffer = new StringBuffer(new String(bao.toByteArray()));
                Object var9_9 = null;
                if (dao == null) return stringBuffer;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new CryptoException(ioe.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (dao == null) throw throwable;
            try {
                dao.close();
                throw throwable;
            }
            catch (IOException e) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return stringBuffer;
        }
        dao.close();
        return stringBuffer;
    }

    /*
     * Loose catch block
     */
    public static void decryptFile(String file, String newfile, String keyfile, StringBuffer passphrase, String algorithm, String mode, String padding) throws CryptoException, KeystoreException, IOException {
        block14: {
            IOException e22;
            FilterOutputStream dao;
            FileInputStream fis;
            block13: {
                fis = null;
                FileOutputStream fos = null;
                dao = null;
                fis = new FileInputStream(file);
                fos = new FileOutputStream(newfile);
                dao = new DataOutputStream(fos);
                Key secretKey = Keystore.loadKey(algorithm, keyfile, passphrase);
                Crypt.decrypt(fis, (DataOutputStream)dao, secretKey, algorithm, mode, padding, BUFFERSIZE_FILE);
                Object var12_12 = null;
                if (dao == null) break block13;
                try {
                    dao.close();
                }
                catch (IOException e22) {
                    // empty catch block
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e22) {}
            }
            break block14;
            {
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    throw new IOException(ioe.getMessage());
                }
            }
            catch (Throwable throwable) {
                IOException e22;
                Object var12_13 = null;
                if (dao != null) {
                    try {
                        dao.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void decrypt(InputStream is, DataOutputStream daos, Key secretKey, String algorithm, String mode, String padding, int bufferlength) throws CryptoException, IOException {
        Cipher cipher = null;
        IvParameterSpec spec = null;
        byte[] iv = null;
        CipherInputStream cStr = null;
        try {
            try {
                Security.addProvider((Provider)new BouncyCastleProvider());
                cipher = algorithm.equalsIgnoreCase("RC4") ? Cipher.getInstance("RC4") : Cipher.getInstance(algorithm + "/" + mode + "/" + padding, "BC");
                if (mode.equalsIgnoreCase("ECB") || algorithm.equalsIgnoreCase("RC4")) {
                    cipher.init(2, secretKey);
                } else {
                    iv = new byte[cipher.getBlockSize()];
                    is.read(iv);
                    spec = new IvParameterSpec(iv);
                    cipher.init(2, secretKey, spec);
                }
                cStr = new CipherInputStream(is, cipher);
                byte[] buffer = new byte[bufferlength];
                int length = 0;
                while ((length = cStr.read(buffer)) != -1) {
                    daos.write(buffer, 0, length);
                }
                Object var14_15 = null;
                if (cStr == null) return;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new IOException(ioe.getMessage());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new CryptoException(ex.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            if (cStr == null) throw throwable;
            try {
                cStr.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        cStr.close();
        return;
    }
}

