/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.calendar;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.silverpeas.calendar.api.CalendarEntry;

public class ServletConnector {
    private String servletURL = null;

    public ServletConnector(String servletUrl) {
        this.servletURL = servletUrl;
    }

    public final String sendHeaders(List<CalendarEntry> headers) {
        String report = "";
        try {
            URLConnection con = this.getServletConnection();
            this.write(headers, con.getOutputStream());
            InputStream instr = con.getInputStream();
            report = IOUtils.toString((InputStream)instr, (String)"UTF-8");
            instr.close();
        }
        catch (MalformedURLException e) {
            report = "URL de la servlet de synchronisation incorrecte.";
            e.printStackTrace();
        }
        catch (IOException e) {
            report = "Probleme d'entree/sortie.";
            e.printStackTrace();
        }
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(List<CalendarEntry> headers, OutputStream out) throws IOException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, false);
            mapper.configure(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS, true);
            mapper.configure(SerializationConfig.Feature.USE_ANNOTATIONS, false);
            mapper.writeValue(out, headers);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    private final URLConnection getServletConnection() throws MalformedURLException, IOException {
        URL urlServlet = new URL(this.servletURL);
        URLConnection con = urlServlet.openConnection();
        con.setDoInput(true);
        con.setDoOutput(true);
        con.setUseCaches(false);
        con.setRequestProperty("Content-Type", "application/json");
        return con;
    }
}

