/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.tagcloud.service;

import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.annotation.PostConstruct;
import javax.annotation.Priority;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.service.DefaultPublicationService;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.tagcloud.dao.TagCloudPK;
import org.silverpeas.core.tagcloud.model.TagCloud;
import org.silverpeas.core.tagcloud.model.TagCloudUtil;
import org.silverpeas.core.tagcloud.service.TagCloudService;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;

@Service
@Singleton
@Alternative
@Priority(value=2010)
public class TagCloudPublicationService
extends DefaultPublicationService {
    private boolean useTagCloud;
    @Inject
    private TagCloudService tagCloudService;

    @PostConstruct
    protected void init() {
        super.init();
        SettingBundle publicationSettings = ResourceLocator.getSettingBundle((String)"org.silverpeas.publication.publicationSettings");
        this.useTagCloud = publicationSettings.getBoolean("useTagCloud", false);
    }

    @Transactional
    public PublicationPK createPublication(PublicationDetail detail) {
        PublicationPK pk = super.createPublication(detail);
        if (this.useTagCloud) {
            this.createTagCloud(detail);
        }
        return pk;
    }

    @Transactional
    public void setDetail(PublicationDetail detail) {
        super.setDetail(detail);
        if (this.useTagCloud) {
            this.updateTagCloud(detail);
        }
    }

    public void deleteIndex(PublicationPK pubPK) {
        super.deleteIndex(pubPK);
        if (this.useTagCloud) {
            this.deleteTagCloud(pubPK);
        }
    }

    private void createTagCloud(PublicationDetail pubDetail) {
        String keywords = pubDetail.getKeywords();
        if (keywords != null) {
            TagCloud tagCloud = new TagCloud(pubDetail.getInstanceId(), pubDetail.getId(), 0);
            StringTokenizer st = new StringTokenizer(keywords, " ");
            ArrayList<String> tagList = new ArrayList<String>();
            while (st.hasMoreElements()) {
                String tag = (String)st.nextElement();
                String tagKey = TagCloudUtil.getTag(tag);
                if (tagList.contains(tagKey)) continue;
                tagCloud.setTag(tagKey);
                tagCloud.setLabel(tag.toLowerCase(I18NHelper.defaultLocale));
                this.tagCloudService.createTagCloud(tagCloud);
                tagList.add(tagKey);
            }
        }
    }

    private void deleteTagCloud(PublicationPK pubPK) {
        this.tagCloudService.deleteTagCloud(new TagCloudPK(pubPK.getId(), pubPK.getInstanceId()), 0);
    }

    private void updateTagCloud(PublicationDetail pubDetail) {
        this.deleteTagCloud(pubDetail.getPK());
        this.createTagCloud(pubDetail);
    }
}

