/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.Map;
import org.springframework.social.linkedin.api.LinkedInProfile;
import org.springframework.social.linkedin.api.Recommendation;
import org.springframework.social.linkedin.api.impl.json.LinkedInObjectMixin;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class RecommendationMixin
extends LinkedInObjectMixin {
    @JsonCreator
    RecommendationMixin(@JsonProperty(value="id") String id, @JsonProperty(value="recommendationSnippet") String recommendationSnippet, @JsonProperty(value="recommendationText") String recommendationText, @JsonProperty(value="recommendationType") @JsonDeserialize(using=RecommendationTypeDeserializer.class) Recommendation.RecommendationType recommendationType, @JsonProperty(value="recommender") LinkedInProfile recommender, @JsonProperty(value="recommendee") LinkedInProfile recommendee) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RecommendationTypeDeserializer
    extends JsonDeserializer<Recommendation.RecommendationType> {
        private RecommendationTypeDeserializer() {
        }

        public Recommendation.RecommendationType deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Map nodeMap = (Map)jp.readValueAs(Map.class);
            return Recommendation.RecommendationType.valueOf(nodeMap.get("code").toString().replace('-', '_').toUpperCase());
        }
    }
}

