/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.social.linkedin.api.Group;
import org.springframework.social.linkedin.api.impl.json.DeserializationUtils;
import org.springframework.social.linkedin.api.impl.json.LinkedInObjectMixin;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class GroupMixin
extends LinkedInObjectMixin {
    @JsonProperty
    Boolean allowMemberInvites;
    @JsonProperty
    @JsonDeserialize(using=GroupCategoryDeserializer.class)
    Group.GroupCategory category;
    @JsonProperty
    @JsonDeserialize(using=GroupCountDeserializer.class)
    List<Group.GroupCount> countsByCategory;
    @JsonProperty
    String description;
    @JsonProperty
    Boolean isOpenToNonMembers;
    @JsonProperty
    String largeLogoUrl;
    @JsonProperty
    String locale;
    @JsonProperty
    Group.GroupPosts posts;
    @JsonProperty
    Group.GroupRelation relationToViewer;
    @JsonProperty
    String shortDescription;
    @JsonProperty
    String siteGroupUrl;
    @JsonProperty
    String smallLogoUrl;
    @JsonProperty
    String websiteUrl;

    @JsonCreator
    GroupMixin(@JsonProperty(value="id") Integer id, @JsonProperty(value="name") String name) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GroupCountDeserializer
    extends JsonDeserializer<List<Group.GroupCount>> {
        private GroupCountDeserializer() {
        }

        public List<Group.GroupCount> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return DeserializationUtils.deserializeFromDataNode(jp, ctxt, "values", new TypeReference<List<Group.GroupCount>>(){});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GroupCategoryDeserializer
    extends JsonDeserializer<Group.GroupCategory> {
        private GroupCategoryDeserializer() {
        }

        public Group.GroupCategory deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Map nodeMap = (Map)jp.readValueAs(Map.class);
            return Group.GroupCategory.valueOf(nodeMap.get("code").toString().replace('-', '_').toUpperCase());
        }
    }
}

