/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;

class JsonFormatHeaderRequestFactory
implements ClientHttpRequestFactory {
    private final ClientHttpRequestFactory delegate;

    public JsonFormatHeaderRequestFactory(ClientHttpRequestFactory delegate) {
        this.delegate = delegate;
    }

    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        return new JsonFormatWrappedRequest(this.delegate.createRequest(uri, httpMethod));
    }

    private static class JsonFormatWrappedRequest
    implements ClientHttpRequest {
        private final ClientHttpRequest delegate;
        private ByteArrayOutputStream bodyOutputStream;

        public JsonFormatWrappedRequest(ClientHttpRequest delegate) {
            this.delegate = delegate;
            this.bodyOutputStream = new ByteArrayOutputStream();
        }

        public ClientHttpResponse execute() throws IOException {
            byte[] bufferedOutput = this.bodyOutputStream.toByteArray();
            this.delegate.getBody().write(bufferedOutput);
            this.delegate.getHeaders().set("x-li-format", "json");
            return this.delegate.execute();
        }

        public URI getURI() {
            return this.delegate.getURI();
        }

        public HttpMethod getMethod() {
            return this.delegate.getMethod();
        }

        public HttpHeaders getHeaders() {
            return this.delegate.getHeaders();
        }

        public OutputStream getBody() throws IOException {
            return this.bodyOutputStream;
        }
    }
}

