/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import org.springframework.social.linkedin.api.Group;
import org.springframework.social.linkedin.api.GroupMemberships;
import org.springframework.social.linkedin.api.GroupOperations;
import org.springframework.social.linkedin.api.GroupSuggestions;
import org.springframework.social.linkedin.api.PostComments;
import org.springframework.social.linkedin.api.impl.AbstractTemplate;
import org.springframework.web.client.RestOperations;

class GroupTemplate
extends AbstractTemplate
implements GroupOperations {
    private final RestOperations restOperations;
    public static final String BASE_URL = "https://api.linkedin.com/v1/";
    public static final String BASE_PEOPLE_URL = "https://api.linkedin.com/v1/people/";
    public static final String GROUP_BASE_URL = "https://api.linkedin.com/v1/groups/";
    public static final String GROUP_POSTS_BASE_URL = "https://api.linkedin.com/v1/posts/";
    public static final String GROUP_DETAILS_URL = "https://api.linkedin.com/v1/groups/{group-id}:(id,name,short-description,description,relation-to-viewer:(membership-state,available-actions),posts,counts-by-category,is-open-to-non-members,category,website-url,locale,location:(country,postal-code),allow-member-invites,site-group-url,small-logo-url,large-logo-url)";
    public static final String GROUP_JOIN_LEAVE_URL = "https://api.linkedin.com/v1/people/~/group-memberships/{group-id}";
    public static final String GROUP_MEMBERSHIPS_URL = "https://api.linkedin.com/v1/people/~/group-memberships:(group:(id,name),membership-state,show-group-logo-in-profile,allow-messages-from-members,email-digest-frequency,email-announcements-from-managers,email-for-every-new-post)";
    public static final String GROUP_SUGGESTIONS_URL = "https://api.linkedin.com/v1/people/~/suggestions/groups:(id,name,is-open-to-non-members)";
    public static final String GROUP_SUGGESTION_DELETE_URL = "https://api.linkedin.com/v1/people/~/suggestions/groups/{id}";
    public static final String GROUP_POSTS_URL = "https://api.linkedin.com/v1/groups/{group-id}/posts:(id,creation-timestamp,title,summary,creator:(first-name,last-name,picture-url,headline),likes,attachment:(image-url,content-domain,content-url,title,summary),relation-to-viewer)?order=recency";
    public static final String GROUP_POST_COMMENTS_URL = "https://api.linkedin.com/v1/posts/{post-id}/comments:(creator:(first-name,last-name,picture-url),creation-timestamp,id,text)";
    public static final String GROUP_CREATE_POST_URL = "https://api.linkedin.com/v1/groups/{group-id}/posts";
    public static final String GROUP_POST_LIKE_URL = "https://api.linkedin.com/v1/posts/{post-id}/relation-to-viewer/is-liked";
    public static final String GROUP_POST_FOLLOW_URL = "https://api.linkedin.com/v1/posts/{post-id}/relation-to-viewer/is-following";
    public static final String GROUP_POST_FLAG_URL = "https://api.linkedin.com/v1/posts/{post-id}/category/code";
    public static final String GROUP_POST_DELETE_URL = "https://api.linkedin.com/v1/posts/{post-id}";
    public static final String GROUP_POST_ADD_COMMENT_URL = "https://api.linkedin.com/v1/posts/{post-id}/comments";
    public static final String GROUP_POST_DELETE_COMMENT_URL = "https://api.linkedin.com/v1/comments/{comment-id}";

    public GroupTemplate(RestOperations restOperations) {
        this.restOperations = restOperations;
    }

    public Group getGroupDetails(Integer id) {
        return (Group)this.restOperations.getForObject(GROUP_DETAILS_URL, Group.class, new Object[]{id});
    }

    public GroupMemberships getGroupMemberships() {
        return (GroupMemberships)this.restOperations.getForObject(GROUP_MEMBERSHIPS_URL, GroupMemberships.class, new Object[0]);
    }

    public GroupMemberships getGroupMemberships(int start, int count) {
        return (GroupMemberships)this.restOperations.getForObject("https://api.linkedin.com/v1/people/~/group-memberships:(group:(id,name),membership-state,show-group-logo-in-profile,allow-messages-from-members,email-digest-frequency,email-announcements-from-managers,email-for-every-new-post)?start=" + start + "&count=" + count, GroupMemberships.class, new Object[0]);
    }

    public GroupSuggestions getGroupSuggestions() {
        return (GroupSuggestions)this.restOperations.getForObject(GROUP_SUGGESTIONS_URL, GroupSuggestions.class, new Object[0]);
    }

    public GroupSuggestions getGroupSuggestions(int start, int count) {
        return (GroupSuggestions)this.restOperations.getForObject("https://api.linkedin.com/v1/people/~/suggestions/groups:(id,name,is-open-to-non-members)?start=" + start + "&count=" + count, GroupSuggestions.class, new Object[0]);
    }

    public Group.GroupPosts getPosts(Integer groupId) {
        return (Group.GroupPosts)this.restOperations.getForObject(GROUP_POSTS_URL, Group.GroupPosts.class, new Object[]{groupId});
    }

    public Group.GroupPosts getPosts(Integer groupId, int start, int count) {
        return (Group.GroupPosts)this.restOperations.getForObject("https://api.linkedin.com/v1/groups/{group-id}/posts:(id,creation-timestamp,title,summary,creator:(first-name,last-name,picture-url,headline),likes,attachment:(image-url,content-domain,content-url,title,summary),relation-to-viewer)?order=recency&start=" + start + "&count=" + count, Group.GroupPosts.class, new Object[]{groupId});
    }

    public PostComments getPostComments(String postId) {
        return (PostComments)this.restOperations.getForObject(GROUP_POST_COMMENTS_URL, PostComments.class, new Object[]{postId});
    }

    public PostComments getPostComments(String postId, int start, int count) {
        return (PostComments)this.restOperations.getForObject("https://api.linkedin.com/v1/posts/{post-id}/comments:(creator:(first-name,last-name,picture-url),creation-timestamp,id,text)?start=" + start + "&count=" + count, PostComments.class, new Object[]{postId});
    }

    public void joinGroup(Integer groupId) {
        this.restOperations.put(GROUP_JOIN_LEAVE_URL, Collections.singletonMap("membership-state", Collections.singletonMap("code", "member")), new Object[]{groupId});
    }

    public void leaveGroup(Integer groupId) {
        this.restOperations.delete(GROUP_JOIN_LEAVE_URL, new Object[]{groupId});
    }

    public URI createPost(Integer groupId, String title, String summary) {
        HashMap<String, String> post = new HashMap<String, String>();
        post.put("title", title);
        post.put("summary", summary);
        return this.restOperations.postForLocation(GROUP_CREATE_POST_URL, post, new Object[]{groupId});
    }

    public void likePost(String postId) {
        this.restOperations.put(GROUP_POST_LIKE_URL, (Object)"true", new Object[]{postId});
    }

    public void unlikePost(String postId) {
        this.restOperations.put(GROUP_POST_LIKE_URL, (Object)"false", new Object[]{postId});
    }

    public void followPost(String postId) {
        this.restOperations.put(GROUP_POST_FOLLOW_URL, (Object)"true", new Object[]{postId});
    }

    public void unfollowPost(String postId) {
        this.restOperations.put(GROUP_POST_FOLLOW_URL, (Object)"false", new Object[]{postId});
    }

    public void flagPostAsJob(String postId) {
        this.restOperations.put(GROUP_POST_FLAG_URL, (Object)"\"job\"", new Object[]{postId});
    }

    public void flagPostAsPromotion(String postId) {
        this.restOperations.put(GROUP_POST_FLAG_URL, (Object)"\"promotion\"", new Object[]{postId});
    }

    public void deleteOrFlagPostAsInappropriate(String postId) {
        this.restOperations.delete(GROUP_POST_DELETE_URL, new Object[]{postId});
    }

    public void addCommentToPost(String postId, String text) {
        this.restOperations.postForObject(GROUP_POST_ADD_COMMENT_URL, Collections.singletonMap("text", text), String.class, new Object[]{postId});
    }

    public void deleteOrFlagCommentAsInappropriate(String commentId) {
        this.restOperations.delete(GROUP_POST_DELETE_COMMENT_URL, new Object[]{commentId});
    }

    public void deleteGroupSuggestion(Integer groupId) {
        this.restOperations.delete(GROUP_SUGGESTION_DELETE_URL, new Object[]{groupId});
    }
}

