/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.List;
import org.springframework.social.linkedin.api.Companies;
import org.springframework.social.linkedin.api.Company;
import org.springframework.social.linkedin.api.CompanyOperations;
import org.springframework.social.linkedin.api.Products;
import org.springframework.social.linkedin.api.impl.AbstractTemplate;
import org.springframework.web.client.RestOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompanyTemplate
extends AbstractTemplate
implements CompanyOperations {
    private final RestOperations restOperations;
    private final ObjectMapper objectMapper;
    public static final String BASE_URL = "https://api.linkedin.com/v1/";
    public static final String COMPANY_FIELDS = "(id,name,universal-name,email-domains,company-type,ticker,website-url,industry,status,logo-url,square-logo-url,blog-rss-url,twitter-id,employee-count-range,specialties,locations,description,stock-exchange,founded-year,end-year,num-followers)";
    public static final String COMPANY_URL = "https://api.linkedin.com/v1/companies{id}:(id,name,universal-name,email-domains,company-type,ticker,website-url,industry,status,logo-url,square-logo-url,blog-rss-url,twitter-id,employee-count-range,specialties,locations,description,stock-exchange,founded-year,end-year,num-followers)?{filter}";
    public static final String COMPANY_SEARCH_URL = "https://api.linkedin.com/v1/company-search:(companies:(id,name,universal-name,email-domains,company-type,ticker,website-url,industry,status,logo-url,square-logo-url,blog-rss-url,twitter-id,employee-count-range,specialties,locations,description,stock-exchange,founded-year,end-year,num-followers))?keywords={keywords}";
    public static final String COMPANY_FOLLOW_URL = "https://api.linkedin.com/v1/people/~/following/companies:(id,name,universal-name,email-domains,company-type,ticker,website-url,industry,status,logo-url,square-logo-url,blog-rss-url,twitter-id,employee-count-range,specialties,locations,description,stock-exchange,founded-year,end-year,num-followers)";
    public static final String COMPANY_FOLLOW_START_STOP_URL = "https://api.linkedin.com/v1/people/~/following/companies/id={id}";
    public static final String COMPANY_SUGGESTIONS_TO_FOLLOW = "https://api.linkedin.com/v1/people/~/suggestions/to-follow/companies:(id,name,universal-name,email-domains,company-type,ticker,website-url,industry,status,logo-url,square-logo-url,blog-rss-url,twitter-id,employee-count-range,specialties,locations,description,stock-exchange,founded-year,end-year,num-followers)";
    public static final String PRODUCT_FIELDS = "(id,name,type,creation-timestamp,logo-url,description,features,video:(title,url),product-deal:(title,url,text),sales-persons,num-recommendations,recommendations:(recommender,id,product-id,text,reply,timestamp,likes:(timestamp,person)),product-category,website-url,disclaimer)";
    public static final String PRODUCTS_URL = "https://api.linkedin.com/v1/companies/{id}/products:(id,name,type,creation-timestamp,logo-url,description,features,video:(title,url),product-deal:(title,url,text),sales-persons,num-recommendations,recommendations:(recommender,id,product-id,text,reply,timestamp,likes:(timestamp,person)),product-category,website-url,disclaimer)?start={start}&count={count}";

    public CompanyTemplate(RestOperations RestOperations2, ObjectMapper objectMapper) {
        this.restOperations = RestOperations2;
        this.objectMapper = objectMapper;
    }

    @Override
    public Company getCompany(int id) {
        return (Company)this.restOperations.getForObject(COMPANY_URL, Company.class, new Object[]{"/" + id, ""});
    }

    @Override
    public Company getCompanyByUniversalName(String name) {
        return (Company)this.restOperations.getForObject(COMPANY_URL, Company.class, new Object[]{"/universal-name=" + name, ""});
    }

    @Override
    public List<Company> getCompaniesByEmailDomain(String domain) {
        Object[] params = new String[]{"", "email-domain=" + domain};
        JsonNode node = (JsonNode)this.restOperations.getForObject(this.expand(COMPANY_URL, params, false), JsonNode.class);
        try {
            return (List)this.objectMapper.reader((TypeReference)new TypeReference<List<Company>>(){}).readValue(node.path("values"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Companies search(String keywords) {
        JsonNode node = (JsonNode)this.restOperations.getForObject(COMPANY_SEARCH_URL, JsonNode.class, new Object[]{keywords});
        try {
            return (Companies)this.objectMapper.reader((TypeReference)new TypeReference<Companies>(){}).readValue(node.path("companies"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Company> getFollowing() {
        JsonNode node = (JsonNode)this.restOperations.getForObject(COMPANY_FOLLOW_URL, JsonNode.class, new Object[0]);
        try {
            return (List)this.objectMapper.reader((TypeReference)new TypeReference<List<Company>>(){}).readValue(node.path("values"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Company> getSuggestionsToFollow() {
        JsonNode node = (JsonNode)this.restOperations.getForObject(COMPANY_SUGGESTIONS_TO_FOLLOW, JsonNode.class, new Object[0]);
        try {
            return (List)this.objectMapper.reader((TypeReference)new TypeReference<List<Company>>(){}).readValue(node.path("values"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void startFollowingCompany(int id) {
        this.restOperations.postForLocation(COMPANY_FOLLOW_START_STOP_URL, Collections.singletonMap("id", id), new Object[0]);
    }

    @Override
    public void stopFollowingCompany(int id) {
        this.restOperations.delete(COMPANY_FOLLOW_START_STOP_URL, new Object[]{id});
    }

    @Override
    public Products getProducts(int companyId, int start, int count) {
        return (Products)this.restOperations.getForObject(PRODUCTS_URL, Products.class, new Object[]{companyId, start, count});
    }
}

