/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util.logging;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.exception.RelativeFileAccessException;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.core.util.file.ReversedFileLineReader;
import org.silverpeas.kernel.SilverpeasException;
import org.silverpeas.kernel.util.SystemWrapper;

@Service
public class LogsAccessor {
    private static final String SILVERPEAS_LOG_DIR = "SILVERPEAS_LOG";

    LogsAccessor() {
    }

    public static LogsAccessor get() {
        return (LogsAccessor)ServiceProvider.getService(LogsAccessor.class, (Annotation[])new Annotation[0]);
    }

    public Set<String> getAllLogs() throws IOException {
        String logPath = SystemWrapper.getInstance().getProperty(SILVERPEAS_LOG_DIR);
        try (Stream<Path> paths = Files.list(Paths.get(logPath, new String[0]));){
            Set<String> set = paths.filter(path -> "log".equalsIgnoreCase(FilenameUtils.getExtension((String)path.toString()))).map(path -> path.getFileName().toString()).collect(Collectors.toSet());
            return set;
        }
    }

    public List<String> getLastLogRecords(String log, int recordCount) throws SilverpeasException {
        try {
            FileUtil.assertPathNotRelative(log);
            String logPath = SystemWrapper.getInstance().getProperty(SILVERPEAS_LOG_DIR);
            Path logFile = Paths.get(logPath, log);
            return ReversedFileLineReader.readLastLines(logFile, recordCount);
        }
        catch (IOException | RelativeFileAccessException e) {
            throw new SilverpeasException((Throwable)e);
        }
    }
}

