/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util.comparator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.silverpeas.core.util.comparator.AbstractComparator;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractComplexComparator<C>
extends AbstractComparator<C> {
    private static final long serialVersionUID = 735351151555082611L;

    protected AbstractComplexComparator() {
    }

    protected abstract ValueBuffer getValuesToCompare(C var1);

    @Override
    public int compare(C o1, C o2) {
        ValueBuffer baseValues = this.getValuesToCompare(o1);
        ValueBuffer comparedValues = this.getValuesToCompare(o2);
        int result = 0;
        Iterator<Object> it1 = baseValues.getValues().iterator();
        Iterator<Object> it2 = comparedValues.getValues().iterator();
        Iterator<Integer> itSens = baseValues.getSens().iterator();
        while (it1.hasNext()) {
            Object curO1 = it1.next();
            Object curO2 = it2.next();
            Integer sens = itSens.next();
            result = this.compareInstance(curO1, curO2);
            if (result != 0) {
                return result * sens;
            }
            if (!this.areInstancesComparable(curO1, curO2) || (result = this.compare((C)((Comparable)curO1), (C)curO2)) == 0) continue;
            return result * sens;
        }
        return result;
    }

    public class StringWrapper
    implements Comparable<StringWrapper> {
        final String string;
        final boolean sort;
        final boolean emptyAtEnd;

        public StringWrapper(String string, boolean sort, boolean emptyAtEnd) {
            this.string = StringUtil.isNotDefined((String)string) ? null : string;
            this.sort = sort;
            this.emptyAtEnd = emptyAtEnd;
        }

        @Override
        public int compareTo(StringWrapper o) {
            int result = AbstractComplexComparator.this.compareInstance(this.string, o.string);
            if (result != 0) {
                if (this.emptyAtEnd) {
                    return result * (this.sort ? -1 : 1);
                }
                return result * (this.sort ? 1 : -1);
            }
            if (AbstractComplexComparator.this.areInstancesComparable(this.string, o.string)) {
                return AbstractComplexComparator.this.compare(this.string, o.string);
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StringWrapper that = (StringWrapper)o;
            return Objects.equals(this.string, that.string);
        }

        public int hashCode() {
            return Objects.hash(this.string);
        }
    }

    public class ValueBuffer {
        private final List<Integer> sens = new ArrayList<Integer>();
        private final List<Object> values = new ArrayList<Object>();

        public ValueBuffer append(Object object, boolean isAscending) {
            this.values.add(object);
            if (isAscending) {
                this.sens.add(1);
            } else {
                this.sens.add(-1);
            }
            return this;
        }

        public ValueBuffer append(Object object) {
            return this.append(object, true);
        }

        List<Integer> getSens() {
            return this.sens;
        }

        public List<Object> getValues() {
            return this.values;
        }
    }
}

