/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.silverpeas.core.admin.component.model.ComponentInstPath;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.util.ResourcePath;
import org.silverpeas.kernel.util.Pair;

public abstract class ContributionPath<T extends Contribution>
extends ArrayList<T>
implements ResourcePath<T>,
Serializable {
    private static final long serialVersionUID = 9091158323736803705L;
    protected final transient Map<String, Pair<String, String>> lastPathByLanguage = new HashMap<String, Pair<String, String>>();

    protected ContributionPath() {
    }

    protected ContributionPath(int initialCapacity) {
        super(initialCapacity);
    }

    protected ContributionPath(@Nonnull Collection<? extends T> c) {
        super(c);
    }

    protected abstract boolean isRoot(T var1);

    protected boolean rootIsComponentInstance() {
        return false;
    }

    protected abstract String getLabel(T var1, String var2);

    public String format(String language, boolean fullSpacePath, String pathSep) {
        Pair lastPath;
        String currentResourceIdPath = this.stream().map(c -> c.getIdentifier().getLocalId()).collect(Collectors.joining(","));
        if (!currentResourceIdPath.equals((lastPath = this.lastPathByLanguage.computeIfAbsent(language, l -> Pair.of((Object)"", (Object)""))).getFirst())) {
            StringBuilder result = new StringBuilder();
            for (Contribution resource : this) {
                if (result.length() > 0) {
                    result.insert(0, pathSep);
                }
                if (this.isRoot(resource)) {
                    if (!this.rootIsComponentInstance()) {
                        result.insert(0, pathSep + this.getLabel(resource, language));
                    }
                    result.insert(0, this.getPath(resource, language, fullSpacePath, pathSep));
                    continue;
                }
                result.insert(0, this.getLabel(resource, language));
            }
            lastPath = Pair.of((Object)currentResourceIdPath, (Object)result.toString());
            this.lastPathByLanguage.put(language, (Pair<String, String>)lastPath);
        }
        return (String)lastPath.getSecond();
    }

    private String getPath(T resource, String language, boolean fullSpacePath, String pathSep) {
        String instanceId = resource.getIdentifier().getComponentInstanceId();
        ComponentInstPath path = ComponentInstPath.getPath(instanceId);
        return path.format(language, fullSpacePath, pathSep);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

