/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.subscription.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.subscription.SubscriptionSubscriber;
import org.silverpeas.core.subscription.util.SubscriptionSubscriberMapBySubscriberType;
import org.silverpeas.core.subscription.util.SubscriptionUtil;

public class SubscriptionSubscriberList
extends ArrayList<SubscriptionSubscriber> {
    private static final long serialVersionUID = -4159319020430997899L;

    public SubscriptionSubscriberList() {
    }

    public SubscriptionSubscriberList(Collection<? extends SubscriptionSubscriber> c) {
        super(c);
    }

    public List<String> getAllIds() {
        HashSet<String> allIds = new HashSet<String>();
        for (SubscriptionSubscriber subscriber : this) {
            allIds.add(subscriber.getId());
        }
        return new ArrayList<String>(allIds);
    }

    public List<String> getAllUserIds() {
        HashSet<String> allUserSubscriberIds = new HashSet<String>();
        HashSet<String> groupIds = new HashSet<String>();
        for (SubscriptionSubscriber subscriber : this) {
            switch (subscriber.getType()) {
                case USER: {
                    allUserSubscriberIds.add(subscriber.getId());
                    break;
                }
                case GROUP: {
                    groupIds.add(subscriber.getId());
                }
            }
        }
        if (!groupIds.isEmpty()) {
            OrganizationController organisationController = OrganizationControllerProvider.getOrganisationController();
            for (String groupId : groupIds) {
                for (User user : organisationController.getAllUsersOfGroup(groupId)) {
                    allUserSubscriberIds.add(user.getId());
                }
            }
        }
        return new ArrayList<String>(allUserSubscriberIds);
    }

    public SubscriptionSubscriberMapBySubscriberType indexBySubscriberType() {
        return new SubscriptionSubscriberMapBySubscriberType(this);
    }

    public SubscriptionSubscriberList filterOnDomainVisibilityFrom(UserDetail user) {
        if (user.isDomainRestricted()) {
            Iterator itOfSubscribers = this.iterator();
            while (itOfSubscribers.hasNext()) {
                SubscriptionSubscriber subscriber = (SubscriptionSubscriber)itOfSubscribers.next();
                if (SubscriptionUtil.isSameVisibilityAsTheCurrentRequester(subscriber, user)) continue;
                itOfSubscribers.remove();
            }
        }
        return this;
    }
}

