/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.encryption.cipher;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.silverpeas.core.security.encryption.cipher.CryptoException;

public class PKS12KeyStore {
    private final X509Certificate cert;
    private final PrivateKey privatekey;
    private final PublicKey publickey;
    private static final String LOAD_FAILURE = "The load of the public and secret keys, and of the X509 certificate failed!";

    public PKS12KeyStore(String p12FilePath, String password) throws KeyStoreException, CryptoException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyStore ks = KeyStore.getInstance("PKCS12");
        if (p12FilePath != null) {
            try (FileInputStream input = new FileInputStream(p12FilePath);){
                ks.load(input, password.toCharArray());
            }
            catch (Exception ex) {
                throw new CryptoException(LOAD_FAILURE, ex);
            }
        }
        try {
            String[] allAliases;
            Enumeration<String> en = ks.aliases();
            String alias = "";
            ArrayList<String> listOfAliases = new ArrayList<String>();
            while (en.hasMoreElements()) {
                listOfAliases.add(en.nextElement());
            }
            for (String anAliases : allAliases = listOfAliases.toArray(new String[0])) {
                if (!ks.isKeyEntry(anAliases)) continue;
                alias = anAliases;
                break;
            }
            this.privatekey = (PrivateKey)ks.getKey(alias, password.toCharArray());
            this.cert = (X509Certificate)ks.getCertificate(alias);
            this.publickey = ks.getCertificate(alias).getPublicKey();
        }
        catch (NoSuchAlgorithmException | UnrecoverableEntryException ex) {
            throw new CryptoException(LOAD_FAILURE, ex);
        }
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    public PrivateKey getPrivatekey() {
        return this.privatekey;
    }

    public PublicKey getPublickey() {
        return this.publickey;
    }
}

