/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.server.channel.silvermail;

import java.lang.annotation.Annotation;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.backgroundprocess.AbstractBackgroundProcessRequest;
import org.silverpeas.core.backgroundprocess.BackgroundProcessTask;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.notification.sse.AbstractServerEvent;
import org.silverpeas.core.notification.sse.DefaultServerEventNotifier;
import org.silverpeas.core.notification.user.UserNotificationServerEvent;
import org.silverpeas.core.notification.user.server.channel.silvermail.SILVERMAILException;
import org.silverpeas.core.notification.user.server.channel.silvermail.SILVERMAILMessage;
import org.silverpeas.core.notification.user.server.channel.silvermail.SILVERMAILMessageBean;
import org.silverpeas.core.notification.user.server.channel.silvermail.SILVERMAILMessageBeanRepository;
import org.silverpeas.core.notification.user.server.channel.silvermail.SilvermailCriteria;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.persistence.jdbc.LongText;
import org.silverpeas.core.security.authorization.ForbiddenRuntimeException;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.cache.model.SimpleCache;
import org.silverpeas.kernel.exception.NotFoundException;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Mutable;

public class SILVERMAILPersistence {
    private static final String CACHE_KEY = String.valueOf(SILVERMAILPersistence.class) + "@userId@";

    private SILVERMAILPersistence() {
    }

    private static void markMessageAsRead(SILVERMAILMessageBean smb) {
        boolean hasToUpdate;
        boolean bl = hasToUpdate = smb.getReaden() != 1;
        if (hasToUpdate) {
            smb.setReaden(1);
            Transaction.performInOne(() -> (SILVERMAILMessageBean)SILVERMAILPersistence.getRepository().save((IdentifiableEntity)smb));
            DefaultServerEventNotifier.get().notify((AbstractServerEvent)UserNotificationServerEvent.readOf(String.valueOf(smb.getUserId()), smb.getId(), smb.getSubject(), smb.getSenderName()));
        }
    }

    private static SILVERMAILMessageBeanRepository getRepository() {
        return (SILVERMAILMessageBeanRepository)((Object)ServiceProvider.getService(SILVERMAILMessageBeanRepository.class, (Annotation[])new Annotation[0]));
    }

    private static SilverpeasList<SILVERMAILMessage> findByCriteria(SilvermailCriteria criteria) {
        SilverpeasList<SILVERMAILMessageBean> messageBeans = SILVERMAILPersistence.getRepository().findByCriteria(criteria);
        List longTextIds = messageBeans.stream().map(n -> Integer.parseInt(n.getBody())).collect(Collectors.toList());
        Mutable offset = Mutable.of((Object)0);
        CollectionUtil.splitList(longTextIds).forEach(batchIds -> {
            Map contents = LongText.listLongTexts((Collection)batchIds);
            int n = (Integer)offset.get();
            for (int c = 0; c < batchIds.size(); ++c) {
                SILVERMAILMessageBean notif = (SILVERMAILMessageBean)((Object)((Object)messageBeans.get(n)));
                notif.setBody((String)contents.get(batchIds.get(c)));
                ++n;
            }
            offset.set((Object)((Integer)offset.get() + batchIds.size()));
        });
        return (SilverpeasList)messageBeans.stream().map(SILVERMAILPersistence::convertFrom).collect(SilverpeasList.collector(messageBeans));
    }

    private static String getUserLogin(long userId) {
        String cacheKey;
        SimpleCache cache = CacheAccessorProvider.getThreadCacheAccessor().getCache();
        String login = (String)cache.get((Object)(cacheKey = CACHE_KEY + userId), String.class);
        if (login == null) {
            User user = User.getById((String)Long.toString(userId));
            login = user != null ? user.getLogin() : "";
            cache.put((Object)cacheKey, (Object)login);
        }
        return login;
    }

    static void addMessage(SILVERMAILMessage silverMsg) throws SILVERMAILException {
        SILVERMAILMessageBean smb = new SILVERMAILMessageBean();
        if (silverMsg != null) {
            try {
                smb.setUserId(silverMsg.getUserId());
                smb.setSenderName(silverMsg.getSenderName());
                smb.setFolderId(0L);
                smb.setSubject(silverMsg.getSubject());
                smb.setBody(Integer.toString(LongText.addLongText((String)silverMsg.getBody())));
                smb.setUrl(silverMsg.getUrl());
                smb.setSource(silverMsg.getSource());
                smb.setDateMsg(DateUtil.date2SQLDate((Date)silverMsg.getDate()));
                smb.setReaden(0);
                Transaction.performInOne(() -> (SILVERMAILMessageBean)SILVERMAILPersistence.getRepository().save((IdentifiableEntity)smb));
                DefaultServerEventNotifier.get().notify((AbstractServerEvent)UserNotificationServerEvent.creationOf(String.valueOf(smb.getUserId()), smb.getId(), smb.getSubject(), smb.getSenderName()));
            }
            catch (Exception e) {
                throw new SILVERMAILException(e);
            }
        }
    }

    public static long countNotReadMessagesOfFolder(String userId, String folderName) {
        return SILVERMAILPersistence.getRepository().countByCriteria(SilvermailCriteria.get().aboutUser(userId).into(folderName).unread());
    }

    public static SilverpeasList<SILVERMAILMessage> getMessageOfFolder(String userId, String folderName, PaginationPage pagination, SilvermailCriteria.QUERY_ORDER_BY orderBy) {
        SilvermailCriteria criteria = SilvermailCriteria.get().aboutUser(userId).into(folderName).paginatedBy(pagination);
        if (orderBy != null) {
            criteria.orderedBy(orderBy);
        }
        return SILVERMAILPersistence.findByCriteria(criteria);
    }

    public static SILVERMAILMessage getMessage(String userId, long msgId) {
        SILVERMAILMessage message = (SILVERMAILMessage)SILVERMAILPersistence.findByCriteria(SilvermailCriteria.get().byId(msgId)).stream().findFirst().orElseThrow(() -> new NotFoundException(String.format("Message %s not found for user %s", msgId, userId)));
        if (message.getUserId() != Long.parseLong(userId)) {
            throw new ForbiddenRuntimeException(String.format("Forbidden access to message %s for user %s", msgId, userId));
        }
        return message;
    }

    public static SILVERMAILMessage getMessageAndMarkAsRead(String userId, long msgId) {
        SILVERMAILMessage silverMailMessage = SILVERMAILPersistence.getMessage(userId, msgId);
        SILVERMAILMessageBean smb = (SILVERMAILMessageBean)SILVERMAILPersistence.getRepository().getById(String.valueOf(msgId));
        SILVERMAILPersistence.markMessageAsRead(smb);
        return silverMailMessage;
    }

    public static void deleteMessage(String userId, long msgId) {
        Transaction.performInOne(() -> {
            SILVERMAILMessageBeanRepository repository = SILVERMAILPersistence.getRepository();
            SILVERMAILMessageBean toDel = (SILVERMAILMessageBean)repository.getById(String.valueOf(msgId));
            if (toDel == null) {
                throw new NotFoundException(String.format("Error when deleting message %s (not found) for user %s", msgId, userId));
            }
            if (Long.parseLong(userId) != toDel.getUserId()) {
                throw new ForbiddenRuntimeException("Unauthorized deletion of message " + msgId + " for user " + userId);
            }
            BackgroundProcessTask.push((AbstractBackgroundProcessRequest)new LongTextDeletionRequest(toDel.getBody()));
            repository.delete((IdentifiableEntity[])new SILVERMAILMessageBean[]{toDel});
            return null;
        });
        DefaultServerEventNotifier.get().notify((AbstractServerEvent)UserNotificationServerEvent.deletionOf(userId, String.valueOf(msgId)));
    }

    public static void deleteAllMessagesInFolder(String currentUserId) {
        String folderId = "0";
        long nbDeleted = (Long)Transaction.performInOne(() -> {
            List<String> longTextIds = SILVERMAILPersistence.getRepository().getLongTextIdsOfAllMessagesByUserIdAndFolderId(currentUserId, folderId);
            BackgroundProcessTask.push((AbstractBackgroundProcessRequest)new LongTextDeletionRequest(longTextIds));
            return SILVERMAILPersistence.getRepository().deleteAllMessagesByUserIdAndFolderId(currentUserId, folderId);
        });
        if (nbDeleted > 0L) {
            DefaultServerEventNotifier.get().notify((AbstractServerEvent)UserNotificationServerEvent.clean(currentUserId));
        }
    }

    public static void markAllMessagesAsRead(String currentUserId) {
        long nbUpdated = (Long)Transaction.performInOne(() -> SILVERMAILPersistence.getRepository().markAsReadAllMessagesByUserIdAndFolderId(currentUserId, "0"));
        if (nbUpdated > 0L) {
            DefaultServerEventNotifier.get().notify((AbstractServerEvent)UserNotificationServerEvent.clean(currentUserId));
        }
    }

    public static void deleteMessages(String currentUserId, Collection<String> ids) {
        long nbDeleted = (Long)Transaction.performInOne(() -> {
            List<String> longTextIds = SILVERMAILPersistence.getRepository().getLongTextIdsOfMessagesByUserIdAndByIds(currentUserId, ids);
            BackgroundProcessTask.push((AbstractBackgroundProcessRequest)new LongTextDeletionRequest(longTextIds));
            return SILVERMAILPersistence.getRepository().deleteMessagesByUserIdAndByIds(currentUserId, ids);
        });
        if (nbDeleted > 0L) {
            DefaultServerEventNotifier.get().notify((AbstractServerEvent)UserNotificationServerEvent.clean(currentUserId));
        }
    }

    public static void markMessagesAsRead(String currentUserId, Collection<String> ids) {
        long nbUpdated = (Long)Transaction.performInOne(() -> SILVERMAILPersistence.getRepository().markAsReadMessagesByUserIdAndByIds(currentUserId, ids));
        if (nbUpdated > 0L) {
            DefaultServerEventNotifier.get().notify((AbstractServerEvent)UserNotificationServerEvent.clean(currentUserId));
        }
    }

    private static SILVERMAILMessage convertFrom(SILVERMAILMessageBean smb) {
        Date msgDate;
        try {
            msgDate = DateUtil.parseDate((String)smb.getDateMsg());
        }
        catch (ParseException e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
        SILVERMAILMessage silverMailMessage = new SILVERMAILMessage();
        silverMailMessage.setId(Long.parseLong(smb.getId()));
        silverMailMessage.setUserId(smb.getUserId());
        silverMailMessage.setUserLogin(SILVERMAILPersistence.getUserLogin(smb.getUserId()));
        silverMailMessage.setSenderName(smb.getSenderName());
        silverMailMessage.setSubject(smb.getSubject());
        silverMailMessage.setUrl(smb.getUrl());
        silverMailMessage.setSource(smb.getSource());
        silverMailMessage.setBody(smb.getBody());
        silverMailMessage.setDate(msgDate);
        silverMailMessage.setReaden(smb.getReaden());
        return silverMailMessage;
    }

    private static class LongTextDeletionRequest
    extends AbstractBackgroundProcessRequest {
        private final List<String> longTextIds;

        private LongTextDeletionRequest(String longTextId) {
            this.longTextIds = Collections.singletonList(longTextId);
        }

        private LongTextDeletionRequest(List<String> longTextIds) {
            this.longTextIds = longTextIds;
        }

        protected void process() {
            Transaction.performInOne(() -> {
                this.longTextIds.forEach(id -> {
                    try {
                        LongText.removeLongText((int)Integer.parseInt(id));
                    }
                    catch (NumberFormatException e) {
                        SilverLogger.getLogger(SILVERMAILPersistence.class).silent((Throwable)e);
                    }
                    catch (Exception e) {
                        SilverLogger.getLogger(SILVERMAILPersistence.class).error((Throwable)e);
                    }
                });
                return null;
            });
        }
    }
}

