/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.server.channel;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.silverpeas.core.notification.user.server.NotificationData;
import org.silverpeas.core.notification.user.server.NotificationServerException;
import org.silverpeas.core.notification.user.server.NotificationServerUtil;
import org.silverpeas.core.notification.user.server.channel.INotificationServerChannel;

public abstract class AbstractListener
implements INotificationServerChannel {
    protected String channel;
    protected String payLoad;

    protected void processMessage(Message msg) throws NotificationServerException {
        this.extractData(msg);
        NotificationData nd = NotificationServerUtil.convertXMLToNotificationData(this.payLoad);
        nd.traceObject();
        this.send(nd);
    }

    private void extractData(Message msg) throws NotificationServerException {
        TextMessage tm = (TextMessage)msg;
        try {
            this.channel = tm.getStringProperty("CHANNEL");
        }
        catch (JMSException e) {
            throw new NotificationServerException(e);
        }
        try {
            this.payLoad = tm.getText();
        }
        catch (JMSException e) {
            throw new NotificationServerException(e);
        }
    }
}

