/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user;

import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.notification.sse.CommonServerEvent;
import org.silverpeas.core.notification.sse.ServerEvent;
import org.silverpeas.core.notification.user.server.channel.silvermail.SILVERMAILPersistence;
import org.silverpeas.core.util.JSONCodec;

public class UserNotificationServerEvent
extends CommonServerEvent {
    private static final String ID_ATTR_NAME = "id";
    private static final String SUBJECT_ATTR_NAME = "subject";
    private static final String SENDER_ATTR_NAME = "sender";
    private static final String NB_UNREAD_ATTR_NAME = "nbUnread";
    private static final String IS_CREATION_ATTR_NAME = "isCreation";
    private static final String IS_DELETION_ATTR_NAME = "isDeletion";
    private static final String IS_READ_ATTR_NAME = "isRead";
    private static final String IS_CLEAR_ATTR_NAME = "isClear";
    private static final ServerEvent.ServerEventName EVENT_NAME = () -> "USER_NOTIFICATION";
    private final String emitterUserId;

    private UserNotificationServerEvent(String emitterUserId) {
        this.emitterUserId = emitterUserId;
    }

    public static UserNotificationServerEvent creationOf(String emitterUserId, String notificationId, String subject, String sender) {
        return (UserNotificationServerEvent)new UserNotificationServerEvent(emitterUserId).withData(JSONCodec.encodeObject(jsonObject -> jsonObject.put(ID_ATTR_NAME, notificationId).put(SUBJECT_ATTR_NAME, subject).put(SENDER_ATTR_NAME, sender).put(NB_UNREAD_ATTR_NAME, Integer.valueOf(UserNotificationServerEvent.getNbUnreadFor(emitterUserId))).put(IS_CREATION_ATTR_NAME, Boolean.valueOf(true)).put(IS_DELETION_ATTR_NAME, Boolean.valueOf(false)).put(IS_READ_ATTR_NAME, Boolean.valueOf(false)).put(IS_CLEAR_ATTR_NAME, Boolean.valueOf(false))));
    }

    public static UserNotificationServerEvent readOf(String emitterUserId, String notificationId, String subject, String sender) {
        return (UserNotificationServerEvent)new UserNotificationServerEvent(emitterUserId).withData(JSONCodec.encodeObject(jsonObject -> jsonObject.put(ID_ATTR_NAME, notificationId).put(SUBJECT_ATTR_NAME, subject).put(SENDER_ATTR_NAME, sender).put(NB_UNREAD_ATTR_NAME, Integer.valueOf(UserNotificationServerEvent.getNbUnreadFor(emitterUserId))).put(IS_CREATION_ATTR_NAME, Boolean.valueOf(false)).put(IS_DELETION_ATTR_NAME, Boolean.valueOf(false)).put(IS_READ_ATTR_NAME, Boolean.valueOf(true)).put(IS_CLEAR_ATTR_NAME, Boolean.valueOf(false))));
    }

    public static UserNotificationServerEvent deletionOf(String emitterUserId, String notificationId) {
        return (UserNotificationServerEvent)new UserNotificationServerEvent(emitterUserId).withData(JSONCodec.encodeObject(jsonObject -> jsonObject.put(ID_ATTR_NAME, notificationId).put(NB_UNREAD_ATTR_NAME, Integer.valueOf(UserNotificationServerEvent.getNbUnreadFor(emitterUserId))).put(IS_CREATION_ATTR_NAME, Boolean.valueOf(false)).put(IS_DELETION_ATTR_NAME, Boolean.valueOf(true)).put(IS_READ_ATTR_NAME, Boolean.valueOf(false)).put(IS_CLEAR_ATTR_NAME, Boolean.valueOf(false))));
    }

    public static UserNotificationServerEvent clean(String emitterUserId) {
        return (UserNotificationServerEvent)new UserNotificationServerEvent(emitterUserId).withData(JSONCodec.encodeObject(jsonObject -> jsonObject.put(NB_UNREAD_ATTR_NAME, Integer.valueOf(UserNotificationServerEvent.getNbUnreadFor(emitterUserId))).put(IS_CREATION_ATTR_NAME, Boolean.valueOf(false)).put(IS_DELETION_ATTR_NAME, Boolean.valueOf(false)).put(IS_READ_ATTR_NAME, Boolean.valueOf(false)).put(IS_CLEAR_ATTR_NAME, Boolean.valueOf(true))));
    }

    public static int getNbUnreadFor(String userId) {
        return (int)SILVERMAILPersistence.countNotReadMessagesOfFolder(userId, "INBOX");
    }

    public ServerEvent.ServerEventName getName() {
        return EVENT_NAME;
    }

    public String getEmitterUserId() {
        return this.emitterUserId;
    }

    public boolean isConcerned(String receiverSessionId, User receiver) {
        return receiver.getId().equals(this.emitterUserId);
    }
}

