/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.node.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.Identifiable;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.Folder;
import org.silverpeas.core.contribution.model.I18nContribution;
import org.silverpeas.core.contribution.model.WithPermanentLink;
import org.silverpeas.core.i18n.AbstractI18NBean;
import org.silverpeas.core.node.model.NodeI18NDetail;
import org.silverpeas.core.node.model.NodeIdentifier;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.security.Securable;
import org.silverpeas.core.security.authorization.AccessControlContext;
import org.silverpeas.core.security.authorization.AccessControlOperation;
import org.silverpeas.core.security.authorization.NodeAccessControl;
import org.silverpeas.core.util.URLUtil;

@XmlRootElement(name="xmlField")
@XmlAccessorType(value=XmlAccessType.NONE)
public class NodeDetail
extends AbstractI18NBean<NodeI18NDetail>
implements Identifiable,
I18nContribution,
Folder,
Serializable,
Securable,
WithPermanentLink {
    private static final long serialVersionUID = -1401884517616404337L;
    private static final String UNKNOWN = "unknown";
    public static final String DEFAULT_NODE_TYPE = "default";
    public static final String TYPE = "Node";
    public static final String FILE_LINK_TYPE = "file_link";
    public static final String STATUS_VISIBLE = "Visible";
    public static final String STATUS_INVISIBLE = "Invisible";
    public static final String NO_RIGHTS_DEPENDENCY = "-1";
    private NodePK nodePK;
    private Date creationDate;
    private String creatorId = "";
    private String path = "";
    private String fullPath;
    private int level;
    private String modelId = null;
    private String status = null;
    private NodePK fatherPK;
    @XmlElement(name="topic")
    private Collection<NodeDetail> childrenDetails;
    private String nodeType = "default";
    private int order = 0;
    private String rightsDependsOn = "-1";
    private int nbObjects = -1;
    private String userRole = null;
    private boolean useId = false;
    private Date removalDate;
    private String removerId;

    public NodeDetail(NodeDetail other) {
        super(other);
        this.nodePK = new NodePK(UNKNOWN, other.nodePK);
        this.setPath(other.path);
        this.creatorId = other.creatorId;
        this.creationDate = other.creationDate;
        this.level = other.level;
        this.modelId = other.modelId;
        this.status = other.status;
        this.fatherPK = new NodePK(other.fatherPK.getId(), other.fatherPK.getInstanceId());
        if (other.childrenDetails != null) {
            this.childrenDetails = new ArrayList<NodeDetail>(other.childrenDetails);
        }
        this.nodeType = other.nodeType;
        this.order = other.order;
        this.rightsDependsOn = other.rightsDependsOn;
        this.nbObjects = other.nbObjects;
        this.userRole = other.userRole;
        this.useId = other.useId;
        this.removalDate = other.removalDate;
        this.removerId = other.removerId;
    }

    public NodeDetail() {
        this("0", "", "", 0, "0");
    }

    public NodeDetail(String id, String name, String description, int level, String fatherId) {
        this.nodePK = new NodePK(id);
        this.setName(name);
        this.setDescription(description);
        this.fullPath = this.path + id + "/";
        this.level = level;
        this.fatherPK = new NodePK(fatherId);
        this.childrenDetails = null;
    }

    public NodeDetail(NodePK pk, String name, String description, int level, String fatherId) {
        this.nodePK = pk;
        this.setName(name);
        this.setDescription(description);
        this.fullPath = this.path + pk.getId() + "/";
        this.level = level;
        this.fatherPK = new NodePK(fatherId, pk.getInstanceId());
        this.childrenDetails = null;
    }

    @Override
    protected Class<NodeI18NDetail> getTranslationType() {
        return NodeI18NDetail.class;
    }

    public NodePK getNodePK() {
        return this.nodePK;
    }

    public void setNodePK(NodePK nodePK) {
        this.nodePK = nodePK;
    }

    public String getId() {
        return this.getNodePK().getId();
    }

    @XmlAttribute(name="id")
    public int getLocalId() {
        return Integer.parseInt(this.getId());
    }

    public String getContributionType() {
        return this.getNodeType().equals(DEFAULT_NODE_TYPE) ? TYPE : this.getNodeType();
    }

    public boolean isRoot() {
        return this.getNodePK().isRoot();
    }

    public boolean isBin() {
        return this.getNodePK().isTrash();
    }

    public boolean isUnclassified() {
        return this.getNodePK().isUnclassed();
    }

    public boolean isRemoved() {
        return this.removalDate != null;
    }

    public boolean isChild() {
        return this.getLocalId() > 2;
    }

    public ContributionIdentifier getIdentifier() {
        return new NodeIdentifier(this.getNodePK().getInstanceId(), this.getNodePK().getId(), this.getContributionType());
    }

    public User getCreator() {
        return User.getById((String)this.creatorId);
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public User getLastUpdater() {
        return this.getCreator();
    }

    public Date getLastUpdateDate() {
        return this.getCreationDate();
    }

    public Date getRemovalDate() {
        return this.removalDate;
    }

    public void setRemovalStatus(Date removalDate, String removerId) {
        this.removalDate = removalDate;
        this.removerId = removerId;
    }

    public User getRemover() {
        return User.getById((String)this.removerId);
    }

    public String getRemoverId() {
        return this.removerId;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public String getPath() {
        return this.path;
    }

    public int getLevel() {
        return this.level;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getStatus() {
        return this.status;
    }

    public NodePK getFatherPK() {
        return this.fatherPK;
    }

    public Collection<NodeDetail> getChildrenDetails() {
        return this.childrenDetails;
    }

    public void setCreationDate(Date date) {
        this.creationDate = date;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setChildrenDetails(Collection<NodeDetail> childrenDetails) {
        this.childrenDetails = childrenDetails;
    }

    public void setFatherPK(NodePK fatherPK) {
        this.fatherPK = fatherPK;
    }

    public void setId(int id) {
        this.getNodePK().setId(Integer.toString(id));
    }

    public void setPath(String path) {
        this.path = path;
        this.fullPath = path + this.nodePK.getId() + "/";
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getChildrenNumber() {
        return this.childrenDetails.size();
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String toString() {
        return "(pk = " + this.getNodePK().toString() + ", name = " + this.getName() + ", path = " + this.getPath() + ", level = " + this.getLevel() + ", fatherPK = " + this.getFatherPK().toString() + ", type = " + this.nodeType + ", order = " + this.getOrder() + ")";
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public boolean equals(Object other) {
        if (!(other instanceof NodeDetail)) {
            return false;
        }
        return this.getNodePK().getId().equals(((NodeDetail)other).getNodePK().getId()) && this.getNodePK().getComponentName().equals(((NodeDetail)other).getNodePK().getComponentName());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getURL() {
        return "searchResult?Type=Node&Id=" + this.getNodePK().getId();
    }

    public String getLink() {
        return URLUtil.getSimpleURL(3, this.getNodePK().getId(), this.getNodePK().getInstanceId());
    }

    public String getPermalink() {
        if (URLUtil.displayUniversalLinks()) {
            return URLUtil.getSimpleURL(3, this.nodePK.getId(), this.nodePK.getInstanceId());
        }
        return null;
    }

    public int getNbObjects() {
        return this.nbObjects;
    }

    public void setNbObjects(int nbObjects) {
        this.nbObjects = nbObjects;
    }

    public String getRightsDependsOn() {
        return this.rightsDependsOn;
    }

    public void setRightsDependsOn(String rightsDependsOn) {
        this.rightsDependsOn = rightsDependsOn;
    }

    public void setRightsDependsOnMe() {
        this.rightsDependsOn = this.nodePK.getId();
    }

    public boolean haveLocalRights() {
        return this.getNodePK().getId().equals(this.rightsDependsOn);
    }

    public boolean haveInheritedRights() {
        return this.haveRights() && !this.haveLocalRights();
    }

    public boolean haveRights() {
        return !this.rightsDependsOn.equals(NO_RIGHTS_DEPENDENCY);
    }

    public String getUserRole() {
        return this.userRole;
    }

    public void setUserRole(String userRole) {
        this.userRole = userRole;
    }

    public boolean isUseId() {
        return this.useId;
    }

    public boolean hasFather() {
        return !this.fatherPK.isUnclassed() && !this.fatherPK.isUndefined();
    }

    public void setUseId(boolean useId) {
        this.useId = useId;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public boolean isFatherOf(NodeDetail node) {
        boolean isFather = false;
        if (this.getNodePK().getInstanceId().equals(node.getNodePK().getInstanceId()) && !this.getNodePK().getId().equals(node.getNodePK().getId())) {
            String thisNodePath = this.getFullPath();
            String nodePath = node.getFullPath();
            if (nodePath.startsWith(thisNodePath)) {
                isFather = true;
            }
        }
        return isFather;
    }

    public boolean canBeAccessedBy(User user) {
        return NodeAccessControl.get().isUserAuthorized(user.getId(), this);
    }

    public boolean canBeModifiedBy(User user) {
        return NodeAccessControl.get().isUserAuthorized(user.getId(), this, AccessControlContext.init().onOperationsOf(new AccessControlOperation[]{AccessControlOperation.MODIFICATION}));
    }

    public boolean canBeFiledInBy(User user) {
        Set role = NodeAccessControl.get().getUserRoles(user.getId(), this.getNodePK(), AccessControlContext.init().onOperationsOf(new AccessControlOperation[]{AccessControlOperation.MODIFICATION}));
        return role.stream().anyMatch(r -> r.isGreaterThanOrEquals(SilverpeasRole.WRITER));
    }

    public boolean canBeSharedBy(User user) {
        AccessControlContext context = AccessControlContext.init().onOperationsOf(new AccessControlOperation[]{AccessControlOperation.SHARING});
        return NodeAccessControl.get().isUserAuthorized(user.getId(), this, context);
    }
}

