/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.mail.extractor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.mail.Address;
import javax.mail.internet.InternetAddress;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hsmf.MAPIMessage;
import org.apache.poi.hsmf.datatypes.AttachmentChunks;
import org.apache.poi.hsmf.datatypes.Chunks;
import org.apache.poi.hsmf.datatypes.RecipientChunks;
import org.apache.poi.hsmf.exceptions.ChunkNotFoundException;
import org.silverpeas.core.contribution.converter.DocumentFormat;
import org.silverpeas.core.contribution.converter.DocumentFormatConverterProvider;
import org.silverpeas.core.contribution.converter.option.FilterOption;
import org.silverpeas.core.mail.MailException;
import org.silverpeas.core.mail.extractor.ExtractorException;
import org.silverpeas.core.mail.extractor.Mail;
import org.silverpeas.core.mail.extractor.MailAttachment;
import org.silverpeas.core.mail.extractor.MailExtractor;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.util.WebEncodeHelper;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.kernel.logging.SilverLogger;

public class MSGExtractor
implements MailExtractor {
    private MAPIMessage message;

    public MSGExtractor(File file) throws ExtractorException {
        try {
            this.message = new MAPIMessage(file.getPath());
        }
        catch (IOException e) {
            throw new ExtractorException(e);
        }
        this.message.setReturnNullOnMissingChunk(true);
    }

    public MSGExtractor(InputStream file) throws ExtractorException {
        this.init(file);
    }

    private void init(InputStream file) throws ExtractorException {
        try {
            this.message = new MAPIMessage(file);
        }
        catch (IOException e) {
            throw new ExtractorException(e);
        }
        this.message.setReturnNullOnMissingChunk(true);
    }

    @Override
    public Mail getMail() throws MailException {
        try {
            Mail mail = new Mail();
            this.setMailDate(mail);
            this.setMailSubject(mail);
            Chunks mainChunks = this.message.getMainChunks();
            InternetAddress from = new InternetAddress(mainChunks.getEmailFromChunk().getValue(), mainChunks.getDisplayFromChunk().getValue());
            mail.setFrom(from);
            String[] toNames = StringUtils.split((String)this.message.getDisplayTo(), (char)';');
            mail.setTo(this.getInChunks(toNames).toArray(new Address[toNames.length]));
            String[] ccNames = StringUtils.split((String)this.message.getDisplayCC(), (char)';');
            List<InternetAddress> ccAddresses = this.getInChunks(ccNames);
            if (!ccAddresses.isEmpty()) {
                mail.setCc(this.getInChunks(ccNames).toArray(new Address[ccNames.length]));
            }
            this.setMailBody(mail);
            return mail;
        }
        catch (UnsupportedEncodingException | ParseException | ChunkNotFoundException e) {
            throw new MailException(e);
        }
    }

    private void setMailDate(Mail mail) throws ParseException {
        try {
            if (this.message.getMessageDate() != null) {
                mail.setDate(this.message.getMessageDate().getTime());
            } else {
                mail.setDate(this.extractDateOfReception());
            }
        }
        catch (ChunkNotFoundException e) {
            SilverLogger.getLogger((Object)this).warn((Throwable)e);
        }
    }

    private void setMailSubject(Mail mail) {
        try {
            mail.setSubject(this.message.getSubject());
        }
        catch (ChunkNotFoundException e) {
            SilverLogger.getLogger((Object)this).warn((Throwable)e);
        }
    }

    private void setMailBody(Mail mail) {
        try {
            String body2 = this.message.getHtmlBody();
            if (body2 == null && (body2 = this.getRtfText(this.message.getRtfBody())) == null) {
                body2 = WebEncodeHelper.javaStringToHtmlParagraphe((String)this.message.getTextBody());
            }
            mail.setBody(body2);
        }
        catch (ChunkNotFoundException e) {
            SilverLogger.getLogger((Object)this).warn((Throwable)e);
        }
    }

    private List<InternetAddress> getInChunks(String[] names) throws UnsupportedEncodingException {
        ArrayList<InternetAddress> result = new ArrayList<InternetAddress>(names.length);
        for (String name : names) {
            InternetAddress address = this.getInChunks(name.trim());
            if (address == null) continue;
            result.add(address);
        }
        return result;
    }

    private InternetAddress getInChunks(String name) throws UnsupportedEncodingException {
        RecipientChunks[] recipientChunks;
        for (RecipientChunks recipient : recipientChunks = this.message.getRecipientDetailsChunks()) {
            if (!name.equals(recipient.getRecipientName())) continue;
            return new InternetAddress(recipient.getRecipientEmailAddress(), recipient.getRecipientName());
        }
        return null;
    }

    private Date extractDateOfReception() throws ParseException {
        String chunkContent;
        int dateIdx;
        if (this.message.getMainChunks().getMessageHeaders() != null && (dateIdx = (chunkContent = this.message.getMainChunks().getMessageHeaders().getValue()).indexOf("Date: ")) >= 0) {
            int dateValueIdx = 6;
            chunkContent = chunkContent.substring(dateIdx + 6, chunkContent.indexOf(10, dateIdx)).replaceAll("[\r\n]", "");
            return new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH).parse(chunkContent);
        }
        return null;
    }

    private String getRtfText(String rtfText) {
        try {
            ByteArrayOutputStream htmlText = new ByteArrayOutputStream();
            DocumentFormatConverterProvider.getToHTMLConverter().convert(new ByteArrayInputStream(rtfText.getBytes(Charsets.UTF_8)), DocumentFormat.inFormat(DocumentFormat.rtf), htmlText, DocumentFormat.inFormat(DocumentFormat.html), new FilterOption[0]);
            return htmlText.toString(StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("Cannot convert RTF to HTML", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<MailAttachment> getAttachments() throws MailException {
        try {
            AttachmentChunks[] attachmentChunks = this.message.getAttachmentFiles();
            ArrayList<MailAttachment> mailAttachments = new ArrayList<MailAttachment>(attachmentChunks.length);
            for (AttachmentChunks attachment : attachmentChunks) {
                byte[] data = attachment.getAttachData().getValue();
                String fileName = attachment.getAttachLongFileName().getValue();
                MailAttachment mailAttachment = new MailAttachment(fileName);
                String dir = FileRepositoryManager.getTemporaryPath() + "mail" + Calendar.getInstance().getTimeInMillis();
                File file = new File(dir, fileName);
                FileUtils.writeByteArrayToFile((File)file, (byte[])data);
                mailAttachment.setPath(file.getAbsolutePath());
                mailAttachment.setSize(file.length());
                mailAttachments.add(mailAttachment);
            }
            return mailAttachments;
        }
        catch (IOException e) {
            throw new MailException(e);
        }
    }
}

