/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.io.media.image.thumbnail.service;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.io.media.image.thumbnail.ThumbnailException;
import org.silverpeas.core.io.media.image.thumbnail.ThumbnailRuntimeException;
import org.silverpeas.core.io.media.image.thumbnail.model.ThumbnailDAO;
import org.silverpeas.core.io.media.image.thumbnail.model.ThumbnailDetail;
import org.silverpeas.core.io.media.image.thumbnail.model.ThumbnailReference;
import org.silverpeas.core.io.media.image.thumbnail.service.ThumbnailService;
import org.silverpeas.core.persistence.jdbc.DBUtil;

@Service
@Default
public class ThumbnailServiceImpl
implements ThumbnailService {
    @Inject
    private ThumbnailDAO thumbnailDAO;

    protected ThumbnailServiceImpl() {
    }

    @Override
    public ThumbnailDetail createThumbnail(ThumbnailDetail thumbDetail) throws ThumbnailException {
        ThumbnailDetail thumbnailDetail;
        block8: {
            Connection con = DBUtil.openConnection();
            try {
                thumbnailDetail = this.thumbnailDAO.insertThumbnail(con, thumbDetail);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException se) {
                    throw new ThumbnailException("Thumbnail creation failure", se);
                }
            }
            con.close();
        }
        return thumbnailDetail;
    }

    @Override
    public void updateThumbnail(ThumbnailDetail thumbDetail) throws ThumbnailException {
        try (Connection con = DBUtil.openConnection();){
            this.thumbnailDAO.updateThumbnail(con, thumbDetail);
        }
        catch (SQLException se) {
            throw new ThumbnailException("Thumbnail update failure", se);
        }
    }

    @Override
    public void deleteThumbnail(ThumbnailDetail thumbDetail) throws ThumbnailException {
        try (Connection con = DBUtil.openConnection();){
            this.thumbnailDAO.deleteThumbnail(con, thumbDetail.getObjectId(), thumbDetail.getObjectType(), thumbDetail.getInstanceId());
        }
        catch (SQLException se) {
            throw new ThumbnailException("Thumbnail deletion failure", se);
        }
    }

    @Override
    public ThumbnailDetail getCompleteThumbnail(ThumbnailDetail thumbDetail) throws ThumbnailException {
        ThumbnailDetail thumbnailDetail;
        block8: {
            Connection con = DBUtil.openConnection();
            try {
                thumbnailDetail = this.thumbnailDAO.selectByKey(con, thumbDetail.getInstanceId(), thumbDetail.getObjectId(), thumbDetail.getObjectType());
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException se) {
                    throw new ThumbnailException("Thumbnail not found", se);
                }
            }
            con.close();
        }
        return thumbnailDetail;
    }

    @Override
    public List<ThumbnailDetail> getByReference(Set<ThumbnailReference> references) {
        List<ThumbnailDetail> list;
        block8: {
            Connection con = DBUtil.openConnection();
            try {
                list = this.thumbnailDAO.selectByReference(con, references);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException se) {
                    throw new ThumbnailRuntimeException("Thumbnail not found", se);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    public void deleteAllThumbnail(String componentId) throws ThumbnailException {
        try (Connection con = DBUtil.openConnection();){
            this.thumbnailDAO.deleteAllThumbnails(con, componentId);
        }
        catch (SQLException se) {
            throw new ThumbnailException("Thumbnail deletion failure", se);
        }
    }

    @Override
    public void moveThumbnail(ThumbnailDetail thumbDetail, String toInstanceId) throws ThumbnailException {
        try (Connection con = DBUtil.openConnection();){
            this.thumbnailDAO.moveThumbnail(con, thumbDetail, toInstanceId);
        }
        catch (SQLException se) {
            throw new ThumbnailException("Thumbnail move failure", se);
        }
    }
}

