/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.io.media.image.thumbnail.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.io.media.image.thumbnail.model.ThumbnailDetail;
import org.silverpeas.core.io.media.image.thumbnail.model.ThumbnailReference;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;

@Repository
public class ThumbnailDAO {
    private static final String THUMBNAIL_TABLE = "sb_thumbnail_thumbnail";
    private static final String ALL_FIELDS = "instanceid, objectid, objecttype, originalattachmentname, modifiedattachmentname, mimetype, xstart, ystart, xlength, ylength";
    private static final String INSERT_THUMBNAIL = "INSERT INTO sb_thumbnail_thumbnail (instanceid, objectid, objecttype, originalattachmentname, modifiedattachmentname, mimetype, xstart, ystart, xlength, ylength) VALUES ( ? , ? , ? , ? , ? , ? , ? , ? , ? , ?)";
    private static final String UPDATE_THUMBNAIL = "UPDATE sb_thumbnail_thumbnail SET xstart = ?, ystart = ?, xlength = ?, ylength = ?, originalattachmentname = ?, modifiedattachmentname = ? WHERE objectId = ? AND objectType = ? AND instanceId = ? ";
    private static final String DELETE_THUMBNAIL = "DELETE FROM sb_thumbnail_thumbnail WHERE objectId = ? AND objectType = ? AND instanceId = ? ";
    private static final String DELETE_COMPONENT_THUMBNAILS = "DELETE FROM sb_thumbnail_thumbnail WHERE instanceId = ?";
    private static final String SELECT_THUMBNAIL_BY_PK = "SELECT instanceid, objectid, objecttype, originalattachmentname, modifiedattachmentname, mimetype, xstart, ystart, xlength, ylength FROM sb_thumbnail_thumbnail WHERE objectId = ? AND objectType = ? AND instanceId = ?";
    private static final String MOVE_THUMBNAIL = "UPDATE sb_thumbnail_thumbnail  SET instanceId = ? WHERE objectId = ? AND objectType = ? AND instanceId = ? ";

    protected ThumbnailDAO() {
    }

    public ThumbnailDetail insertThumbnail(Connection con, ThumbnailDetail thumbnailDetail) throws SQLException {
        try (PreparedStatement prepStmt = con.prepareStatement(INSERT_THUMBNAIL);){
            prepStmt.setString(1, thumbnailDetail.getInstanceId());
            prepStmt.setInt(2, thumbnailDetail.getObjectId());
            prepStmt.setInt(3, thumbnailDetail.getObjectType());
            prepStmt.setString(4, thumbnailDetail.getOriginalFileName());
            if (thumbnailDetail.getCropFileName() != null) {
                prepStmt.setString(5, thumbnailDetail.getCropFileName());
            } else {
                prepStmt.setNull(5, 12);
            }
            if (thumbnailDetail.getMimeType() != null) {
                prepStmt.setString(6, thumbnailDetail.getMimeType());
            } else {
                prepStmt.setNull(6, 12);
            }
            if (thumbnailDetail.getXStart() != -1) {
                prepStmt.setInt(7, thumbnailDetail.getXStart());
            } else {
                prepStmt.setNull(7, 4);
            }
            if (thumbnailDetail.getYStart() != -1) {
                prepStmt.setInt(8, thumbnailDetail.getYStart());
            } else {
                prepStmt.setNull(8, 4);
            }
            if (thumbnailDetail.getXLength() != -1) {
                prepStmt.setInt(9, thumbnailDetail.getXLength());
            } else {
                prepStmt.setNull(9, 4);
            }
            if (thumbnailDetail.getYLength() != -1) {
                prepStmt.setInt(10, thumbnailDetail.getYLength());
            } else {
                prepStmt.setNull(10, 4);
            }
            prepStmt.executeUpdate();
        }
        return thumbnailDetail;
    }

    public void updateThumbnail(Connection con, ThumbnailDetail thumbToUpdate) throws SQLException {
        try (PreparedStatement prepStmt = con.prepareStatement(UPDATE_THUMBNAIL);){
            prepStmt.setInt(1, thumbToUpdate.getXStart());
            prepStmt.setInt(2, thumbToUpdate.getYStart());
            prepStmt.setInt(3, thumbToUpdate.getXLength());
            prepStmt.setInt(4, thumbToUpdate.getYLength());
            prepStmt.setString(5, thumbToUpdate.getOriginalFileName());
            prepStmt.setString(6, thumbToUpdate.getCropFileName());
            prepStmt.setInt(7, thumbToUpdate.getObjectId());
            prepStmt.setInt(8, thumbToUpdate.getObjectType());
            prepStmt.setString(9, thumbToUpdate.getInstanceId());
            prepStmt.executeUpdate();
        }
    }

    public void deleteThumbnail(Connection con, int objectId, int objectType, String instanceId) throws SQLException {
        try (PreparedStatement prepStmt = con.prepareStatement(DELETE_THUMBNAIL);){
            prepStmt.setInt(1, objectId);
            prepStmt.setInt(2, objectType);
            prepStmt.setString(3, instanceId);
            prepStmt.executeUpdate();
        }
    }

    public void moveThumbnail(Connection con, ThumbnailDetail thumbToUpdate, String toInstanceId) throws SQLException {
        try (PreparedStatement prepStmt = con.prepareStatement(MOVE_THUMBNAIL);){
            prepStmt.setString(1, toInstanceId);
            prepStmt.setInt(2, thumbToUpdate.getObjectId());
            prepStmt.setInt(3, thumbToUpdate.getObjectType());
            prepStmt.setString(4, thumbToUpdate.getInstanceId());
            prepStmt.executeUpdate();
        }
    }

    public void deleteAllThumbnails(Connection con, String instanceId) throws SQLException {
        try (PreparedStatement prepStmt = con.prepareStatement(DELETE_COMPONENT_THUMBNAILS);){
            prepStmt.setString(1, instanceId);
            prepStmt.executeUpdate();
        }
    }

    public ThumbnailDetail selectByKey(Connection con, String instanceId, int objectId, int objectType) throws SQLException {
        ThumbnailDetail thumbnailDetail;
        try (PreparedStatement prepStmt = con.prepareStatement(SELECT_THUMBNAIL_BY_PK);){
            prepStmt.setInt(1, objectId);
            prepStmt.setInt(2, objectType);
            prepStmt.setString(3, instanceId);
            try (ResultSet rs = prepStmt.executeQuery();){
                thumbnailDetail = rs.next() ? ThumbnailDAO.resultSet2ThumbDetail(rs) : null;
            }
        }
        return thumbnailDetail;
    }

    public List<ThumbnailDetail> selectByReference(Connection con, Set<ThumbnailReference> references) throws SQLException {
        ArrayList<ThumbnailDetail> result = new ArrayList<ThumbnailDetail>(references.size());
        Set instanceIds = references.stream().map(ResourceReference::getComponentInstanceId).collect(Collectors.toSet());
        Set objectIds = references.stream().map(WAPrimaryKey::getId).map(Integer::parseInt).collect(Collectors.toSet());
        Set objectTypes = references.stream().map(ThumbnailReference::getObjectType).collect(Collectors.toSet());
        JdbcSqlQuery.executeBySplittingOn(instanceIds, (instanceIdBatch, ignore) -> JdbcSqlQuery.executeBySplittingOn((Collection)objectIds, (objectIdBatch, ignoreToo) -> JdbcSqlQuery.select((String)ALL_FIELDS).from(new String[]{THUMBNAIL_TABLE}).where("instanceId", new Object[0]).in(instanceIdBatch).and("objectId", new Object[0]).in(objectIdBatch).and("objectType", new Object[0]).in((Collection)objectTypes).executeWith(con, rs -> {
            ThumbnailDetail thumbnailDetail = ThumbnailDAO.resultSet2ThumbDetail((ResultSet)rs);
            if (references.contains((Object)thumbnailDetail.getReference())) {
                result.add(thumbnailDetail);
            }
            return null;
        })));
        return result;
    }

    private static ThumbnailDetail resultSet2ThumbDetail(ResultSet rs) throws SQLException {
        ThumbnailDetail thumbnailDetail = new ThumbnailDetail(rs.getString("instanceid"), rs.getInt("objectid"), rs.getInt("objecttype"));
        thumbnailDetail.setOriginalFileName(rs.getString("originalattachmentname"));
        thumbnailDetail.setCropFileName(rs.getString("modifiedattachmentname"));
        thumbnailDetail.setMimeType(rs.getString("mimetype"));
        thumbnailDetail.setXStart(rs.getInt("xstart"));
        thumbnailDetail.setYStart(rs.getInt("ystart"));
        thumbnailDetail.setXLength(rs.getInt("xlength"));
        thumbnailDetail.setYLength(rs.getInt("ylength"));
        return thumbnailDetail;
    }
}

