/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.index.search.model;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.silverpeas.core.index.indexing.model.ExternalComponent;
import org.silverpeas.core.index.indexing.model.FieldDescription;
import org.silverpeas.kernel.util.StringUtil;

public final class QueryDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final HashSet<String> whereToSearch = new HashSet();
    private String query = "";
    private String searchingUser = "";
    private String requestedLang = null;
    private String requestedAuthor = null;
    private LocalDate requestedCreatedBefore = null;
    private LocalDate requestedCreatedAfter = null;
    private LocalDate requestedUpdatedBefore = null;
    private LocalDate requestedUpdatedAfter = null;
    private List<FieldDescription> multiFieldQuery = null;
    private String requestedFolder = null;
    private String taxonomyPosition = null;
    private final Set<ExternalComponent> extComponents = new HashSet<ExternalComponent>();
    private boolean adminScope = false;

    public QueryDescription() {
    }

    public QueryDescription(String query) {
        this.setQuery(query);
    }

    public void setQuery(String query) {
        this.query = query == null ? "" : query.toLowerCase();
        this.query = this.findAndReplace(this.query, " and ", " AND ");
        this.query = this.findAndReplace(this.query, " or ", " OR ");
        this.query = this.findAndReplace(this.query, " not ", " NOT ");
        if (this.query.indexOf("not ") == 0) {
            int notLength = 4;
            this.query = "NOT " + this.query.substring(4);
        }
    }

    public String getQuery() {
        return this.query;
    }

    public void setSearchingUser(String searchingUser) {
        this.searchingUser = searchingUser == null ? "" : searchingUser.toLowerCase();
    }

    public String getSearchingUser() {
        return this.searchingUser;
    }

    public void addComponent(String component) {
        this.whereToSearch.add(component);
    }

    public Set<String> getWhereToSearch() {
        return this.whereToSearch;
    }

    public void setRequestedLanguage(String requestedLang) {
        this.requestedLang = requestedLang;
    }

    public Optional<String> getRequestedLanguage() {
        return Optional.ofNullable(this.requestedLang).filter(Predicate.not("*"::equals));
    }

    public void setRequestedAuthor(String author) {
        this.requestedAuthor = author == null ? null : author.toLowerCase();
    }

    public String getRequestedAuthor() {
        return this.requestedAuthor;
    }

    public void setRequestedCreatedBefore(LocalDate beforedate) {
        this.requestedCreatedBefore = beforedate;
    }

    public LocalDate getRequestedCreatedBefore() {
        return this.requestedCreatedBefore;
    }

    public void setRequestedCreatedAfter(LocalDate afterdate) {
        this.requestedCreatedAfter = afterdate;
    }

    public LocalDate getRequestedCreatedAfter() {
        return this.requestedCreatedAfter;
    }

    public List<FieldDescription> getMultiFieldQuery() {
        return this.multiFieldQuery;
    }

    public void clearMultiFieldQuery() {
        if (this.multiFieldQuery != null) {
            this.multiFieldQuery.clear();
        }
    }

    public void addFieldQuery(FieldDescription fieldQuery) {
        if (fieldQuery == null) {
            return;
        }
        if (this.multiFieldQuery == null) {
            this.multiFieldQuery = new ArrayList<FieldDescription>();
        }
        this.multiFieldQuery.add(fieldQuery);
    }

    public void addFieldQueries(List<FieldDescription> fieldQueries) {
        if (this.multiFieldQuery == null) {
            this.multiFieldQuery = new ArrayList<FieldDescription>();
        }
        this.multiFieldQuery.addAll(fieldQueries);
    }

    public void setFieldQueries(List<FieldDescription> fieldQueries) {
        this.clearMultiFieldQuery();
        this.addFieldQueries(fieldQueries);
    }

    public boolean isEmpty() {
        boolean queryDefined = StringUtil.isDefined((String)this.query) || Optional.ofNullable(this.getMultiFieldQuery()).stream().flatMap(Collection::stream).anyMatch(Predicate.not(FieldDescription::isEmpty));
        boolean filtersDefined = StringUtil.isDefined((String)this.getRequestedAuthor()) || this.isPeriodDefined();
        return !queryDefined && !filtersDefined;
    }

    private String findAndReplace(String source, String find, String replace) {
        int index = source.indexOf(find);
        Object replacedSource = source;
        while (index > -1) {
            replacedSource = ((String)replacedSource).substring(0, index) + replace + ((String)replacedSource).substring(index + find.length());
            index = ((String)replacedSource).indexOf(find);
        }
        return replacedSource;
    }

    public boolean isPeriodDefined() {
        return !Objects.isNull(this.requestedCreatedAfter) || !Objects.isNull(this.requestedCreatedBefore) || !Objects.isNull(this.requestedUpdatedAfter) || !Objects.isNull(this.requestedUpdatedBefore);
    }

    public LocalDate getRequestedUpdatedBefore() {
        return this.requestedUpdatedBefore;
    }

    public void setRequestedUpdatedBefore(LocalDate requestedUpdatedBefore) {
        this.requestedUpdatedBefore = requestedUpdatedBefore;
    }

    public LocalDate getRequestedUpdatedAfter() {
        return this.requestedUpdatedAfter;
    }

    public void setRequestedUpdatedAfter(LocalDate requestedUpdatedAfter) {
        this.requestedUpdatedAfter = requestedUpdatedAfter;
    }

    public Set<ExternalComponent> getExtComponents() {
        return this.extComponents;
    }

    public void addExternalComponents(String server, String component, String path, String url) {
        this.extComponents.add(new ExternalComponent(server, component, path, url));
    }

    public void setRequestedFolder(String requestedFolder) {
        this.requestedFolder = requestedFolder;
    }

    public String getRequestedFolder() {
        return this.requestedFolder;
    }

    public String getTaxonomyPosition() {
        return this.taxonomyPosition;
    }

    public void setTaxonomyPosition(String taxonomyPosition) {
        this.taxonomyPosition = taxonomyPosition;
    }

    public boolean isTaxonomyUsed() {
        return StringUtil.isDefined((String)this.taxonomyPosition);
    }

    public boolean isAdminScope() {
        return this.adminScope;
    }

    public void setAdminScope(boolean adminScope) {
        this.adminScope = adminScope;
    }
}

