/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.index.search.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.silverpeas.core.index.indexing.model.IndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;

public class MatchingIndexEntry
extends IndexEntry
implements Serializable {
    private List<String> embeddedFileIds;
    private Map<String, String> sortableXMLFormFields = null;
    private Map<String, String> xmlFormFieldsForFacet = null;
    private static final long serialVersionUID = 5931254295396221458L;
    private boolean externalResult = false;
    private float score = 0.0f;

    public MatchingIndexEntry(IndexEntryKey pk) {
        super(pk);
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public Map<String, String> getSortableXMLFormFields() {
        return this.sortableXMLFormFields;
    }

    public void setSortableXMLFormFields(Map<String, String> sortableXMLFormFields) {
        this.sortableXMLFormFields = sortableXMLFormFields;
    }

    public void setEmbeddedFileIds(String[] embeddedFileIds) {
        this.embeddedFileIds = embeddedFileIds == null ? new ArrayList<String>() : Arrays.asList((String[])embeddedFileIds.clone());
    }

    public void setXMLFormFieldsForFacets(Map<String, String> fields) {
        this.xmlFormFieldsForFacet = fields;
    }

    public Map<String, String> getXMLFormFieldsForFacets() {
        return this.xmlFormFieldsForFacet;
    }

    public boolean isExternalResult() {
        return this.externalResult;
    }

    public void setExternalResult(boolean externalResult) {
        this.externalResult = externalResult;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MatchingIndexEntry that = (MatchingIndexEntry)o;
        return this.externalResult == that.externalResult && Float.compare(this.score, that.score) == 0 && Objects.equals(this.embeddedFileIds, that.embeddedFileIds) && Objects.equals(this.sortableXMLFormFields, that.sortableXMLFormFields) && Objects.equals(this.xmlFormFieldsForFacet, that.xmlFormFieldsForFacet);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.embeddedFileIds, this.sortableXMLFormFields, this.xmlFormFieldsForFacet, this.externalResult, Float.valueOf(this.score));
    }
}

