/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.publication.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationLink;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.model.ValidationStep;
import org.silverpeas.core.contribution.publication.service.PublicationService;
import org.silverpeas.core.security.authorization.PublicationAccessControl;

public class CompletePublication
implements Serializable {
    private static final long serialVersionUID = 7644813195325660580L;
    private PublicationDetail pubDetail;
    private List<PublicationLink> linkList;
    private List<PublicationLink> reverseLinkList;
    private List<ValidationStep> validationSteps = null;

    public CompletePublication(PublicationDetail pubDetail, List<PublicationLink> linkList, List<PublicationLink> reverseLinkList) {
        this.pubDetail = pubDetail;
        this.linkList = linkList;
        this.reverseLinkList = reverseLinkList;
    }

    public PublicationDetail getPublicationDetail() {
        return this.pubDetail;
    }

    public List<PublicationLink> getLinkList() {
        return this.linkList;
    }

    public List<PublicationLink> getReverseLinkList() {
        return this.reverseLinkList;
    }

    public void setValidationSteps(List<ValidationStep> validationSteps) {
        this.validationSteps = validationSteps;
    }

    public List<ValidationStep> getValidationSteps() {
        return this.validationSteps;
    }

    public List<PublicationLink> getLinkedPublications(String userId) {
        List<PublicationLink> publications = this.getAuthorizedLinks(userId, this.linkList);
        ArrayList<PublicationLink> reverseLinkListWithoutDuplicates = new ArrayList<PublicationLink>();
        for (PublicationLink reverseLink : this.reverseLinkList) {
            if (this.isReverseLinkADuplication(publications, reverseLink)) continue;
            reverseLinkListWithoutDuplicates.add(reverseLink);
        }
        publications.addAll(this.getAuthorizedLinks(userId, reverseLinkListWithoutDuplicates));
        return publications;
    }

    private boolean isReverseLinkADuplication(List<PublicationLink> links, PublicationLink linkToTest) {
        for (PublicationLink link : links) {
            if (!link.getTarget().equals((Object)linkToTest.getTarget())) continue;
            return true;
        }
        return false;
    }

    private List<PublicationLink> getAuthorizedLinks(String userId, List<PublicationLink> links) {
        PublicationService publicationService = PublicationService.get();
        PublicationAccessControl accessController = PublicationAccessControl.get();
        ArrayList<PublicationLink> authorizedLinks = new ArrayList<PublicationLink>();
        for (PublicationLink link : links) {
            PublicationDetail publi;
            PublicationPK pk = new PublicationPK(link.getTarget().getLocalId(), link.getTarget().getComponentInstanceId());
            if (!accessController.isUserAuthorized(userId, pk) || (publi = publicationService.getDetail(pk)) == null) continue;
            link.setPub(publi);
            authorizedLinks.add(link);
        }
        return authorizedLinks;
    }
}

