/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.publication.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.publication.model.Location;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.util.MapUtil;
import org.silverpeas.kernel.util.StringUtil;

public class PublicationFatherDAO {
    private static final String NODE_ID = "nodeId";
    private static final String ALIAS_USER_ID = "aliasUserId";
    private static final String ALIAS_DATE = "aliasDate";
    private static final String PUB_ORDER = "pubOrder";
    private static final String PUB_ID = "pubId";
    private static final String INSTANCE_ID = "instanceId";
    private static final String EQUALITY = " = ?";
    private static final String INSTANCE_ID_SET = "instanceId = ?";
    private static final String PUB_ID_SET = "pubId = ?";
    private static final String NODE_ID_SET = "nodeId = ?";
    private static final String LOCATION_FIELDS = "nodeId, instanceId, aliasUserId, aliasDate, pubOrder";
    static final String PUBLICATION_FATHER_TABLE_NAME = "SB_Publication_PubliFather";

    private PublicationFatherDAO() {
    }

    public static void deleteComponentInstanceData(String componentInstanceId) throws SQLException {
        JdbcSqlQuery.deleteFrom((String)PUBLICATION_FATHER_TABLE_NAME).where("pubId in (" + JdbcSqlQuery.select((String)PUB_ID).from(new String[]{"SB_Publication_Publi"}).where(INSTANCE_ID_SET, new Object[0]).getSqlQuery() + ")", new Object[]{componentInstanceId}).execute();
        JdbcSqlQuery.deleteFrom((String)PUBLICATION_FATHER_TABLE_NAME).where(INSTANCE_ID_SET, new Object[]{componentInstanceId}).execute();
    }

    public static void addFather(Connection con, PublicationPK pubPK, NodePK fatherPK) throws SQLException {
        JdbcSqlQuery.insertInto((String)PUBLICATION_FATHER_TABLE_NAME).withInsertParam(PUB_ID, (Object)Integer.parseInt(pubPK.getId())).withInsertParam(NODE_ID, (Object)Integer.parseInt(fatherPK.getId())).withInsertParam(INSTANCE_ID, (Object)pubPK.getInstanceId()).withInsertParam(ALIAS_USER_ID, null).withInsertParam(ALIAS_DATE, null).withInsertParam(PUB_ORDER, (Object)0).executeWith(con);
    }

    public static void updateOrder(Connection con, PublicationPK pubPK, NodePK fatherPK, int order) throws SQLException {
        JdbcSqlQuery.update((String)PUBLICATION_FATHER_TABLE_NAME).withUpdateParam(PUB_ORDER, (Object)order).where(PUB_ID_SET, new Object[]{Integer.parseInt(pubPK.getId())}).and(NODE_ID_SET, new Object[]{Integer.parseInt(fatherPK.getId())}).and(INSTANCE_ID_SET, new Object[]{pubPK.getInstanceId()}).executeWith(con);
    }

    public static void resetOrder(Connection con, NodePK fatherPK) throws SQLException {
        JdbcSqlQuery.update((String)PUBLICATION_FATHER_TABLE_NAME).withUpdateParam(PUB_ORDER, (Object)0).where(NODE_ID_SET, new Object[]{Integer.parseInt(fatherPK.getId())}).and(INSTANCE_ID_SET, new Object[]{fatherPK.getInstanceId()}).executeWith(con);
    }

    public static void addAlias(Connection con, PublicationPK pubPK, Location location) throws SQLException {
        if (!location.isAlias()) {
            throw new IllegalArgumentException("Location " + location.getId() + " isn't an alias!");
        }
        Location.Alias alias = location.getAlias();
        String userId = alias.getUserId() != null ? alias.getUserId() : User.getCurrentRequester().getId();
        Date date = alias.getDate() != null ? alias.getDate() : new Date();
        JdbcSqlQuery.insertInto((String)PUBLICATION_FATHER_TABLE_NAME).withInsertParam(PUB_ID, (Object)Integer.parseInt(pubPK.getId())).withInsertParam(NODE_ID, (Object)Integer.parseInt(location.getId())).withInsertParam(INSTANCE_ID, (Object)location.getInstanceId()).withInsertParam(ALIAS_USER_ID, (Object)Integer.parseInt(userId)).withInsertParam(ALIAS_DATE, (Object)Long.toString(date.getTime())).withInsertParam(PUB_ORDER, (Object)location.getPubOrder()).executeWith(con);
    }

    public static void removeAlias(Connection con, PublicationPK pubPK, Location location) throws SQLException {
        if (!location.isAlias()) {
            throw new IllegalArgumentException("Location " + location.getId() + " isn't an alias for publication " + pubPK.getId());
        }
        JdbcSqlQuery.deleteFrom((String)PUBLICATION_FATHER_TABLE_NAME).where(PUB_ID_SET, new Object[]{Integer.parseInt(pubPK.getId())}).and(NODE_ID_SET, new Object[]{Integer.parseInt(location.getId())}).and(INSTANCE_ID_SET, new Object[]{location.getInstanceId()}).andNotNull(ALIAS_DATE).andNotNull(ALIAS_USER_ID).executeWith(con);
    }

    public static Map<String, List<Location>> getAllLocationsByPublicationIds(Connection con, Collection<String> pubIds) throws SQLException {
        return JdbcSqlQuery.executeBySplittingOn(pubIds, (pubIdBatch, result) -> {
            JdbcSqlQuery query = JdbcSqlQuery.select((String)"nodeId, instanceId, aliasUserId, aliasDate, pubOrder, pubId").from(new String[]{PUBLICATION_FATHER_TABLE_NAME}).where(PUB_ID, new Object[0]).in((Collection)pubIdBatch.stream().map(Integer::parseInt).collect(Collectors.toList()));
            query.executeWith(con, r -> {
                Location location = PublicationFatherDAO.fetchLocation((ResultSet)r);
                MapUtil.putAddList(result, Integer.toString(r.getInt(6)), location);
                return null;
            });
        });
    }

    public static List<Location> getLocations(Connection con, PublicationPK pubPK) throws SQLException {
        JdbcSqlQuery query = JdbcSqlQuery.select((String)LOCATION_FIELDS).from(new String[]{PUBLICATION_FATHER_TABLE_NAME}).where(PUB_ID_SET, new Object[]{Integer.parseInt(pubPK.getId())});
        return PublicationFatherDAO.findLocations(con, query);
    }

    public static List<Location> getLocations(Connection con, PublicationPK pubPK, String compoId) throws SQLException {
        JdbcSqlQuery query = JdbcSqlQuery.select((String)LOCATION_FIELDS).from(new String[]{PUBLICATION_FATHER_TABLE_NAME}).where(PUB_ID_SET, new Object[]{Integer.parseInt(pubPK.getId())}).and(INSTANCE_ID_SET, new Object[]{compoId});
        return PublicationFatherDAO.findLocations(con, query);
    }

    private static List<Location> findLocations(Connection con, JdbcSqlQuery query) throws SQLException {
        return query.executeWith(con, PublicationFatherDAO::fetchLocation);
    }

    private static Location fetchLocation(ResultSet rs) throws SQLException {
        String id = Integer.toString(rs.getInt(1));
        String instanceId = rs.getString(2);
        Location location = new Location(id, instanceId);
        String sDate = rs.getString(4);
        if (StringUtil.isDefined((String)sDate)) {
            Date date = new Date(Long.parseLong(sDate));
            String userId = Integer.toString(rs.getInt(3));
            if (!rs.wasNull()) {
                location.setAsAlias(userId, date);
            }
        }
        int pubOrder = rs.getInt(5);
        location.setPubOrder(pubOrder);
        return location;
    }

    public static Location getMainLocation(Connection con, PublicationPK pubPK) throws SQLException {
        return (Location)JdbcSqlQuery.select((String)"nodeId, instanceId, pubOrder").from(new String[]{PUBLICATION_FATHER_TABLE_NAME}).where(PUB_ID_SET, new Object[]{Integer.parseInt(pubPK.getId())}).and(INSTANCE_ID_SET, new Object[]{pubPK.getInstanceId()}).andNull(ALIAS_USER_ID).andNull(ALIAS_DATE).executeUniqueWith(con, rs -> {
            String id = Integer.toString(rs.getInt(1));
            String instanceId = rs.getString(2);
            Location location = new Location(id, instanceId);
            int pubOrder = rs.getInt(3);
            location.setPubOrder(pubOrder);
            return location;
        });
    }

    public static void removeFather(Connection con, PublicationPK pubPK, NodePK fatherPK) throws SQLException {
        PublicationFatherDAO.removeLink(con, pubPK, fatherPK);
    }

    private static void removeFatherToPublications(Connection con, NodePK fatherPK) throws SQLException {
        List pubPKs = (List)PublicationFatherDAO.getPubPKsInFatherPK(con, fatherPK);
        for (PublicationPK publicationPK : pubPKs) {
            PublicationFatherDAO.removeLink(con, publicationPK, fatherPK);
        }
    }

    private static void removeLink(Connection con, PublicationPK pubPK, NodePK fatherPK) throws SQLException {
        JdbcSqlQuery.deleteFrom((String)PUBLICATION_FATHER_TABLE_NAME).where(PUB_ID_SET, new Object[]{Integer.parseInt(pubPK.getId())}).and(NODE_ID_SET, new Object[]{Integer.parseInt(fatherPK.getId())}).executeWith(con);
    }

    public static void removeFathersToPublications(Connection con, PublicationPK pubPK, Collection<String> fatherIds) throws SQLException {
        for (String fatherId : fatherIds) {
            NodePK fatherPK = new NodePK(fatherId, pubPK);
            PublicationFatherDAO.removeFatherToPublications(con, fatherPK);
        }
    }

    public static void removeAllFathers(Connection con, PublicationPK pubPK) throws SQLException {
        JdbcSqlQuery.deleteFrom((String)PUBLICATION_FATHER_TABLE_NAME).where(PUB_ID_SET, new Object[]{Integer.parseInt(pubPK.getId())}).executeWith(con);
    }

    public static List<NodePK> getAllFatherPKInSamePublicationComponentInstance(Connection con, PublicationPK pubPK) throws SQLException {
        return JdbcSqlQuery.select((String)NODE_ID).from(new String[]{PUBLICATION_FATHER_TABLE_NAME}).where(PUB_ID_SET, new Object[]{Integer.parseInt(pubPK.getId())}).and(INSTANCE_ID_SET, new Object[]{pubPK.getInstanceId()}).executeWith(con, row -> {
            String id = Integer.toString(row.getInt(1));
            return new NodePK(id, pubPK);
        });
    }

    public static Collection<PublicationPK> getPubPKsInFatherPK(Connection con, NodePK fatherPK) throws SQLException {
        PublicationPK pubPK = new PublicationPK("unknown", fatherPK);
        return JdbcSqlQuery.select((String)"P.pubId, P.instanceId").from(new String[]{"SB_Publication_PubliFather F", pubPK.getTableName() + " P"}).where("F.instanceId = ?", new Object[]{fatherPK.getInstanceId()}).and("F.nodeId = ?", new Object[]{Integer.parseInt(fatherPK.getId())}).and("F.pubId = P.pubId", new Object[0]).executeWith(con, row -> {
            String id = Integer.toString(row.getInt(1));
            String instanceId = row.getString(2);
            return new PublicationPK(id, instanceId);
        });
    }

    public static List<Location> getAliases(Connection con, PublicationPK pubPK) throws SQLException {
        JdbcSqlQuery query = JdbcSqlQuery.select((String)LOCATION_FIELDS).from(new String[]{PUBLICATION_FATHER_TABLE_NAME}).where(PUB_ID_SET, new Object[]{Integer.parseInt(pubPK.getId())}).andNotNull(ALIAS_DATE).andNotNull(ALIAS_USER_ID);
        return PublicationFatherDAO.findLocations(con, query);
    }
}

