/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.publication.dao;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import org.silverpeas.kernel.util.StringUtil;

public class DistributionTreeCriteria {
    private final String instanceId;
    private boolean checkVisibility = false;
    private String statusSubQuery = null;
    private Collection<String> instanceIdsToIgnore = null;

    public static DistributionTreeCriteria onInstanceId(String instanceId) {
        return new DistributionTreeCriteria(instanceId);
    }

    private DistributionTreeCriteria(String instanceId) {
        this.instanceId = instanceId;
    }

    DistributionTreeCriteria(DistributionTreeCriteria toCopy) {
        this.instanceId = toCopy.instanceId;
        this.checkVisibility = toCopy.checkVisibility;
        this.statusSubQuery = toCopy.statusSubQuery;
        this.instanceIdsToIgnore = toCopy.instanceIdsToIgnore != null ? new HashSet<String>(toCopy.instanceIdsToIgnore) : null;
    }

    public DistributionTreeCriteria withVisibilityCheck(boolean checkVisibility) {
        this.checkVisibility = checkVisibility;
        return this;
    }

    public DistributionTreeCriteria withManualStatusFilter(String statusSubQuery) {
        this.statusSubQuery = statusSubQuery;
        return this;
    }

    public DistributionTreeCriteria ignoringInstanceIds(Collection<String> instanceIdsToIgnore) {
        this.instanceIdsToIgnore = new HashSet<String>(instanceIdsToIgnore);
        return this;
    }

    String getInstanceId() {
        return this.instanceId;
    }

    Optional<String> getStatusSubQuery() {
        return Optional.ofNullable(this.statusSubQuery).filter(StringUtil::isDefined);
    }

    boolean visibilityCheckRequired() {
        return this.checkVisibility;
    }

    Collection<String> getInstanceIdsToIgnore() {
        return Optional.ofNullable(this.instanceIdsToIgnore).orElse(Collections.emptyList());
    }
}

