/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.wysiwyg.service.directive;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygContentTransformerDirective;
import org.silverpeas.kernel.util.Pair;

public abstract class AbstractDirective
implements WysiwygContentTransformerDirective {
    @Override
    public String execute(String wysiwygContent) {
        if (wysiwygContent == null) {
            return "";
        }
        Source source = new Source((CharSequence)wysiwygContent);
        HashMap<String, String> replacements = new HashMap<String, String>();
        this.prepareReplacements(source, replacements);
        String transformedWysiwygContent = wysiwygContent;
        for (Map.Entry replacement : replacements.entrySet()) {
            transformedWysiwygContent = transformedWysiwygContent.replace((CharSequence)replacement.getKey(), (CharSequence)replacement.getValue());
        }
        return transformedWysiwygContent;
    }

    protected abstract void prepareReplacements(Source var1, Map<String, String> var2);

    protected void modifyElementAttribute(StartTag linkStartTag, String attrName, UnaryOperator<String> newValue, Map<String, String> replacements) {
        this.modifyElementAttributes(linkStartTag, List.of(Pair.of((Object)attrName, newValue)), replacements);
    }

    protected void modifyElementAttributes(StartTag linkStartTag, Collection<Pair<String, UnaryOperator<String>>> attrDirectives, Map<String, String> replacements) {
        String startTagAsString = linkStartTag.toString();
        if (replacements.containsKey(startTagAsString)) {
            return;
        }
        String currentStartTagAsString = startTagAsString;
        for (Pair<String, UnaryOperator<String>> attrDirective : attrDirectives) {
            String attrName = (String)attrDirective.getFirst();
            UnaryOperator newValue = (UnaryOperator)attrDirective.getSecond();
            String currentAttrValue = linkStartTag.getAttributeValue(attrName);
            if (currentAttrValue == null) {
                currentStartTagAsString = currentStartTagAsString.replaceFirst("([ \t\r\n]*)>$", " " + attrName + "=\"" + (String)newValue.apply(null) + "\"$1>");
                continue;
            }
            currentStartTagAsString = currentStartTagAsString.replaceAll("(" + attrName + "[ \t\r\n]*=[ \t\r\n]*([\"'])[ \t\r\n]*)" + currentAttrValue + "([ \t\r\n]*([\"']))", "$1" + (String)newValue.apply(currentAttrValue) + "$2");
        }
        replacements.put(startTagAsString, currentStartTagAsString);
    }
}

