/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.record;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.contribution.attachment.AttachmentException;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.DocumentType;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.attachment.util.SimpleDocumentList;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FieldDisplayer;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.RecordSet;
import org.silverpeas.core.contribution.content.form.RecordTemplate;
import org.silverpeas.core.contribution.content.form.TypeManager;
import org.silverpeas.core.contribution.content.form.displayers.WysiwygFCKFieldDisplayer;
import org.silverpeas.core.contribution.content.form.record.GenericDataRecord;
import org.silverpeas.core.contribution.content.form.record.GenericRecordSetManager;
import org.silverpeas.core.contribution.content.form.record.IdentifiedRecordTemplate;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class GenericRecordSet
implements RecordSet,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IdentifiedRecordTemplate recordTemplate;

    public GenericRecordSet(IdentifiedRecordTemplate recordTemplate) {
        this.recordTemplate = recordTemplate;
    }

    @Override
    public RecordTemplate getRecordTemplate() {
        return this.recordTemplate;
    }

    @Override
    public DataRecord getEmptyRecord() throws FormException {
        return this.recordTemplate.getEmptyRecord();
    }

    @Override
    public DataRecord getRecord(String objectId) throws FormException {
        return this.getGenericRecordSetManager().getRecord(this.recordTemplate, objectId);
    }

    @Override
    public DataRecord getRecord(String objectId, String language) throws FormException {
        return this.getGenericRecordSetManager().getRecord(this.recordTemplate, objectId, language);
    }

    @Override
    public List<DataRecord> getRecords(String fieldName, String fieldValue) throws FormException {
        return this.getGenericRecordSetManager().getRecords(this.recordTemplate, fieldName, fieldValue);
    }

    private void insert(DataRecord record) throws FormException {
        this.recordTemplate.checkDataRecord(record);
        this.getGenericRecordSetManager().insertRecord(this.recordTemplate, record);
    }

    private void update(DataRecord record) throws FormException {
        this.recordTemplate.checkDataRecord(record);
        this.getGenericRecordSetManager().updateRecord(this.recordTemplate, record);
    }

    @Override
    public void save(DataRecord record) throws FormException {
        if (record.isNew()) {
            this.insert(record);
        } else {
            this.update(record);
        }
    }

    private void indexRecord(String recordId, String formName, FullIndexEntry indexEntry, String language) throws FormException {
        String[] fieldNames;
        DataRecord data = this.getRecord(recordId, language);
        if (data == null) {
            return;
        }
        for (String fieldName : fieldNames = data.getFieldNames()) {
            Field field = data.getField(fieldName);
            FieldTemplate fieldTemplate = this.recordTemplate.getFieldTemplate(fieldName);
            if (field == null || fieldTemplate == null) continue;
            this.index(formName, indexEntry, language, fieldName, fieldTemplate, field, data);
        }
    }

    private void index(String formName, FullIndexEntry indexEntry, String language, String fieldName, FieldTemplate fieldTemplate, Field field, DataRecord data) {
        String fieldType = fieldTemplate.getTypeName();
        String fieldDisplayerName = fieldTemplate.getDisplayerName();
        try {
            FieldDisplayer<Field> fieldDisplayer;
            if (!StringUtil.isDefined((String)fieldDisplayerName)) {
                fieldDisplayerName = TypeManager.getInstance().getDisplayerName(fieldType);
            }
            if ((fieldDisplayer = TypeManager.getInstance().getDisplayer(fieldType, fieldDisplayerName)) != null) {
                String key = formName + "$$" + fieldName;
                if (fieldTemplate.isRepeatable()) {
                    for (int i = 0; i < fieldTemplate.getMaximumNumberOfOccurrences(); ++i) {
                        field.setStringValue(data.getField(fieldName, i).getStringValue());
                        fieldDisplayer.index(indexEntry, key, fieldName, field, language, fieldTemplate.isUsedAsFacet());
                    }
                } else {
                    fieldDisplayer.index(indexEntry, key, fieldName, field, language, fieldTemplate.isUsedAsFacet());
                }
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    @Override
    public void indexRecord(String recordId, String formName, FullIndexEntry indexEntry) throws FormException {
        if (!I18NHelper.isI18nContentActivated) {
            this.indexRecord(recordId, formName, indexEntry, null);
        } else {
            List<String> languages = this.getGenericRecordSetManager().getLanguagesOfRecord(this.recordTemplate, recordId);
            for (String language : languages) {
                this.indexRecord(recordId, formName, indexEntry, language);
            }
        }
    }

    private void delete(DataRecord record, String language) throws FormException {
        if (record != null) {
            ResourceReference resourceReference = new ResourceReference(record.getId(), this.recordTemplate.getInstanceId());
            WysiwygFCKFieldDisplayer.removeContents(resourceReference, this.getWYSIWYGFieldNames(record), language);
            SimpleDocumentList<SimpleDocument> docs = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType(resourceReference, DocumentType.form, language);
            for (SimpleDocument doc : docs) {
                AttachmentServiceProvider.getAttachmentService().deleteAttachment(doc, false);
            }
            this.getGenericRecordSetManager().deleteRecord(record);
        }
    }

    @Override
    public void delete(String objectId) throws FormException {
        List<String> languages = this.getGenericRecordSetManager().getLanguagesOfRecord(this.recordTemplate, objectId);
        for (String lang : languages) {
            this.delete(objectId, lang);
        }
    }

    @Override
    public void delete(String objectId, String language) throws FormException {
        DataRecord data = this.getRecord(objectId, language);
        if (data != null && data.getLanguage().equals(language)) {
            this.delete(data, language);
        }
    }

    private List<String> getWYSIWYGFieldNames(DataRecord data) {
        String[] fieldNames;
        ArrayList<String> wysiwygFieldNames = new ArrayList<String>();
        if (data == null) {
            return wysiwygFieldNames;
        }
        for (String fieldName : fieldNames = data.getFieldNames()) {
            try {
                String fieldDisplayerName;
                FieldTemplate fieldTemplate;
                Field field = data.getField(fieldName);
                if (field == null || (fieldTemplate = this.recordTemplate.getFieldTemplate(fieldName)) == null || !"wysiwyg".equals(fieldDisplayerName = fieldTemplate.getDisplayerName())) continue;
                wysiwygFieldNames.add(fieldName);
            }
            catch (FormException fe) {
                SilverLogger.getLogger((Object)this).error((Throwable)((Object)fe));
            }
        }
        return wysiwygFieldNames;
    }

    @Override
    public void move(ResourceReference fromPK, ResourceReference toPK, RecordTemplate toRecordTemplate) throws FormException {
        WysiwygFCKFieldDisplayer wysiwygDisplayer = new WysiwygFCKFieldDisplayer();
        try {
            wysiwygDisplayer.move(fromPK, toPK);
        }
        catch (IOException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
        SimpleDocumentList<SimpleDocument> documents = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType(fromPK, DocumentType.form, null);
        for (SimpleDocument doc : documents) {
            AttachmentServiceProvider.getAttachmentService().moveDocument(doc, toPK);
        }
        List<String> languages = this.getGenericRecordSetManager().getLanguagesOfRecord(this.recordTemplate, fromPK.getId());
        for (String lang : languages) {
            GenericDataRecord record = (GenericDataRecord)this.getRecord(fromPK.getId(), lang);
            if (record == null) continue;
            this.getGenericRecordSetManager().moveRecord(record.getInternalId(), (IdentifiedRecordTemplate)toRecordTemplate);
        }
    }

    @Override
    public void copy(ResourceReference fromPK, ResourceReference toPK, RecordTemplate toRecordTemplate, Map<String, String> oldAndNewFileIds) throws FormException {
        WysiwygFCKFieldDisplayer wysiwygDisplayer = new WysiwygFCKFieldDisplayer();
        try {
            wysiwygDisplayer.cloneContents(fromPK, toPK, oldAndNewFileIds);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
        HashMap<String, String> ids = new HashMap<String, String>();
        try {
            SimpleDocumentList<SimpleDocument> originals = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType(fromPK, DocumentType.form, null);
            for (SimpleDocument original : originals) {
                SimpleDocumentPK clonePk = AttachmentServiceProvider.getAttachmentService().copyDocument(original, toPK);
                ids.put(original.getId(), clonePk.getId());
            }
        }
        catch (AttachmentException e) {
            throw new FormException((Throwable)((Object)e));
        }
        List<String> languages = this.getGenericRecordSetManager().getLanguagesOfRecord(this.recordTemplate, fromPK.getId());
        for (String lang : languages) {
            GenericDataRecord record = (GenericDataRecord)this.getRecord(fromPK.getId(), lang);
            if (record == null) continue;
            record.setInternalId(-1);
            record.setId(toPK.getId());
            this.replaceIds(ids, record);
            this.getGenericRecordSetManager().insertRecord((IdentifiedRecordTemplate)toRecordTemplate, record);
        }
    }

    @Override
    public void clone(String originalExternalId, String originalComponentId, String cloneExternalId, String cloneComponentId, Map<String, String> attachmentIds) throws FormException {
        GenericDataRecord record = (GenericDataRecord)this.getRecord(originalExternalId);
        record.setInternalId(-1);
        record.setId(cloneExternalId);
        ResourceReference fromPK = new ResourceReference(originalExternalId, originalComponentId);
        ResourceReference toPK = new ResourceReference(cloneExternalId, cloneComponentId);
        WysiwygFCKFieldDisplayer wysiwygDisplayer = new WysiwygFCKFieldDisplayer();
        try {
            wysiwygDisplayer.cloneContents(fromPK, toPK, attachmentIds);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
        try {
            SimpleDocumentList<SimpleDocument> originals = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType(fromPK, DocumentType.form, null);
            originals.addAll(AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType(fromPK, DocumentType.video, null));
            HashMap<String, String> ids = new HashMap<String, String>(originals.size());
            for (SimpleDocument original : originals) {
                SimpleDocumentPK clonePk = AttachmentServiceProvider.getAttachmentService().cloneDocument(original, cloneExternalId);
                ids.put(original.getId(), clonePk.getId());
            }
            this.replaceIds(ids, record);
        }
        catch (AttachmentException e) {
            throw new FormException((Throwable)((Object)e));
        }
        this.insert(record);
    }

    @Override
    public void merge(String fromExternalId, String fromComponentId, String toExternalId, String toComponentId, Map<String, String> attachmentIds) throws FormException {
        GenericDataRecord fromRecord = (GenericDataRecord)this.getRecord(fromExternalId);
        GenericDataRecord toRecord = (GenericDataRecord)this.getRecord(toExternalId);
        fromRecord.setInternalId(toRecord.getInternalId());
        fromRecord.setId(toExternalId);
        WysiwygFCKFieldDisplayer wysiwygDisplayer = new WysiwygFCKFieldDisplayer();
        try {
            wysiwygDisplayer.mergeContents(fromComponentId, fromExternalId, toComponentId, toExternalId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
        ResourceReference fromPK = new ResourceReference(fromExternalId, fromComponentId);
        ResourceReference toPK = new ResourceReference(toExternalId, toComponentId);
        try {
            Map<String, String> ids = AttachmentServiceProvider.getAttachmentService().mergeDocuments(toPK, fromPK, DocumentType.form);
            Map<String, String> videoIds = AttachmentServiceProvider.getAttachmentService().mergeDocuments(toPK, fromPK, DocumentType.video);
            ids.putAll(videoIds);
            this.replaceIds(ids, fromRecord);
        }
        catch (AttachmentException e) {
            throw new FormException((Throwable)((Object)e));
        }
        this.update(fromRecord);
    }

    private void replaceIds(Map<String, String> ids, GenericDataRecord record) throws FormException {
        String[] fieldNames;
        for (String fieldName : fieldNames = record.getFieldNames()) {
            this.getRecordFieldAndTemplateByFieldName(record, fieldName).ifPresent(p -> {
                Field field = (Field)p.getKey();
                FieldTemplate fieldTemplate = (FieldTemplate)p.getValue();
                String fieldType = fieldTemplate.getTypeName();
                String currentValue = field.getStringValue();
                if ("file".equals(fieldType)) {
                    if (ids.containsKey(currentValue)) {
                        this.setStringValueQuietly(field, (String)ids.get(currentValue));
                    }
                } else {
                    Optional.ofNullable(currentValue).filter(o -> o.startsWith("xmlWysiwygField_")).ifPresent(o -> {
                        String newValue = o.replaceFirst("[0-9]+", record.getId());
                        this.setStringValueQuietly(field, newValue);
                    });
                }
            });
        }
    }

    private void setStringValueQuietly(Field field, String value) {
        try {
            field.setStringValue(value);
        }
        catch (FormException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)((Object)e));
        }
    }

    private Optional<Pair<Field, FieldTemplate>> getRecordFieldAndTemplateByFieldName(GenericDataRecord record, String fieldName) throws FormException {
        FieldTemplate fieldTemplate;
        Field field = record.getField(fieldName);
        if (field != null && (fieldTemplate = this.recordTemplate.getFieldTemplate(fieldName)) != null) {
            return Optional.of(Pair.of((Object)field, (Object)fieldTemplate));
        }
        return Optional.empty();
    }

    private GenericRecordSetManager getGenericRecordSetManager() {
        return GenericRecordSetManager.getInstance();
    }
}

