/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.form;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspWriter;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.contribution.content.form.AbstractForm;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FieldDisplayer;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.RecordTemplate;
import org.silverpeas.core.contribution.content.form.Util;
import org.silverpeas.core.contribution.content.form.displayers.WysiwygFCKFieldDisplayer;
import org.silverpeas.core.contribution.content.form.record.GenericFieldTemplate;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class XmlForm
extends AbstractForm {
    public XmlForm(RecordTemplate template) throws FormException {
        super(template);
    }

    public XmlForm(RecordTemplate template, boolean viewForm) throws FormException {
        super(template);
        this.setViewForm(viewForm);
    }

    @Override
    public String toString(PagesContext pagesContext, DataRecord record) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        this.display(pw, pagesContext, record);
        return sw.toString();
    }

    private void display(PrintWriter out, PagesContext pageContext, DataRecord record) {
        String language = pageContext.getLanguage();
        pageContext.setContentLanguage(record.getLanguage());
        pageContext.setIgnoreDefaultValues(false);
        String mode = "";
        if (pageContext.isDesignMode()) {
            mode = "mode-design";
        }
        out.println("<div class=\"forms " + this.getFormName() + " " + mode + "\">");
        out.println(this.getSkippableSnippet(pageContext));
        out.println("<input type=\"hidden\" name=\"id\" value=\"" + record.getId() + "\"/>");
        if (pageContext.getPrintTitle() && StringUtil.isDefined((String)this.getTitle())) {
            out.println("<h2 class=\"form-title\">");
            out.println(this.getTitle());
            out.println("</h2>");
        }
        List<FieldTemplate> listFields = this.getFieldTemplates();
        boolean mandatory = false;
        if (listFields != null && !listFields.isEmpty()) {
            if (pageContext.isBorderPrinted()) {
                out.println("<ul class=\"fields form-border\">");
            } else {
                out.println("<ul class=\"fields\">");
            }
            out.flush();
            PagesContext pc = new PagesContext(pageContext);
            pc.setNbFields(listFields.size());
            if (record != null) {
                pc.incCurrentFieldIndex(1);
            }
            pc.setLastFieldIndex(this.getLastFieldIndex(pageContext, record, listFields));
            for (FieldTemplate fieldTemplate : listFields) {
                String actor;
                Map<String, String> parameters = fieldTemplate.getParameters(language);
                String fieldName = fieldTemplate.getFieldName();
                Object fieldLabel = fieldTemplate.getLabel(language);
                if ("assignForm".equals(pageContext.getFormName()) && StringUtil.isDefined((String)(actor = parameters.get("roles")))) {
                    fieldLabel = (String)fieldLabel + "<br>(" + actor + ")";
                }
                String fieldDisplayerName = fieldTemplate.getDisplayerName();
                boolean isMandatory = fieldTemplate.isMandatory();
                boolean isDisabled = fieldTemplate.isDisabled();
                boolean isReadOnly = fieldTemplate.isReadOnly();
                boolean isHidden = fieldTemplate.isHidden();
                String fieldClass = "";
                if (parameters.containsKey("classLabel")) {
                    fieldClass = parameters.get("classLabel");
                }
                Field field = null;
                if (record != null) {
                    try {
                        field = record.getField(fieldName);
                    }
                    catch (FormException fe) {
                        SilverLogger.getLogger((Object)this).error(SilverpeasExceptionMessages.unknown((String)"fieldName", (Object)fieldName), (Throwable)((Object)fe));
                    }
                }
                boolean displayField = true;
                boolean richContent = false;
                if (!pageContext.isDesignMode() && fieldTemplate.isHidden()) {
                    displayField = false;
                } else if (this.isViewForm() && !Util.isEmptyFieldsDisplayed() && (displayField = StringUtil.isDefined((String)field.getStringValue())) && field.getStringValue().startsWith("xmlWysiwygField_")) {
                    String fileName = field.getStringValue().substring("xmlWysiwygField_".length());
                    displayField = this.isWYSIWYGFieldDefined(fileName, pageContext);
                    richContent = true;
                }
                if (!displayField || record == null || field == null) continue;
                FieldDisplayer<Field> fieldDisplayer = this.getFieldDisplayer(fieldTemplate);
                if (fieldDisplayer != null) {
                    Object aClass = "class=\"txtlibform\"";
                    if (StringUtil.isDefined((String)fieldClass)) {
                        aClass = "class=\"txtlibform " + fieldClass + "\"";
                    }
                    Object technicalNameHelp = "";
                    if (pageContext.isDesignMode()) {
                        technicalNameHelp = " title=\"" + fieldName + "\"";
                    }
                    out.println("<li class=\"field field_" + fieldName + "\" id=\"form-row-" + fieldName + "\">");
                    out.println("<label for=\"" + fieldName + "\" " + (String)aClass + (String)technicalNameHelp + ">" + (String)fieldLabel + "</label>");
                    Object divClass = "fieldInput";
                    if (richContent) {
                        divClass = (String)divClass + " rich-content";
                    }
                    out.println("<div class=\"" + (String)divClass + "\">");
                    if (!fieldTemplate.isRepeatable()) {
                        field = this.getSureField(fieldTemplate, record, 0);
                        try {
                            fieldDisplayer.display(out, field, fieldTemplate, pc);
                        }
                        catch (FormException fe) {
                            SilverLogger.getLogger((Object)this).error(SilverpeasExceptionMessages.failureOnRendering((String)"field", (Object)field.getName()), (Throwable)((Object)fe));
                        }
                    } else {
                        boolean isWriting = !"simpletext".equals(fieldTemplate.getDisplayerName()) && !fieldTemplate.isReadOnly();
                        String currentVisibility = "field-occurrence-shown";
                        int maxOccurrences = fieldTemplate.getMaximumNumberOfOccurrences();
                        Field lastNotEmptyField = this.getLastNotEmptyField(record, fieldName, maxOccurrences);
                        out.println("<ul class=\"repeatable-field-list\">");
                        for (int occ = 0; occ < maxOccurrences; ++occ) {
                            field = this.getSureField(fieldTemplate, record, occ);
                            if (occ > 0) {
                                ((GenericFieldTemplate)fieldTemplate).setMandatory(false);
                                currentVisibility = !isWriting ? (field.isNull() ? "field-occurrence-hidden" : "field-occurrence-shown") : (lastNotEmptyField == null || occ > lastNotEmptyField.getOccurrence() ? "field-occurrence-hidden" : "field-occurrence-shown");
                            }
                            out.println("<li class=\"" + currentVisibility + " repeatable-field-list-element" + occ + "\">");
                            try {
                                fieldDisplayer.display(out, field, fieldTemplate, pc);
                            }
                            catch (FormException fe) {
                                SilverLogger.getLogger((Object)this).error(SilverpeasExceptionMessages.failureOnRendering((String)"field", (Object)field.getName()), (Throwable)((Object)fe));
                            }
                            out.println("</li>");
                        }
                        out.println("</ul>");
                        if (isWriting && (lastNotEmptyField == null || lastNotEmptyField.getOccurrence() < maxOccurrences - 1)) {
                            Util.printOneMoreInputSnippet(fieldName, pc, out);
                        }
                    }
                    if (pageContext.isDesignMode()) {
                        out.println("<span class=\"actions\">");
                        out.println("<a title=\"" + Util.getString("GML.modify", language) + "\" href=\"#\" onclick=\"editField('" + fieldName + "','" + fieldDisplayerName + "');return false;\"><img alt=\"" + Util.getString("GML.modify", language) + "\" src=\"/silverpeas/util/icons/update.gif\"/></a>");
                        out.println("<a title=\"" + Util.getString("GML.delete", language) + "\" href=\"#\" onclick=\"deleteField('" + fieldName + "');return false;\"><img alt=\"" + Util.getString("GML.delete", language) + "\" src=\"/silverpeas/util/icons/delete.gif\"/></a>");
                        out.println("</span>");
                    }
                    out.println("</div>");
                    out.println("</li>");
                }
                if (isMandatory && !isDisabled && !isHidden && fieldDisplayer.isDisplayedMandatory() && !isReadOnly) {
                    mandatory = true;
                }
                out.flush();
                pc.incCurrentFieldIndex(fieldDisplayer.getNbHtmlObjectsDisplayed(fieldTemplate, pc));
            }
        }
        out.println("</ul>");
        if (mandatory && pageContext.isShowMandatorySnippet()) {
            out.println("<div class=\"legend\">");
            out.println(Util.getMandatorySnippet() + "&nbsp;:&nbsp;" + Util.getString("GML.requiredField", language));
            out.println("</div>");
        }
        out.println("</div>");
        out.flush();
    }

    @Override
    public void display(JspWriter jw, PagesContext pageContext, DataRecord record) {
        PrintWriter out = new PrintWriter((Writer)jw, true);
        this.display(out, pageContext, record);
    }

    private int getLastFieldIndex(PagesContext pc, DataRecord record, List<FieldTemplate> listFields) {
        int lastFieldIndex = -1;
        lastFieldIndex += Integer.parseInt(pc.getCurrentFieldIndex());
        for (FieldTemplate fieldTemplate : listFields) {
            FieldDisplayer fieldDisplayer;
            if (fieldTemplate == null) continue;
            String fieldName = fieldTemplate.getFieldName();
            Field field = null;
            if (record != null) {
                try {
                    field = record.getField(fieldName);
                }
                catch (FormException fe) {
                    SilverLogger.getLogger((Object)this).error(SilverpeasExceptionMessages.unknown((String)"fieldName", (Object)fieldName), (Throwable)((Object)fe));
                }
            }
            if (record != null && field == null || (fieldDisplayer = this.getFieldDisplayer(fieldTemplate)) == null) continue;
            lastFieldIndex += fieldDisplayer.getNbHtmlObjectsDisplayed(fieldTemplate, pc);
        }
        return lastFieldIndex;
    }

    private Field getLastNotEmptyField(DataRecord record, String fieldName, int nbOccurrences) {
        Field lastNotEmptyField = null;
        for (int occ = 0; occ < nbOccurrences; ++occ) {
            Field field = record.getField(fieldName, occ);
            if (field == null || field.isNull()) continue;
            lastNotEmptyField = field;
        }
        return lastNotEmptyField;
    }

    private boolean isWYSIWYGFieldDefined(String fileName, PagesContext pc) {
        String content = WysiwygFCKFieldDisplayer.getContentFromFile(pc.getComponentId(), fileName);
        return StringUtil.isDefined((String)content);
    }
}

