/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.displayers;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.fileupload.FileItem;
import org.apache.ecs.xhtml.div;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.Util;
import org.silverpeas.core.contribution.content.form.displayers.AbstractFieldDisplayer;
import org.silverpeas.core.contribution.content.form.field.MultipleUserField;
import org.silverpeas.core.html.plugin.UserGroupSelectProducer;
import org.silverpeas.core.util.file.FileUploadUtil;
import org.silverpeas.kernel.util.StringUtil;

public class MultipleUserFieldDisplayer
extends AbstractFieldDisplayer<MultipleUserField> {
    private static final int NB_HTML_ELEMENTS = 2;

    public String[] getManagedTypes() {
        return new String[]{"multipleUser"};
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pagesContext) {
        MultipleUserFieldDisplayer.produceMandatoryCheck(out, template, pagesContext);
    }

    @Override
    public void display(PrintWriter out, MultipleUserField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        boolean writable = !template.isHidden() && !template.isDisabled() && !template.isReadOnly();
        String language = pageContext.getLanguage();
        String selectUsersLab = Util.getString("usersPanel", language);
        String deleteUsersLab = Util.getString("clearUser", language);
        String fieldName = template.getFieldName();
        String rootContainerId = "select-user-group-" + fieldName + String.valueOf(UUID.randomUUID());
        String userIds = field.getTypeName().equals("multipleUser") ? field.getStringValue() : "";
        UserGroupSelectProducer selectUsers = UserGroupSelectProducer.withContainerId(rootContainerId).withUserInputName(fieldName).selectionOf(UserGroupSelectProducer.SelectionType.USER).multiple(true).readOnly(!writable).hidden(template.isHidden()).withUserIds(userIds).withUserPanelButtonLabel(selectUsersLab).withRemoveButtonLabel(deleteUsersLab);
        if (writable) {
            boolean usersOfInstanceOnly;
            Map<String, String> parameters = template.getParameters(pageContext.getLanguage());
            String roles = parameters.get("roles");
            boolean bl = usersOfInstanceOnly = StringUtil.getBooleanValue((String)parameters.get("usersOfInstanceOnly")) || StringUtil.isDefined((String)roles);
            if (usersOfInstanceOnly) {
                selectUsers.filterOnComponentId(pageContext.getComponentId());
            }
            selectUsers.filterOnRoles(roles);
            selectUsers.mandatory(template.isMandatory() && pageContext.useMandatory());
        }
        out.println(new div().setID(rootContainerId));
        out.println(selectUsers.produce());
    }

    @Override
    public List<String> update(String newIds, MultipleUserField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        if ("multipleUser".equals(field.getTypeName())) {
            if (!StringUtil.isDefined((String)newIds)) {
                field.setNull();
            } else {
                field.setStringValue(newIds);
            }
        } else {
            throw new FormException("Incorrect field value type. Expected {0}", "user");
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> update(List<FileItem> items, MultipleUserField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        String itemName = template.getFieldName();
        String value = FileUploadUtil.getParameter(items, itemName);
        return this.applyUpdate(field, value, template, pageContext);
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 2;
    }
}

