/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.attachment;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.attachment.AttachmentException;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.core.notification.NotificationException;
import org.silverpeas.core.notification.user.client.NotificationMetaData;
import org.silverpeas.core.notification.user.client.NotificationSender;
import org.silverpeas.core.notification.user.client.UserRecipient;
import org.silverpeas.core.scheduler.Scheduler;
import org.silverpeas.core.scheduler.SchedulerEvent;
import org.silverpeas.core.scheduler.SchedulerEventListener;
import org.silverpeas.core.scheduler.SchedulerProvider;
import org.silverpeas.core.scheduler.trigger.JobTrigger;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.core.util.Link;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class ScheduledReservedFile
implements Initialization {
    public static final String ATTACHMENT_JOB_NAME_PROCESS = "A_ProcessReservedFileAttachment";
    private static final String ATTACHMENT_NOTIF_NAME = "attachment.notifName";
    private final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.util.attachment.Attachment");
    private final LocalizationBundle generalMessage = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.multilang.generalMultilang");

    public void init() {
        try {
            String cron = this.settings.getString("cronScheduledReservedFile");
            SilverLogger.getLogger((Object)this).debug("Reserved File Processor scheduled with cron ''{0}''", new Object[]{cron});
            Scheduler scheduler = SchedulerProvider.getVolatileScheduler();
            scheduler.unscheduleJob(ATTACHMENT_JOB_NAME_PROCESS);
            JobTrigger trigger = JobTrigger.triggerAt((String)cron);
            scheduler.scheduleJob(ATTACHMENT_JOB_NAME_PROCESS, trigger, (SchedulerEventListener)new ReservedFileListener());
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("Reservation file scheduling failure", (Throwable)e);
        }
    }

    public void doScheduledReservedFile() throws AttachmentException {
        try {
            LocalizationBundle message = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.util.attachment.multilang.attachment", (String)DisplayI18NHelper.getDefaultLanguage());
            StringBuilder messageBody = new StringBuilder();
            Calendar calendar = Calendar.getInstance(Locale.FRENCH);
            calendar.add(5, 1);
            Date expiryDate = calendar.getTime();
            List<SimpleDocument> documents = AttachmentServiceProvider.getAttachmentService().listExpiringDocuments(expiryDate, null);
            for (SimpleDocument simpleDocument : documents) {
                String date = this.getExpiryDate(simpleDocument);
                String subject = this.createMessageSubject(message, false, false);
                messageBody.append(message.getString(ATTACHMENT_NOTIF_NAME)).append(" '").append(simpleDocument.getFilename()).append("'");
                String body2 = this.createMessageBody(message, messageBody, date, false, false);
                NotificationMetaData notifMetaData = new NotificationMetaData(0, subject, body2);
                this.createMessage(date, notifMetaData, simpleDocument, false, false);
                messageBody = new StringBuilder();
            }
            calendar = Calendar.getInstance(Locale.FRENCH);
            Date alertDate = calendar.getTime();
            documents = AttachmentServiceProvider.getAttachmentService().listDocumentsRequiringWarning(alertDate, null);
            messageBody = new StringBuilder();
            for (SimpleDocument document : documents) {
                String date = this.getExpiryDate(document);
                String subject = this.createMessageSubject(message, true, false);
                messageBody.append(message.getString(ATTACHMENT_NOTIF_NAME)).append(" '").append(document.getFilename()).append("'");
                String body3 = this.createMessageBody(message, messageBody, date, true, false);
                NotificationMetaData notifMetaData = new NotificationMetaData(0, subject, body3);
                this.createMessage(date, notifMetaData, document, true, false);
                messageBody = new StringBuilder();
            }
            calendar = Calendar.getInstance(Locale.FRENCH);
            Date date = calendar.getTime();
            documents = AttachmentServiceProvider.getAttachmentService().listDocumentsToUnlock(date, null);
            messageBody = new StringBuilder();
            for (SimpleDocument document : documents) {
                String date2 = this.getExpiryDate(document);
                String subject = this.createMessageSubject(message, false, true);
                messageBody.append(message.getString(ATTACHMENT_NOTIF_NAME)).append(" '").append(document.getFilename()).append("'");
                String body4 = this.createMessageBody(message, messageBody, date2, false, true);
                NotificationMetaData notifMetaData = new NotificationMetaData(0, subject, body4);
                this.createMessage(date2, notifMetaData, document, false, true);
                messageBody = new StringBuilder();
                document.unlock();
                AttachmentServiceProvider.getAttachmentService().updateAttachment(document, false, false);
            }
        }
        catch (Exception e) {
            throw new AttachmentException(e);
        }
    }

    private String getExpiryDate(SimpleDocument document) {
        Calendar atDate = Calendar.getInstance();
        atDate.setTime(document.getExpiry());
        String day = "GML.jour" + atDate.get(7);
        String month = "GML.mois" + atDate.get(2);
        return this.generalMessage.getString(day) + " " + atDate.get(5) + " " + this.generalMessage.getString(month) + " " + atDate.get(1);
    }

    private void createMessageByLanguage(String date, String url, SimpleDocument document, NotificationMetaData notifMetaData, boolean alert, boolean lib) throws AttachmentException {
        for (String language : DisplayI18NHelper.getLanguages()) {
            LocalizationBundle message = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.util.attachment.multilang.attachment", (String)language);
            String subject = this.createMessageSubject(message, alert, lib);
            StringBuilder messageBody = new StringBuilder();
            messageBody.append(message.getString(ATTACHMENT_NOTIF_NAME)).append(" '").append(document.getFilename()).append("'");
            String body2 = this.createMessageBody(message, messageBody, date, alert, lib);
            notifMetaData.addLanguage(language, subject, body2);
            Link link = new Link(url, message.getString("attachment.notifLinkLabel"));
            notifMetaData.setLink(link, language);
        }
    }

    private void createMessage(String date, NotificationMetaData notifMetaData, SimpleDocument document, boolean alert, boolean lib) throws AttachmentException {
        String url = URLUtil.getURL(null, null, document.getInstanceId()) + "GoToFilesTab?Id=" + document.getForeignId();
        this.createMessageByLanguage(date, url, document, notifMetaData, alert, lib);
        notifMetaData.addUserRecipient(new UserRecipient(document.getEditedBy()));
        notifMetaData.setComponentId(document.getInstanceId());
        this.notifyUser(notifMetaData, "-1", document.getInstanceId());
    }

    private String createMessageBody(LocalizationBundle message, StringBuilder body2, String date, boolean alert, boolean lib) {
        if (lib) {
            return body2.append(" ").append(message.getString("attachment.notifUserLib")).append("\n\n").toString();
        }
        if (alert) {
            return body2.append(" ").append(message.getString("attachment.notifUserAlert")).append(" (").append(date).append(") ").append("\n\n").toString();
        }
        return body2.append(" ").append(message.getString("attachment.notifUserExpiry")).append("\n\n").toString();
    }

    private String createMessageSubject(LocalizationBundle message, boolean alert, boolean lib) {
        if (lib) {
            return message.getString("attachment.notifSubjectLib");
        }
        if (alert) {
            return message.getString("attachment.notifSubjectAlert");
        }
        return message.getString("attachment.notifSubjectExpiry");
    }

    public void notifyUser(NotificationMetaData notifMetaData, String senderId, String componentId) throws AttachmentException {
        try {
            if (!StringUtil.isDefined((String)notifMetaData.getSender())) {
                notifMetaData.setSender(senderId);
            }
            NotificationSender notifSender = new NotificationSender(componentId);
            notifSender.notifyUser(notifMetaData);
        }
        catch (NotificationException e) {
            throw new AttachmentException(e);
        }
    }

    public class ReservedFileListener
    implements SchedulerEventListener {
        public void triggerFired(SchedulerEvent anEvent) {
            ScheduledReservedFile.this.doScheduledReservedFile();
        }

        public void jobSucceeded(SchedulerEvent anEvent) {
        }

        public void jobFailed(SchedulerEvent anEvent) {
            SilverLogger.getLogger((Object)this).error("The job {0} wasn't successful", new Object[]{anEvent.getJobExecutionContext().getJobName()});
        }
    }
}

