/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.cmis.model;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.silverpeas.core.ResourceIdentifier;
import org.silverpeas.core.cmis.model.CmisFile;
import org.silverpeas.core.cmis.model.Folding;
import org.silverpeas.core.cmis.model.TypeId;

public abstract class CmisFolder
extends CmisFile
implements Folding {
    public static List<TypeId> getAllowedChildrenType() {
        return Collections.emptyList();
    }

    CmisFolder(ResourceIdentifier id, String name, String language) {
        super(id, name, language);
    }

    @Override
    public CmisFolder setParentId(String parentId) {
        super.setParentId(parentId);
        return this;
    }

    @Override
    public boolean isOrphaned() {
        return false;
    }

    @Override
    public boolean isFolding() {
        return true;
    }

    @Override
    protected Supplier<Set<Action>> getAllowableActionsSupplier() {
        Supplier<Set<Object>> supplier = this.isRoot() ? () -> this.completeWithCommonFolderActions(this.theCommonActions()) : () -> this.completeWithFolderActions(this.theCommonActions());
        return supplier;
    }

    private Set<Action> completeWithCommonFolderActions(Set<Action> actions) {
        actions.add(Action.CAN_GET_DESCENDANTS);
        actions.add(Action.CAN_GET_CHILDREN);
        actions.add(Action.CAN_GET_FOLDER_TREE);
        return actions;
    }

    protected Set<Action> completeWithFolderActions(Set<Action> actions) {
        actions.add(Action.CAN_GET_FOLDER_PARENT);
        return this.completeWithCommonFolderActions(this.completeWithFileActions(actions));
    }
}

