/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.space;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.inject.Default;
import javax.inject.Singleton;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.admin.space.UserFavoriteSpaceService;
import org.silverpeas.core.admin.space.model.UserFavoriteSpaceBean;
import org.silverpeas.core.admin.space.model.UserFavoriteSpaceVO;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.persistence.jdbc.bean.BeanCriteria;
import org.silverpeas.core.persistence.jdbc.bean.PersistenceException;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBeanDAO;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBeanDAOFactory;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasEntityBean;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
@Singleton
@Default
public class UserFavoriteSpaceServiceImpl
implements UserFavoriteSpaceService {
    private static final String USER_ID = "userId";

    @Override
    public List<UserFavoriteSpaceVO> getListUserFavoriteSpace(String userId) {
        ArrayList<UserFavoriteSpaceVO> listUserFavoriteSpaces = new ArrayList<UserFavoriteSpaceVO>();
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)USER_ID, (Object)Integer.parseInt(userId));
            SilverpeasBeanDAO dao = SilverpeasBeanDAOFactory.getDAO(UserFavoriteSpaceBean.class);
            Collection beansUserFavoriteSpaces = dao.findBy(criteria);
            if (!beansUserFavoriteSpaces.isEmpty()) {
                for (UserFavoriteSpaceBean userFavoriteSpaceBean : beansUserFavoriteSpaces) {
                    listUserFavoriteSpaces.add(new UserFavoriteSpaceVO(userFavoriteSpaceBean.getUserId(), userFavoriteSpaceBean.getSpaceId()));
                }
            }
        }
        catch (PersistenceException e) {
            SilverLogger.getLogger((Object)this).error("Cannot get user favorite space for user {0}", (Object[])new String[]{userId}, (Throwable)e);
        }
        return listUserFavoriteSpaces;
    }

    @Override
    public boolean addUserFavoriteSpace(UserFavoriteSpaceVO ufsVO) {
        boolean result = false;
        try {
            if (this.isUserFavoriteSpaceAlreadyExist(ufsVO.getUserId(), ufsVO.getSpaceId())) {
                result = true;
            } else {
                SilverpeasBeanDAO dao = SilverpeasBeanDAOFactory.getDAO(UserFavoriteSpaceBean.class);
                dao.add((SilverpeasEntityBean)new UserFavoriteSpaceBean(ufsVO.getUserId(), ufsVO.getSpaceId()));
                result = true;
            }
        }
        catch (PersistenceException e) {
            SilverLogger.getLogger((Object)this).error("User Favorite space error for user {0}", (Object[])new Integer[]{ufsVO.getUserId()}, (Throwable)e);
        }
        return result;
    }

    private boolean isUserFavoriteSpaceAlreadyExist(int userId, int spaceId) {
        boolean exist = false;
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)USER_ID, (Object)userId).and("spaceId", (Object)spaceId);
            SilverpeasBeanDAO dao = SilverpeasBeanDAOFactory.getDAO(UserFavoriteSpaceBean.class);
            Collection beansUserFavoriteSpaces = dao.findBy(criteria);
            if (!beansUserFavoriteSpaces.isEmpty()) {
                exist = true;
            }
        }
        catch (PersistenceException e) {
            SilverLogger.getLogger((Object)this).error("User Favorite space error for user {0}", (Object[])new Integer[]{userId}, (Throwable)e);
        }
        return exist;
    }

    @Override
    public boolean removeUserFavoriteSpace(UserFavoriteSpaceVO ufsVO) {
        boolean result = false;
        BeanCriteria criteria = BeanCriteria.emptyCriteria();
        int removedUserId = ufsVO.getUserId();
        int removedSpaceId = ufsVO.getSpaceId();
        if (removedUserId == -1 && removedSpaceId == -1) {
            return true;
        }
        if (removedUserId != -1) {
            criteria.and(USER_ID, (Object)removedUserId);
        }
        if (removedSpaceId != -1) {
            criteria.and("spaceId", (Object)removedSpaceId);
        }
        try {
            SilverpeasBeanDAO dao = SilverpeasBeanDAOFactory.getDAO(UserFavoriteSpaceBean.class);
            dao.removeBy(criteria);
            result = true;
        }
        catch (PersistenceException e) {
            SilverLogger.getLogger((Object)this).error("Cannot remove user favorite space for user {0}", (Object[])new Integer[]{ufsVO.getUserId()}, (Throwable)e);
        }
        return result;
    }

    @Override
    public boolean isUserFavoriteSpace(List<UserFavoriteSpaceVO> listUFS, SpaceInstLight space) {
        boolean result = false;
        if (listUFS != null && !listUFS.isEmpty()) {
            for (UserFavoriteSpaceVO userFavoriteSpaceVO : listUFS) {
                if (space.getLocalId() != userFavoriteSpaceVO.getSpaceId()) continue;
                return true;
            }
        }
        return result;
    }

    @Override
    public boolean containsFavoriteSubSpace(SpaceInstLight space, List<UserFavoriteSpaceVO> listUFS, String userId) {
        String[] userSubSpaceIds;
        boolean result = false;
        OrganizationController organisationController = (OrganizationController)ServiceProvider.getService(OrganizationController.class, (Annotation[])new Annotation[0]);
        for (String curSpaceId : userSubSpaceIds = organisationController.getAllowedSubSpaceIds(userId, space.getId())) {
            SpaceInstLight subSpace = organisationController.getSpaceInstLightById(curSpaceId);
            if (!this.isUserFavoriteSpace(listUFS, subSpace) && !this.containsFavoriteSubSpace(subSpace, listUFS, userId)) continue;
            return true;
        }
        return result;
    }
}

