/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.silverpeas.core.admin.BaseRightProfile;
import org.silverpeas.core.admin.ProfiledObjectId;
import org.silverpeas.core.admin.ProfiledObjectIds;
import org.silverpeas.core.admin.ProfiledObjectType;
import org.silverpeas.core.admin.component.model.CompoSpace;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.component.model.ComponentSearchCriteria;
import org.silverpeas.core.admin.component.model.PersonalComponentInstance;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.component.model.ToolInstance;
import org.silverpeas.core.admin.domain.model.Domain;
import org.silverpeas.core.admin.domain.model.DomainProperty;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.SpaceProfile;
import org.silverpeas.core.admin.service.SpaceWithSubSpacesAndComponents;
import org.silverpeas.core.admin.service.UserSpaceAvailabilityChecker;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.admin.user.model.GroupDetail;
import org.silverpeas.core.admin.user.model.GroupsSearchCriteria;
import org.silverpeas.core.admin.user.model.ProfileInst;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.model.UserDetailsSearchCriteria;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.core.util.ListSlice;
import org.silverpeas.core.util.SilverpeasArrayList;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Pair;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Singleton
public class DefaultOrganizationController
implements OrganizationController {
    @Inject
    private Administration admin;

    @Override
    public String[] getAllSpaceIds() {
        try {
            return this.getAdminService().getAllSpaceIds();
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return ArrayUtil.emptyStringArray();
        }
    }

    @Override
    public String[] getAllSubSpaceIds(String sSpaceId) {
        try {
            return this.getAdminService().getAllSubSpaceIds(sSpaceId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return ArrayUtil.emptyStringArray();
        }
    }

    @Override
    public String[] getSpaceNames(String[] asSpaceIds) {
        try {
            return this.getAdminService().getSpaceNames(asSpaceIds);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return ArrayUtil.emptyStringArray();
        }
    }

    @Override
    public SpaceInstLight getSpaceInstLightById(String spaceId) {
        try {
            return this.getAdminService().getSpaceInstLightById(spaceId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public SpaceInst getSpaceInstById(String sSpaceId) {
        try {
            return this.getAdminService().getSpaceInstById(sSpaceId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String[] getAvailCompoIds(String sClientSpaceId, String sUserId) {
        try {
            return this.getAdminService().getAvailCompoIds(sClientSpaceId, sUserId);
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)((Object)e));
            return ArrayUtil.emptyStringArray();
        }
    }

    @Override
    public String[] getAvailCompoIds(String sUserId) {
        try {
            return this.getAdminService().getAvailCompoIds(sUserId);
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)((Object)e));
            return ArrayUtil.emptyStringArray();
        }
    }

    @Override
    public String[] getAvailCompoIdsAtRoot(String sClientSpaceId, String sUserId) {
        try {
            return this.getAdminService().getAvailCompoIdsAtRoot(sClientSpaceId, sUserId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return ArrayUtil.emptyStringArray();
        }
    }

    @Override
    public CompoSpace[] getCompoForUser(String sUserId, String sCompoName) {
        try {
            return this.getAdminService().getCompoForUser(sUserId, sCompoName);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return new CompoSpace[0];
        }
    }

    @Override
    public List<ComponentInstLight> getAvailComponentInstLights(String userId, String componentName) {
        try {
            return this.getAdminService().getAvailComponentInstLights(userId, componentName);
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)((Object)e));
            return new ArrayList<ComponentInstLight>();
        }
    }

    @Override
    public String[] getComponentIdsForUser(String sUserId, String sCompoName) {
        try {
            return this.getAdminService().getComponentIdsByNameAndUserId(sUserId, sCompoName);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return ArrayUtil.emptyStringArray();
        }
    }

    @Override
    public String[] getCompoId(String sCompoName) {
        try {
            return this.getAdminService().getCompoId(sCompoName);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return ArrayUtil.emptyStringArray();
        }
    }

    @Override
    public String getComponentParameterValue(String sComponentId, String parameterName) {
        return this.getAdminService().getComponentParameterValue(sComponentId, parameterName);
    }

    @Override
    public List<ComponentInstLight> getComponentsWithParameterValue(String param, String value) {
        return this.getAdminService().getComponentsWithParameter(param, value);
    }

    @Override
    public Map<String, Map<String, String>> getParameterValuesByComponentIdThenByParamName(Collection<String> componentIds, Collection<String> paramNames) {
        return this.getAdminService().getParameterValuesByComponentIdThenByParamName(componentIds, paramNames);
    }

    @Override
    public Optional<SilverpeasComponentInstance> getComponentInstance(String componentInstanceIdentifier) {
        try {
            if (StringUtil.isDefined((String)componentInstanceIdentifier)) {
                return Optional.ofNullable(this.getAdminService().getComponentInstance(componentInstanceIdentifier));
            }
            return Optional.empty();
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public ComponentInst getComponentInst(String sComponentId) {
        try {
            return this.getAdminService().getComponentInst(sComponentId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public ComponentInstLight getComponentInstLight(String sComponentId) {
        try {
            return this.getAdminService().getComponentInstLight(sComponentId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public UserFull getUserFull(String sUserId) {
        try {
            User requester = User.getCurrentRequester();
            return this.removeSensitiveData(this.getAdminService().getUserFull(sUserId), requester);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public List<UserFull> getUserFulls(Collection<String> userIds) {
        try {
            return this.removeSensitiveData(this.getAdminService().getUserFulls(userIds));
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public UserDetail getUserDetail(String sUserId) {
        try {
            User requester = User.getCurrentRequester();
            return this.removeSensitiveData(this.getAdminService().getUserDetail(sUserId), requester);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public UserDetail[] getUserDetails(String[] asUserIds) {
        try {
            return this.removeSensitiveData(this.getAdminService().getUserDetails(asUserIds));
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return new UserDetail[0];
        }
    }

    public UserDetail[] getAllUsers(String componentId) {
        try {
            if (componentId != null) {
                return this.removeSensitiveData(this.getAdminService().getUsers(true, null, componentId));
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
        }
        return new UserDetail[0];
    }

    public UserDetail[] getAllUsersInDomain(String domainId) {
        try {
            if (domainId != null) {
                return this.removeSensitiveData(this.getAdminService().getUsersOfDomain(domainId));
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
        }
        return new UserDetail[0];
    }

    @Override
    public <T extends User> List<T> getUsersOfDomains(List<String> domainIds) {
        try {
            return this.removeSensitiveData(this.getAdminService().getUsersOfDomains(domainIds));
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)((Object)e));
            return Collections.emptyList();
        }
    }

    @Override
    public <T extends User> List<T> getUsersOfDomainsFromNewestToOldest(List<String> domainIds) {
        try {
            return this.removeSensitiveData(this.getAdminService().getUsersOfDomainsFromNewestToOldest(domainIds));
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)((Object)e));
            return Collections.emptyList();
        }
    }

    @Override
    public <T extends User> SilverpeasList<T> searchUsers(UserDetailsSearchCriteria criteria) {
        try {
            SilverpeasList userDetails = SilverpeasList.wrap(this.removeSensitiveData((List<T>)this.getAdminService().searchUsers(criteria)));
            return userDetails;
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)((Object)e));
            return new ListSlice(Collections.emptyList());
        }
    }

    public Group[] getAllRootGroupsInDomain(String domainId) {
        try {
            if (domainId != null) {
                return this.getAdminService().getRootGroupsOfDomain(domainId);
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
        }
        return new Group[0];
    }

    public UserDetail[] getFilteredDirectUsers(String sGroupId, String sUserLastNameFilter) {
        try {
            return this.removeSensitiveData(this.getAdminService().getFilteredDirectUsers(sGroupId, sUserLastNameFilter));
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return new UserDetail[0];
        }
    }

    @Override
    public <T extends Group> SilverpeasList<T> searchGroups(GroupsSearchCriteria criteria) {
        try {
            return this.getAdminService().searchGroups(criteria);
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)((Object)e));
            return new SilverpeasArrayList();
        }
    }

    @Override
    public int getAllSubUsersNumber(String sGroupId) {
        try {
            return this.getAdminService().getAllSubUsersNumber(sGroupId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public Group[] getAllSubGroups(String parentGroupId) {
        try {
            return this.getAdminService().getAllSubGroups(parentGroupId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return new Group[0];
        }
    }

    public Group[] getRecursivelyAllSubgroups(String parentGroupId) {
        try {
            return this.getAdminService().getRecursivelyAllSubGroups(parentGroupId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return new Group[0];
        }
    }

    public UserDetail[] getAllUsers() {
        try {
            return this.removeSensitiveData(this.getAdminService().getAllUsers().toArray(new UserDetail[0]));
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return new UserDetail[0];
        }
    }

    public UserDetail[] getUsers(String componentId, String profile) {
        try {
            UserDetail[] aUserDetail = null;
            if (componentId != null) {
                aUserDetail = this.removeSensitiveData(this.getAdminService().getUsers(false, profile, componentId));
            }
            return aUserDetail;
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return new UserDetail[0];
        }
    }

    @Override
    public Collection<SilverpeasRole> getUserSilverpeasRolesOn(User user, String componentInstanceIdentifier) {
        Optional<PersonalComponentInstance> personalComponentInstance = PersonalComponentInstance.from(componentInstanceIdentifier);
        if (personalComponentInstance.isPresent()) {
            return personalComponentInstance.get().getSilverpeasRolesFor(user);
        }
        Set silverpeasRoles = SilverpeasRole.fromStrings((String[])this.getUserProfiles(user.getId(), componentInstanceIdentifier));
        silverpeasRoles.remove(SilverpeasRole.MANAGER);
        return silverpeasRoles;
    }

    @Override
    public String[] getUserProfiles(String userId, String componentId) {
        try {
            return this.getAdminService().getCurrentProfiles(userId, componentId);
        }
        catch (Exception e) {
            if (!this.isToolAvailable(componentId)) {
                SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            }
            return new String[0];
        }
    }

    @Override
    public Map<String, Set<String>> getUserProfilesByComponentId(String userId, Collection<String> componentIds) {
        try {
            return this.getAdminService().getUserProfilesByComponentId(userId, componentIds);
        }
        catch (Exception e) {
            if (componentIds.stream().anyMatch(i -> !this.isToolAvailable((String)i))) {
                SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            }
            return Collections.emptyMap();
        }
    }

    @Override
    public List<String> getSpaceUserProfilesBySpaceId(String userId, String spaceId) {
        try {
            return this.getAdminService().getSpaceUserProfilesBySpaceId(userId, spaceId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public Map<String, Set<String>> getSpaceUserProfilesBySpaceIds(String userId, Collection<String> spaceIds) {
        try {
            return this.getAdminService().getSpaceUserProfilesBySpaceIds(userId, spaceIds);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    @Override
    public String[] getUserProfiles(String userId, String componentId, ProfiledObjectId objectId) {
        try {
            return this.getAdminService().getProfilesByObjectAndUserId(objectId, componentId, userId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return new String[0];
        }
    }

    @Override
    public Map<Pair<String, String>, Set<String>> getUserProfilesByComponentIdAndObjectId(String userId, Collection<String> componentIds, ProfiledObjectIds profiledObjectIds) {
        try {
            return this.getAdminService().getUserProfilesByComponentIdAndObjectId(profiledObjectIds, componentIds, userId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    @Override
    public Map<String, List<String>> getUserObjectProfiles(String userId, String componentId, ProfiledObjectType profiledObjectType) {
        try {
            return this.getAdminService().getProfilesByObjectTypeAndUserId(profiledObjectType, componentId, userId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    @Override
    public List<ProfileInst> getUserProfiles(String componentId, ProfiledObjectId objectId) {
        try {
            return this.getAdminService().getProfilesByObject(objectId, componentId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public ProfileInst getUserProfile(String profileId) {
        try {
            return this.getAdminService().getProfileInst(profileId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String[] getAdministratorUserIds(String fromUserId) {
        try {
            return this.getAdminService().getAdministratorUserIds(fromUserId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return ArrayUtil.emptyStringArray();
        }
    }

    public Group getGroup(String sGroupId) {
        try {
            return this.getAdminService().getGroup(sGroupId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Group[] getGroups(String[] groupsId) {
        Group[] groups = null;
        try {
            groups = this.getAdminService().getGroups(groupsId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
        }
        return groups;
    }

    public Group[] getAllGroups() {
        try {
            List<GroupDetail> groups = this.getAdminService().getAllGroups();
            return groups.toArray(new Group[0]);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return new Group[0];
        }
    }

    public Group[] getAllRootGroups() {
        try {
            List<GroupDetail> groups = this.getAdminService().getAllRootGroups();
            return groups.toArray(new Group[0]);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return new Group[0];
        }
    }

    public UserDetail[] getAllUsersOfGroup(String groupId) {
        try {
            return this.removeSensitiveData(this.getAdminService().getAllUsersOfGroup(groupId));
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return new UserDetail[0];
        }
    }

    @Override
    public List<String> getPathToGroup(String groupId) {
        try {
            return this.getAdminService().getPathToGroup(groupId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return new ArrayList<String>();
        }
    }

    @Override
    public String[] getAllSpaceIds(String sUserId) {
        try {
            return this.getAdminService().getAllSpaceIds(sUserId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return ArrayUtil.emptyStringArray();
        }
    }

    @Override
    public String[] getUserManageableSpaceIds(String sUserId) {
        try {
            return this.getAdminService().getUserManageableSpaceIds(sUserId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return ArrayUtil.emptyStringArray();
        }
    }

    @Override
    public String[] getAllRootSpaceIds() {
        try {
            return this.getAdminService().getAllRootSpaceIds();
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return ArrayUtil.emptyStringArray();
        }
    }

    @Override
    public String[] getAllRootSpaceIds(String sUserId) {
        try {
            return this.getAdminService().getAllRootSpaceIds(sUserId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return ArrayUtil.emptyStringArray();
        }
    }

    @Override
    public String[] getAllSubSpaceIds(String sSpaceId, String sUserId) {
        try {
            return this.getAdminService().getAllSubSpaceIds(sSpaceId, sUserId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return ArrayUtil.emptyStringArray();
        }
    }

    @Override
    public String[] getAllComponentIds(String sSpaceId) {
        try {
            return this.getAdminService().getAllComponentIds(sSpaceId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return ArrayUtil.emptyStringArray();
        }
    }

    @Override
    public String[] getAllComponentIdsRecur(String sSpaceId) {
        try {
            return this.getAdminService().getAllComponentIdsRecur(sSpaceId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return ArrayUtil.emptyStringArray();
        }
    }

    @Override
    public List<SpaceInstLight> getRootSpacesContainingComponent(String userId, String componentName) {
        try {
            return this.getAdminService().getRootSpacesContainingComponent(userId, componentName);
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)((Object)e));
            return new ArrayList<SpaceInstLight>();
        }
    }

    @Override
    public List<SpaceInstLight> getSubSpacesContainingComponent(String spaceId, String userId, String componentName) {
        try {
            return this.getAdminService().getSubSpacesContainingComponent(spaceId, userId, componentName);
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)((Object)e));
            return new ArrayList<SpaceInstLight>();
        }
    }

    @Override
    public boolean isAdminTool(String toolId) {
        return this.getAdminService().isAnAdminTool(toolId);
    }

    @Override
    public boolean isToolAvailable(String toolId) {
        return ToolInstance.from(toolId).isPresent();
    }

    @Override
    public List<String> getAvailableComponentsByUser(String userId) {
        try {
            return this.getAdminService().getAvailableComponentsByUser(userId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public boolean isComponentAvailableToUser(String componentId, String userId) {
        try {
            return this.getAdminService().isComponentAvailableToUser(componentId, userId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isComponentAvailableToGroup(String componentId, String groupId) {
        try {
            return this.getAdminService().isComponentAvailableToGroup(componentId, groupId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isComponentExist(String componentId) {
        try {
            return this.getAdminService().getComponentInstLight(componentId) != null;
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)((Object)e));
            return false;
        }
    }

    @Override
    public boolean isComponentManageable(String componentId, String userId) {
        try {
            return this.getAdminService().isComponentManageable(componentId, userId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isSpaceAvailable(String spaceId, String userId) {
        try {
            return this.getAdminService().isSpaceAvailable(userId, spaceId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public UserSpaceAvailabilityChecker getUserSpaceAvailabilityChecker(String userId) {
        try {
            return this.getAdminService().getUserSpaceAvailabilityChecker(userId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return new UserSpaceAvailabilityChecker(userId);
        }
    }

    @Override
    public boolean isObjectAvailableToUser(ProfiledObjectId objectId, String componentId, String userId) {
        try {
            return this.getAdminService().isObjectAvailableToUser(componentId, objectId, userId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isObjectAvailableToGroup(ProfiledObjectId objectId, String componentId, String groupId) {
        try {
            return this.getAdminService().isObjectAvailableToGroup(componentId, objectId, groupId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public List<SpaceInstLight> getSpaceTreeview(String userId) {
        try {
            return this.getAdminService().getUserSpaceTreeview(userId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return new ArrayList<SpaceInstLight>();
        }
    }

    @Override
    public String[] getAllowedSubSpaceIds(String userId, String spaceFatherId) {
        try {
            return this.getAdminService().getAllowedSubSpaceIds(userId, spaceFatherId);
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)((Object)e));
            return ArrayUtil.emptyStringArray();
        }
    }

    @Override
    public SpaceInstLight getRootSpace(String spaceId) {
        try {
            return this.getAdminService().getRootSpace(spaceId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String[] getAllUsersIds() {
        try {
            return this.getAdminService().getAllUsersIds();
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return new String[0];
        }
    }

    @Override
    public String[] getUsersIdsByRoleNames(String componentId, List<String> profileNames) {
        return this.getUsersIdsByRoleNames(componentId, profileNames, false);
    }

    @Override
    public String[] getUsersIdsByRoleNames(String componentId, List<String> profileNames, boolean includeRemovedUsersAndGroups) {
        try {
            ComponentInst componentInst = this.getComponentInst(componentId);
            List<ProfileInst> profiles = componentInst.getAllProfilesInst();
            List<String> profileIds = profiles.stream().filter(p -> profileNames.contains(p.getName())).map(BaseRightProfile::getId).collect(Collectors.toList());
            if (profileIds.isEmpty()) {
                return ArrayUtil.emptyStringArray();
            }
            List<String> userIds = this.getAdminService().searchUserIdsByProfile(profileIds, includeRemovedUsersAndGroups);
            return userIds.toArray(new String[0]);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return new String[0];
        }
    }

    @Override
    public String[] getUsersIdsByRoleNames(String componentId, ProfiledObjectId objectId, List<String> profileNames) {
        return this.getUsersIdsByRoleNames(componentId, objectId, profileNames, false);
    }

    @Override
    public String[] getUsersIdsByRoleNames(String componentId, ProfiledObjectId objectId, List<String> profileNames, boolean includeRemovedUsersAndGroups) {
        try {
            List<ProfileInst> profiles = this.getAdminService().getProfilesByObject(objectId, componentId);
            ArrayList<String> profileIds = new ArrayList<String>();
            for (ProfileInst profile : profiles) {
                if (!profileNames.contains(profile.getName())) continue;
                profileIds.add(profile.getId());
            }
            if (profileIds.isEmpty()) {
                return ArrayUtil.emptyStringArray();
            }
            List<String> userIds = this.getAdminService().searchUserIdsByProfile(profileIds, includeRemovedUsersAndGroups);
            return userIds.toArray(new String[0]);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return new String[0];
        }
    }

    @Override
    public Domain getDomain(String domainId) {
        try {
            return this.getAdminService().getDomain(domainId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public Domain[] getAllDomains() {
        try {
            return this.getAdminService().getAllDomains();
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return new Domain[0];
        }
    }

    @Override
    public List<GroupDetail> getDirectGroupsOfUser(String userId) {
        try {
            return this.getAdminService().getDirectGroupsOfUser(userId);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private ArrayList<String> recursiveMajListGroupId(String idGroup, ArrayList<String> listRes) {
        Group group = this.getGroup(idGroup);
        if (group.getSuperGroupId() != null) {
            listRes = this.recursiveMajListGroupId(group.getSuperGroupId(), listRes);
        }
        listRes.add(idGroup);
        return listRes;
    }

    @Override
    public String[] getAllGroupIdsOfUser(String userId) {
        try {
            ArrayList<String> listRes = new ArrayList<String>();
            List<GroupDetail> groups = this.getAdminService().getDirectGroupsOfUser(userId);
            for (GroupDetail group : groups) {
                listRes = this.recursiveMajListGroupId(group.getId(), listRes);
            }
            return listRes.toArray(new String[0]);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return ArrayUtil.emptyStringArray();
        }
    }

    @Override
    public String[] getAllowedComponentIds(String userId) {
        try {
            return this.getAdminService().getAvailCompoIds(userId);
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)((Object)e));
            return ArrayUtil.emptyStringArray();
        }
    }

    @Override
    public List<String> getSearchableComponentsByCriteria(ComponentSearchCriteria criteria) {
        List<String> componentIds;
        String userId = criteria.getUser().getId();
        if (criteria.hasCriterionOnWorkspace()) {
            if (criteria.hasCriterionOnComponentInstances()) {
                componentIds = new ArrayList<String>(criteria.getComponentInstanceIds());
            } else {
                String[] availableComponentIds = this.getAvailCompoIds(criteria.getWorkspaceId(), userId);
                componentIds = this.extractSearchableComponents(availableComponentIds, userId);
            }
        } else {
            String[] availableComponentIds = this.getAvailCompoIds(userId);
            componentIds = this.extractSearchableComponents(availableComponentIds, userId);
        }
        return componentIds;
    }

    private List<String> extractSearchableComponents(String[] availableComponentIds, String userId) {
        Set<String> excludedComponentIds = this.getComponentsExcludedFromGlobalSearch(userId);
        return Stream.of(availableComponentIds).filter(c -> !excludedComponentIds.contains(c)).collect(Collectors.toList());
    }

    private Set<String> getComponentsExcludedFromGlobalSearch(String userId) {
        HashSet<String> excluded = new HashSet<String>();
        List<String> spaces = this.getItemsExcludedFromGlobalSearch("SpacesExcludedFromGlobalSearch");
        for (String space : spaces) {
            String[] availableComponentIds = this.getAvailCompoIds(space, userId);
            excluded.addAll(Arrays.asList(availableComponentIds));
        }
        List<String> components = this.getItemsExcludedFromGlobalSearch("ComponentsExcludedFromGlobalSearch");
        excluded.addAll(components);
        this.getAdminService().getComponentsWithParameter("privateSearch", "yes").forEach(c -> excluded.add(c.getId()));
        return excluded;
    }

    private List<String> getItemsExcludedFromGlobalSearch(String parameterName) {
        SettingBundle searchSettings = ResourceLocator.getSettingBundle((String)"org.silverpeas.pdcPeas.settings.pdcPeasSettings");
        ArrayList<String> items = new ArrayList<String>();
        String param = searchSettings.getString(parameterName);
        if (StringUtil.isDefined((String)param)) {
            String[] componentIds = param.split(",");
            items.addAll(Arrays.asList(componentIds));
        }
        return items;
    }

    private Administration getAdminService() {
        return this.admin;
    }

    @Override
    public SpaceProfile getSpaceProfile(String spaceId, SilverpeasRole role) {
        try {
            return this.getAdminService().getSpaceProfile(spaceId, role);
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)((Object)e));
            return null;
        }
    }

    @Override
    public SpaceWithSubSpacesAndComponents getFullTreeview() throws AdminException {
        return this.getAdminService().getFullTreeview();
    }

    @Override
    public SpaceWithSubSpacesAndComponents getFullTreeview(String userId) throws AdminException {
        return this.getAdminService().getAllowedFullTreeview(userId);
    }

    @Override
    public SpaceWithSubSpacesAndComponents getFullTreeviewOnComponentName(String userId, String componentName) throws AdminException {
        return this.getAdminService().getAllowedFullTreeviewOnComponentName(userId, componentName);
    }

    @Override
    public SpaceWithSubSpacesAndComponents getFullTreeview(String userId, String spaceId) throws AdminException {
        return this.getAdminService().getAllowedFullTreeview(userId, spaceId);
    }

    @Override
    @NonNull
    public List<SpaceInstLight> getPathToSpace(@NonNull String spaceId) {
        return this.getPathToSpace(new ArrayList<SpaceInstLight>(), spaceId);
    }

    @NonNull
    private List<SpaceInstLight> getPathToSpace(@NonNull List<SpaceInstLight> path, @NonNull String spaceId) {
        try {
            SpaceInstLight spaceInst = this.getAdminService().getSpaceInstLightById(spaceId);
            if (spaceInst != null) {
                path.add(0, spaceInst);
                if (!spaceInst.isRoot()) {
                    path = this.getPathToSpace(path, spaceInst.getFatherId());
                }
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
        }
        return path;
    }

    @Override
    public List<SpaceInstLight> getPathToComponent(String componentId) {
        Optional<SilverpeasComponentInstance> componentInstance = this.getComponentInstance(componentId);
        if (componentInstance.isPresent() && !componentInstance.get().isPersonal()) {
            return this.getPathToSpace(componentInstance.get().getSpaceId());
        }
        return new ArrayList<SpaceInstLight>();
    }

    private UserDetail[] removeSensitiveData(UserDetail[] userDetails) {
        List<UserDetail> results = this.removeSensitiveData(Arrays.asList(userDetails));
        return results.toArray(new UserDetail[0]);
    }

    private <T extends UserDetail> List<T> removeSensitiveData(List<T> users) {
        User requester = User.getCurrentRequester();
        if (!users.isEmpty() && requester != null) {
            users.replaceAll(u -> this.removeSensitiveData(u, requester));
        }
        return users;
    }

    private <T extends UserDetail> T removeSensitiveData(T user, User requester) {
        if (user != null && requester != null && !requester.getId().equals(user.getId()) && this.hasNotDomainAdminRights(requester, user.getDomainId())) {
            return this.removeSensitiveDataForNonAdmin(user);
        }
        return user;
    }

    private <T extends UserDetail> T removeSensitiveDataForNonAdmin(T user) {
        if (user.hasSensitiveData()) {
            user.setEmailAddress("");
            if (user instanceof UserFull) {
                UserFull userFull = (UserFull)user;
                String[] properties = userFull.getPropertiesNames();
                Stream.of(properties).map(userFull::getProperty).filter(DomainProperty::isSensitive).forEach(p -> userFull.setValue(p.getName(), null));
            }
        }
        return user;
    }

    private boolean hasNotDomainAdminRights(User user, String domainId) {
        return !user.isAccessAdmin() && (!user.isAccessDomainManager() || !user.getDomainId().equals(domainId)) || user.isDomainRestricted() && user.isDomainAdminRestricted();
    }
}

