/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.persistence;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.domain.synchro.SynchroDomainReport;
import org.silverpeas.core.admin.persistence.Table;
import org.silverpeas.core.admin.persistence.UserRoleRow;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.kernel.logging.SilverLogger;

@Repository
public class UserRoleTable
extends Table<UserRoleRow> {
    public static final String REQUEST_MSG = ", requ\u00eate : ";
    private static final String USERROLE_COLUMNS = "id,instanceId,name,roleName,description,isInherited,objectId,objectType";
    public static final String SELECT = "select ";
    private static final String SELECT_USERROLE_BY_ID = "select id,instanceId,name,roleName,description,isInherited,objectId,objectType from ST_UserRole where id = ?";
    private static final String SELECT_USERROLE_BY_ROLENAME = "select id,instanceId,name,roleName,description,isInherited,objectId,objectType from ST_UserRole where instanceId = ? and isInherited = ? and rolename = ? and objectId is null";
    private static final String SELECT_ALL_INSTANCE_USERROLES = "select id,instanceId,name,roleName,description,isInherited,objectId,objectType from ST_UserRole where instanceId = ? ";
    private static final String SELECT_ALL_INSTANCE_USERROLE_IDS = "select id from ST_UserRole where instanceId = ? and objectId is null";
    private static final String SELECT_ALL_INSTANCE_OBJECT_USERROLE_IDS = "select id from ST_UserRole where instanceId = ? and objectId is not null";
    private static final String SELECT_ALL_OBJECT_USERROLE_IDS = "select id from ST_UserRole where instanceId = ? and objectId = ? and objectType = ? ";
    private static final String SELECT_USER_USERROLES = "select id,instanceId,name,roleName,description,isInherited,objectId,objectType from ST_UserRole, ST_UserRole_User_Rel where id = userRoleId and userId = ? ";
    private static final String SELECT_GROUP_USERROLES = "select id,instanceId,name,roleName,description,isInherited,objectId,objectType from ST_UserRole, ST_UserRole_Group_Rel where id = userRoleId and groupId = ? ";
    private static final String INSERT_USERROLE = "insert into ST_UserRole(id,instanceId,name,roleName,description,isInherited,objectId,objectType) values (?, ?, ?, ?, ?, ? ,? ,?)";
    private static final String UPDATE_USERROLE = "update ST_UserRole set name = ?, description = ? where id = ?";
    private static final String DELETE_USERROLE = "delete from ST_UserRole where id = ?";
    private static final String SELECT_COUNT_USERROLE_USER_REL = "select count(*) from ST_UserRole_User_Rel where userId = ? and userRoleId = ?";
    private static final String INSERT_A_USERROLE_USER_REL = "insert into ST_UserRole_User_Rel(userRoleId, userId) values(?,?)";
    private static final String DELETE_USERROLE_USER_REL = "delete from ST_UserRole_User_Rel where userRoleId = ? and userId = ?";
    private static final String DELETE_ALL_USERS_FROM_USERROLE = "delete from ST_UserRole_User_Rel where userRoleId = ? ";
    private static final String DELETE_ALL_GROUPS_FROM_USERROLE = "delete from ST_UserRole_Group_Rel where userRoleId = ? ";
    private static final String SELECT_COUNT_USERROLE_GROUP_REL = "select count(*) from ST_UserRole_Group_Rel where groupId = ? and userRoleId = ?";
    private static final String INSERT_A_USERROLE_GROUP_REL = "insert into ST_UserRole_Group_Rel(userRoleId, groupId) values(?,?)";
    private static final String DELETE_USERROLE_GROUP_REL = "delete from ST_UserRole_Group_Rel where userRoleId = ? and groupId = ?";

    public UserRoleTable() {
        super("ST_UserRole");
    }

    public UserRoleRow getUserRole(int id) throws SQLException {
        return (UserRoleRow)this.getUniqueRow(SELECT_USERROLE_BY_ID, id);
    }

    public UserRoleRow getUserRole(int instanceId, String roleName, int inherited) throws SQLException {
        ArrayList<Object> params = new ArrayList<Object>(3);
        params.add(instanceId);
        params.add(inherited);
        params.add(roleName);
        List userRoles = this.getRows(SELECT_USERROLE_BY_ROLENAME, params);
        if (userRoles.isEmpty()) {
            return null;
        }
        if (userRoles.size() >= 2) {
            SilverLogger.getLogger((Object)((Object)this)).error("Error more than 2 user roles found!", new Object[0]);
        }
        return (UserRoleRow)userRoles.get(0);
    }

    public UserRoleRow[] getAllUserRolesOfInstance(int instanceId) throws SQLException {
        List rows = this.getRows(SELECT_ALL_INSTANCE_USERROLES, instanceId);
        return rows.toArray(new UserRoleRow[0]);
    }

    public String[] getAllUserRoleIdsOfInstance(int instanceId) throws SQLException {
        List<String> ids = this.getIds(SELECT_ALL_INSTANCE_USERROLE_IDS, instanceId);
        return ids.toArray(new String[0]);
    }

    public String[] getAllObjectUserRoleIdsOfInstance(int instanceId) throws SQLException {
        List<String> ids = this.getIds(SELECT_ALL_INSTANCE_OBJECT_USERROLE_IDS, instanceId);
        return ids.toArray(new String[0]);
    }

    public String[] getAllUserRoleIdsOfObject(int objectId, String objectType, int instanceId) throws SQLException {
        ArrayList<Object> params = new ArrayList<Object>(3);
        params.add(instanceId);
        params.add(objectId);
        params.add(objectType);
        List<String> ids = this.getIds(SELECT_ALL_OBJECT_USERROLE_IDS, params);
        return ids.toArray(new String[0]);
    }

    public UserRoleRow[] getDirectUserRolesOfUser(int userId) throws SQLException {
        List rows = this.getRows(SELECT_USER_USERROLES, userId);
        return rows.toArray(new UserRoleRow[0]);
    }

    public UserRoleRow[] getDirectUserRolesOfGroup(int groupId) throws SQLException {
        List rows = this.getRows(SELECT_GROUP_USERROLES, groupId);
        return rows.toArray(new UserRoleRow[0]);
    }

    public void createUserRole(UserRoleRow userRole) throws SQLException {
        if (userRole.isInstanceIdNotDefined()) {
            throw new SQLException(SilverpeasExceptionMessages.unknown((String)"component instance", (Object)String.valueOf(userRole.getInstanceId())));
        }
        if (userRole.isObjectIdDefined() && !userRole.isObjectTypeDefined()) {
            throw new SQLException(SilverpeasExceptionMessages.undefined((String)"user role type"));
        }
        this.insertRow(INSERT_USERROLE, userRole);
    }

    protected void prepareInsert(String insertQuery, PreparedStatement insert, UserRoleRow row) throws SQLException {
        if (!row.isIdDefined()) {
            row.setId(this.getNextId());
        }
        insert.setInt(1, row.getId());
        insert.setInt(2, row.getInstanceId());
        insert.setString(3, this.truncate(row.getName(), 100));
        insert.setString(4, this.truncate(row.getRoleName(), 100));
        insert.setString(5, this.truncate(row.getDescription(), 500));
        insert.setInt(6, row.getInheritance());
        if (row.isObjectIdDefined()) {
            insert.setInt(7, row.getObjectId());
        } else {
            insert.setNull(7, 4);
        }
        if (row.isObjectTypeDefined()) {
            insert.setString(8, row.getObjectType());
        } else {
            insert.setNull(8, 12);
        }
    }

    public void updateUserRole(UserRoleRow userRole) throws SQLException {
        this.updateRow(UPDATE_USERROLE, userRole);
    }

    protected void prepareUpdate(String updateQuery, PreparedStatement update, UserRoleRow row) throws SQLException {
        update.setString(1, this.truncate(row.getName(), 100));
        update.setString(2, this.truncate(row.getDescription(), 500));
        update.setInt(3, row.getId());
    }

    public void removeUserRole(int id) throws SQLException {
        UserRoleRow userRole = this.getUserRole(id);
        if (userRole == null) {
            return;
        }
        this.removeAllGroupsFromUserRole(id);
        this.removeAllUsersFromUserRole(id);
        this.updateRelation(DELETE_USERROLE, id);
    }

    private boolean isUserDirectlyInRole(int userId, int userRoleId) throws SQLException {
        int[] ids = new int[]{userId, userRoleId};
        Integer result = this.getInteger(SELECT_COUNT_USERROLE_USER_REL, ids);
        return result != null && result >= 1;
    }

    public void addUserInUserRole(int userId, int userRoleId) throws SQLException {
        if (this.isUserDirectlyInRole(userId, userRoleId)) {
            return;
        }
        this.checkUserExistence(userId);
        UserRoleRow userRole = this.getUserRole(userRoleId);
        if (userRole == null) {
            throw new SQLException(SilverpeasExceptionMessages.unknown((String)"user role", (Object)String.valueOf(userRoleId)));
        }
        int[] params = new int[]{userRoleId, userId};
        this.updateRelation(INSERT_A_USERROLE_USER_REL, params);
    }

    public void removeUserFromUserRole(int userId, int userRoleId) throws SQLException {
        int[] params = new int[]{userRoleId, userId};
        SynchroDomainReport.debug("UserRoleTable.removeUserFromUserRole()", "Retrait de l'utilisateur d'ID " + userId + " du role d'ID " + userRoleId + ", requ\u00eate : delete from ST_UserRole_User_Rel where userRoleId = ? and userId = ?");
        this.updateRelation(DELETE_USERROLE_USER_REL, params);
    }

    public void removeAllUsersFromUserRole(int userRoleId) throws SQLException {
        SynchroDomainReport.debug("UserRoleTable.removeAllUsersFromUserRole()", "Retrait des utilisateurs du role d'ID " + userRoleId + ", requ\u00eate : delete from ST_UserRole_User_Rel where userRoleId = ? and userId = ?");
        this.updateRelation(DELETE_ALL_USERS_FROM_USERROLE, userRoleId);
    }

    public void removeAllGroupsFromUserRole(int userRoleId) throws SQLException {
        SynchroDomainReport.debug("UserRoleTable.removeAllGroupsFromUserRole()", "Retrait des groupes du role d'ID " + userRoleId + ", requ\u00eate : delete from ST_UserRole_User_Rel where userRoleId = ? and userId = ?");
        this.updateRelation(DELETE_ALL_GROUPS_FROM_USERROLE, userRoleId);
    }

    private boolean isGroupDirectlyInRole(int groupId, int userRoleId) throws SQLException {
        int[] ids = new int[]{groupId, userRoleId};
        Integer result = this.getInteger(SELECT_COUNT_USERROLE_GROUP_REL, ids);
        return result != null && result >= 1;
    }

    public void addGroupInUserRole(int groupId, int userRoleId) throws SQLException {
        if (this.isGroupDirectlyInRole(groupId, userRoleId)) {
            return;
        }
        this.checkGroupExistence(groupId);
        UserRoleRow userRole = this.getUserRole(userRoleId);
        if (userRole == null) {
            throw new SQLException(SilverpeasExceptionMessages.unknown((String)"role", (Object)String.valueOf(userRoleId)));
        }
        int[] params = new int[]{userRoleId, groupId};
        this.updateRelation(INSERT_A_USERROLE_GROUP_REL, params);
    }

    public void removeGroupFromUserRole(int groupId, int userRoleId) throws SQLException {
        int[] params = new int[]{userRoleId, groupId};
        SynchroDomainReport.debug("UserRoleTable.removeGroupFromUserRole()", "Retrait du groupe d'ID " + groupId + " du role d'ID " + userRoleId + ", requ\u00eate : delete from ST_UserRole_Group_Rel where userRoleId = ? and groupId = ?");
        this.updateRelation(DELETE_USERROLE_GROUP_REL, params);
    }

    protected UserRoleRow fetchRow(ResultSet rs) throws SQLException {
        return UserRoleRow.fetch(rs);
    }
}

