/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.persistence;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.silverpeas.core.admin.persistence.SpaceI18NRow;
import org.silverpeas.core.admin.persistence.Table;
import org.silverpeas.core.annotation.Repository;

@Repository
public class SpaceI18NTable
extends Table<SpaceI18NRow> {
    private static final String COLUMNS = "id,spaceId,lang,name,description";
    private static final String SELECT_TRANSLATIONS = "select id,spaceId,lang,name,description from ST_SpaceI18N where spaceId = ?";
    private static final String INSERT_TRANSLATION = "insert into ST_SpaceI18N(id,spaceId,lang,name,description) values  (?, ?, ?, ?, ?)";
    private static final String UPDATE_TRANSLATION = "update ST_SpaceI18N set name = ?, description = ?  WHERE id = ? ";
    private static final String DELETE_TRANSLATION = "delete from ST_SpaceI18N where id = ?";
    private static final String DELETE_TRANSLATIONS = "delete from ST_SpaceI18N where spaceId = ?";

    SpaceI18NTable() {
        super("ST_SpaceI18N");
    }

    protected SpaceI18NRow fetchTranslation(ResultSet rs) throws SQLException {
        SpaceI18NRow s = new SpaceI18NRow();
        s.setId(rs.getInt(1));
        s.setSpaceId(rs.getInt(2));
        s.setLang(rs.getString(3));
        s.setName(rs.getString(4));
        s.setDescription(rs.getString(5));
        return s;
    }

    public List<SpaceI18NRow> getTranslations(int spaceId) throws SQLException {
        return this.getRows(SELECT_TRANSLATIONS, spaceId);
    }

    public void createTranslation(SpaceI18NRow translation) throws SQLException {
        this.insertRow(INSERT_TRANSLATION, translation);
    }

    protected void prepareInsert(String insertQuery, PreparedStatement insert, SpaceI18NRow row) throws SQLException {
        row.setId(this.getNextId());
        insert.setInt(1, row.getId());
        insert.setInt(2, row.getSpaceId());
        insert.setString(3, row.getLang());
        insert.setString(4, this.truncate(row.getName(), 100));
        insert.setString(5, this.truncate(row.getDescription(), 500));
    }

    public void updateTranslation(SpaceI18NRow space) throws SQLException {
        this.updateRow(UPDATE_TRANSLATION, space);
    }

    protected void prepareUpdate(String updateQuery, PreparedStatement update, SpaceI18NRow row) throws SQLException {
        update.setString(1, this.truncate(row.getName(), 100));
        update.setString(2, this.truncate(row.getDescription(), 500));
        update.setInt(3, row.getId());
    }

    public void removeTranslation(int id) throws SQLException {
        this.updateRelation(DELETE_TRANSLATION, id);
    }

    public void removeTranslations(int spaceId) throws SQLException {
        this.updateRelation(DELETE_TRANSLATIONS, spaceId);
    }

    protected SpaceI18NRow fetchRow(ResultSet rs) throws SQLException {
        return this.fetchTranslation(rs);
    }
}

