/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.driver.sqldriver;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.silverpeas.core.admin.domain.driver.sqldriver.SQLSettings;
import org.silverpeas.core.admin.service.AdminException;

public class SQLGroupUserRelTable {
    private static final String SELECT = "select ";
    private static final String FROM = " from ";
    private static final String WHERE = " where ";
    private static final String DELETE_FROM = "delete from ";
    private final SQLSettings drvSettings;

    SQLGroupUserRelTable(SQLSettings ds) {
        this.drvSettings = ds;
    }

    List<String> getDirectUserIdsOfGroup(Connection c, int groupId) throws AdminException {
        String theQuery = SELECT + this.drvSettings.getRelUIDColumnName() + FROM + this.drvSettings.getRelTableName() + WHERE + this.drvSettings.getRelGIDColumnName() + " = ?";
        return this.executeSelectionQuery(c, theQuery, groupId);
    }

    private List<String> executeSelectionQuery(Connection c, String theQuery, int id) throws AdminException {
        ArrayList<String> theResult = new ArrayList<String>();
        try (PreparedStatement statement = c.prepareStatement(theQuery);){
            statement.setInt(1, id);
            try (ResultSet rs = statement.executeQuery();){
                while (rs.next()) {
                    theResult.add(Integer.toString(rs.getInt(1)));
                }
            }
        }
        catch (SQLException e) {
            throw new AdminException(e.getMessage(), e);
        }
        return theResult;
    }

    void createGroupUserRel(Connection c, int groupId, int userId) throws AdminException {
        String theQuery = "insert into " + this.drvSettings.getRelTableName() + "(" + this.drvSettings.getRelGIDColumnName() + "," + this.drvSettings.getRelUIDColumnName() + ")  values (?,?)";
        this.executeModificationQuery(c, theQuery, groupId, userId);
    }

    void removeGroupUserRel(Connection c, int groupId, int userId) throws AdminException {
        String theQuery = DELETE_FROM + this.drvSettings.getRelTableName() + WHERE + this.drvSettings.getRelGIDColumnName() + " = ? and " + this.drvSettings.getRelUIDColumnName() + " = ?";
        this.executeModificationQuery(c, theQuery, groupId, userId);
    }

    private void executeModificationQuery(Connection c, String theQuery, int groupId, int userId) throws AdminException {
        try (PreparedStatement statement = c.prepareStatement(theQuery);){
            statement.setInt(1, groupId);
            statement.setInt(2, userId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new AdminException(e.getMessage(), e);
        }
    }

    void removeAllUserRel(Connection c, int userId) throws AdminException {
        String theQuery = DELETE_FROM + this.drvSettings.getRelTableName() + WHERE + this.drvSettings.getRelUIDColumnName() + " = ?";
        this.executeModificationQuery(c, theQuery, userId);
    }

    void removeAllGroupRel(Connection c, int groupId) throws AdminException {
        String theQuery = DELETE_FROM + this.drvSettings.getRelTableName() + WHERE + this.drvSettings.getRelGIDColumnName() + " = ?";
        this.executeModificationQuery(c, theQuery, groupId);
    }

    private void executeModificationQuery(Connection c, String theQuery, int id) throws AdminException {
        try (PreparedStatement statement = c.prepareStatement(theQuery);){
            statement.setInt(1, id);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new AdminException(e.getMessage(), e);
        }
    }
}

