/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.driver.googledriver;

import java.util.Properties;
import org.silverpeas.core.admin.domain.DomainDriver;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

public class GoogleUserFilterManager
implements DomainDriver.UserFilterManager {
    private static final String USER_FILTER_RULE = "google.user.filter.rule";
    private final DomainDriver driver;
    private final SettingBundle settings;

    GoogleUserFilterManager(DomainDriver driver, SettingBundle settings) {
        this.driver = driver;
        this.settings = settings;
    }

    @Override
    public String getRuleKey() {
        return USER_FILTER_RULE;
    }

    @Override
    public String getRule() {
        return this.settings.getString(USER_FILTER_RULE, "");
    }

    @Override
    public User[] validateRule(String rule) throws AdminException {
        String previous = this.getRule();
        Properties properties = this.settings.asProperties();
        try {
            properties.setProperty(USER_FILTER_RULE, StringUtil.defaultStringIfNotDefined((String)rule));
            ResourceLocator.saveSettingBundle((SettingBundle)this.settings, (Properties)properties);
            User[] userArray = this.driver.getAllUsers();
            return userArray;
        }
        catch (Exception e) {
            throw new AdminException(e);
        }
        finally {
            properties.setProperty(USER_FILTER_RULE, previous);
            ResourceLocator.saveSettingBundle((SettingBundle)this.settings, (Properties)properties);
        }
    }

    @Override
    public User[] saveRule(String rule) throws AdminException {
        String previous = this.getRule();
        Properties properties = this.settings.asProperties();
        try {
            properties.setProperty(USER_FILTER_RULE, StringUtil.defaultStringIfNotDefined((String)rule));
            ResourceLocator.saveSettingBundle((SettingBundle)this.settings, (Properties)properties);
            return this.driver.getAllUsers();
        }
        catch (Exception e) {
            properties.setProperty(USER_FILTER_RULE, previous);
            ResourceLocator.saveSettingBundle((SettingBundle)this.settings, (Properties)properties);
            throw new AdminException(e);
        }
    }
}

