/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain;

import javax.inject.Named;
import javax.inject.Singleton;
import org.silverpeas.core.admin.domain.AbstractDomainService;
import org.silverpeas.core.admin.domain.exception.DomainConflictException;
import org.silverpeas.core.admin.domain.exception.DomainCreationException;
import org.silverpeas.core.admin.domain.exception.DomainDeletionException;
import org.silverpeas.core.admin.domain.model.Domain;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Singleton
@Named(value="externalDomainService")
public class ExternalDomainService
extends AbstractDomainService {
    @Override
    public String createDomain(Domain domainToCreate) throws DomainCreationException, DomainConflictException {
        try {
            this.checkDomainName(domainToCreate.getName());
        }
        catch (AdminException e) {
            throw new DomainCreationException(domainToCreate.toString(), (Throwable)((Object)e));
        }
        domainToCreate.setId("-1");
        String id = this.registerDomain(domainToCreate);
        if (!StringUtil.isDefined((String)id)) {
            throw new DomainCreationException(domainToCreate.toString(), new String[0]);
        }
        return id;
    }

    @Override
    public String deleteDomain(Domain domainToRemove) throws DomainDeletionException {
        String id = this.unRegisterDomain(domainToRemove);
        if (!StringUtil.isDefined((String)id)) {
            throw new DomainDeletionException(domainToRemove.toString(), new String[0]);
        }
        return id;
    }
}

