/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.component.model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.silverpeas.core.admin.component.model.Parameter;
import org.silverpeas.core.admin.component.model.ParameterSorter;

public class ParameterList
extends ArrayList<Parameter> {
    private static final long serialVersionUID = -2159180306618082474L;

    public static ParameterList copy(List<Parameter> parameters) {
        return new ParameterList(parameters.stream().map(Parameter::new).collect(Collectors.toList()));
    }

    public ParameterList() {
    }

    public ParameterList(List<Parameter> parameters) {
        super(parameters);
    }

    public void setValues(List<Parameter> parameters) {
        for (Parameter parameterToMerge : parameters) {
            Parameter parameter = this.getParameterByName(parameterToMerge.getName());
            if (parameter == null) continue;
            parameter.setValue(parameterToMerge.getValue());
        }
    }

    public List<Parameter> getVisibleParameters() {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (Parameter parameter : this) {
            if (!parameter.isVisible()) continue;
            parameters.add(parameter);
        }
        return parameters;
    }

    public List<Parameter> getHiddenParameters() {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (Parameter parameter : this) {
            if (!parameter.isHidden()) continue;
            parameters.add(parameter);
        }
        return parameters;
    }

    public void sort() {
        this.sort(new ParameterSorter());
    }

    private Parameter getParameterByName(String name) {
        for (Parameter param : this) {
            if (!param.getName().equals(name)) continue;
            return param;
        }
        return null;
    }

    public boolean isVisible() {
        for (Parameter param : this) {
            if (!param.isVisible()) continue;
            return true;
        }
        return false;
    }

    public ParameterList copy() {
        ParameterList copy = new ParameterList();
        this.stream().map(Parameter::new).forEach(copy::add);
        return copy;
    }
}

